/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.pysonar;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.sourceclear.analysis.utils.SetupPyParser;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.methods.VulnMethodsConfig;
import com.sourceclear.pysonar.AnalyzerState;
import com.sourceclear.pysonar.AstCache;
import com.sourceclear.pysonar.Binding;
import com.sourceclear.pysonar.Builtins;
import com.sourceclear.pysonar.Diagnostic;
import com.sourceclear.pysonar.PythonProjectFileVisitor;
import com.sourceclear.pysonar.State;
import com.sourceclear.pysonar.Utils;
import com.sourceclear.pysonar.ast.FunctionDef;
import com.sourceclear.pysonar.ast.Name;
import com.sourceclear.pysonar.ast.Node;
import com.sourceclear.pysonar.ast.Pass;
import com.sourceclear.pysonar.ast.Url;
import com.sourceclear.pysonar.types.BoolType;
import com.sourceclear.pysonar.types.ClassType;
import com.sourceclear.pysonar.types.ComplexType;
import com.sourceclear.pysonar.types.FloatType;
import com.sourceclear.pysonar.types.FunType;
import com.sourceclear.pysonar.types.InstanceType;
import com.sourceclear.pysonar.types.IntType;
import com.sourceclear.pysonar.types.ModuleType;
import com.sourceclear.pysonar.types.StrType;
import com.sourceclear.pysonar.types.Type;
import com.sourceclear.pysonar.types.UnionType;
import com.sourceclear.pysonar.visitor.CallGraphVisitor;
import com.sourceclear.pysonar.visitor.TypeInferencer;
import com.sourceclear.util.security.SecurityUtils;
import com.veracode.security.logging.SecureLogger;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Analyzer
implements Closeable {
    private static final SecureLogger LOGGER = SecureLogger.getLogger(Analyzer.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final TypeReference<List<MethodInfo>> LIST_METHOD_INFO = new TypeReference<List<MethodInfo>>(){};
    private static final Comparator<MethodInfo> METHOD_MODULE_NAME_LENGTH = new Comparator<MethodInfo>(){

        @Override
        public int compare(MethodInfo o1, MethodInfo o2) {
            int o1Length = o1 == null || o1.getModuleName() == null ? 0 : o1.getModuleName().length();
            int o2Length = o2 == null || o2.getModuleName() == null ? 0 : o2.getModuleName().length();
            return o2Length - o1Length;
        }
    };
    public final AnalyzerState state;
    public final TypeInferencer inferencer = new TypeInferencer(this);
    public final State moduleTable = new State(this, null, State.StateType.GLOBAL);
    public final State globaltable = new State(this, null, State.StateType.GLOBAL);
    public final Builtins builtins = new Builtins(this);
    public final InstanceType TYPE_UNKNOWN = new InstanceType(this, new ClassType(this, "?", null, null));
    public final InstanceType TYPE_CONT = new InstanceType(this, new ClassType(this, "None", null, null));
    public final InstanceType TYPE_NONE = new InstanceType(this, new ClassType(this, "None", null, null));
    public final StrType TYPE_STR = new StrType(this, null);
    public final IntType TYPE_INT = new IntType(this);
    public final FloatType TYPE_FLOAT = new FloatType(this);
    public final ComplexType TYPE_COMPLEX = new ComplexType(this);
    public final BoolType TYPE_BOOL = new BoolType(this, BoolType.Value.Undecided);
    private final CallGraphVisitor callGraphVisitor = new CallGraphVisitor(this);
    private final AstCache astCache;
    private final Node PASS = new Pass(this, Paths.get("", new String[0]), 0, 0, 0);
    private final VulnMethodsConfig config;
    public Path cwd = null;
    public int nCalled = 0;
    public Path projectDir;

    public Analyzer() throws IOException {
        this(VulnMethodsConfig.Builder.python().build());
    }

    public Analyzer(VulnMethodsConfig config) throws IOException {
        this.config = config;
        this.state = new AnalyzerState();
        this.builtins.init();
        this.addPythonPath();
        this.astCache = new AstCache(this);
    }

    public void analyze(Path path) throws IOException {
        this.resolveProjectDirectory(path);
        this.loadFileRecursive(this.projectDir);
    }

    public void init(Path path) throws IOException {
        this.resolveProjectDirectory(path);
    }

    @Nullable
    @VisibleForTesting
    Path checkForSetupPy(Path directory) throws IOException {
        Path setupPy = directory.resolve(Paths.get("setup.py", new String[0]));
        if (Files.exists(setupPy, new LinkOption[0])) {
            try {
                return SetupPyParser.getSpecifiedRoot(setupPy);
            }
            catch (ParseException e) {
                LOGGER.trace("Could not parse setup.py", e);
            }
        }
        return null;
    }

    private void resolveProjectDirectory(Path path) throws IOException {
        Path candidate;
        Path absPath = path.toAbsolutePath();
        Path root = Files.isDirectory(absPath, new LinkOption[0]) ? absPath : absPath.getParent();
        Path specifiedRoot = this.checkForSetupPy(path);
        if (specifiedRoot != null && Files.exists(candidate = root.resolve(specifiedRoot), new LinkOption[0])) {
            this.projectDir = candidate;
            return;
        }
        LOGGER.debug("Couldn't figure out the root of package source directory from setup.py. Analyzer will fall back to the project root directory.");
        this.projectDir = root;
    }

    public static List<MethodInfo> loadPublicMethodStubs(Path path) {
        ArrayList<MethodInfo> publicMethods = new ArrayList();
        try {
            publicMethods = (List)MAPPER.readValue(Files.readAllBytes(path), LIST_METHOD_INFO);
        }
        catch (IOException e) {
            LOGGER.warn("Could not read public methods stub file", e);
        }
        return publicMethods;
    }

    @NotNull
    private Type constructModuleType(Path baseDirectory, MethodInfo publicMethod, Map<String, Type> libraryModules) {
        assert (publicMethod.getModuleName() != null);
        String moduleName = publicMethod.getModuleName();
        Type moduleType = null;
        if (libraryModules.containsKey(moduleName)) {
            moduleType = libraryModules.get(moduleName);
        } else {
            List<String> segmentedModuleName = Utils.splitQname(moduleName);
            for (int i = 0; i < segmentedModuleName.size(); ++i) {
                boolean shouldSuffix = i == segmentedModuleName.size() - 1;
                String module = Utils.joinQname(segmentedModuleName.subList(0, i + 1));
                Path fileName = baseDirectory.resolve(SecurityUtils.securePathsGet(module.substring(1).replaceAll("\\.", "/") + (shouldSuffix ? ".py" : ""), new String[0]));
                if (moduleType == null) {
                    moduleType = new ModuleType(this, module, fileName, this.globaltable);
                } else {
                    ModuleType currentModule = new ModuleType(this, module, fileName, moduleType.table);
                    moduleType.table.insert(Utils.baseQname(module), this.PASS, currentModule, Binding.Kind.VARIABLE);
                    moduleType = currentModule;
                }
                libraryModules.put(module, moduleType);
            }
        }
        assert (moduleType != null);
        return moduleType;
    }

    @NotNull
    private ClassType constructClassType(MethodInfo publicMethod, Type moduleType) {
        boolean hasExistingBinding;
        assert (publicMethod.getClassName() != null);
        ClassType result = null;
        String className = publicMethod.getClassName();
        Map<String, Set<Binding>> moduleTable = moduleType.table.table;
        boolean foundClass = false;
        boolean bl = hasExistingBinding = moduleTable.containsKey(className) && !moduleTable.get(className).isEmpty();
        if (hasExistingBinding) {
            Set<Binding> classBindings = moduleTable.get(className);
            for (Binding classBinding : classBindings) {
                if (!(classBinding.type instanceof ClassType)) continue;
                if (result == null) {
                    foundClass = true;
                    result = (ClassType)classBinding.type;
                    continue;
                }
                if (result == classBinding.type) continue;
                throw new IllegalStateException("Could not load public method stub for " + publicMethod.toString());
            }
        }
        if (!foundClass) {
            result = new ClassType(this, className, moduleType.table);
            Binding classBinding = new Binding(this, className, this.PASS, result, Binding.Kind.CLASS);
            if (moduleTable.containsKey(className)) {
                moduleTable.get(className).add(classBinding);
            } else {
                moduleTable.put(className, new HashSet<Binding>(Collections.singletonList(classBinding)));
            }
        }
        return result;
    }

    public Map<String, Type> loadPublicMethods(Path path, List<MethodInfo> stubs) {
        List<MethodInfo> nonNullMethodStubs = this.filterNonNullMethods(stubs);
        Collections.sort(nonNullMethodStubs, METHOD_MODULE_NAME_LENGTH);
        HashMap<String, Type> libraryModules = new HashMap<String, Type>();
        for (MethodInfo publicMethod : nonNullMethodStubs) {
            String qualifiedModuleName = Utils.moduleQname(path) + publicMethod.getModuleName();
            Path moduleFileName = Paths.get(qualifiedModuleName.replaceAll("\\.", "/") + ".py", new String[0]);
            Type moduleType = this.constructModuleType(path, publicMethod, libraryModules);
            FunctionDef functionDef = new FunctionDef(this, new Name(this, publicMethod.getMethodName()), new ArrayList<Node>(), this.PASS, new ArrayList<Node>(), null, null, moduleFileName, false, 0, 0, 0);
            if (publicMethod.getClassName() != null) {
                ClassType classType = this.constructClassType(publicMethod, moduleType);
                FunType tempType = new FunType(this, functionDef, classType.table.getForwarding());
                tempType.table.setParent(classType.table);
                tempType.table.setPath(moduleType.table.extendPath(publicMethod.getMethodName()));
                tempType.setCls(classType);
                Binding functionBinding = new Binding(this, publicMethod.getMethodName(), this.PASS, tempType, Binding.Kind.METHOD);
                Map<String, Set<Binding>> classTable = classType.table.table;
                String methodName = publicMethod.getMethodName();
                if (classTable.containsKey(methodName)) {
                    classTable.get(methodName).add(functionBinding);
                    continue;
                }
                classTable.put(methodName, new HashSet<Binding>(Collections.singletonList(functionBinding)));
                continue;
            }
            FunType tempType = new FunType(this, functionDef, moduleType.table);
            tempType.table.setParent(moduleType.table);
            tempType.table.setPath(moduleType.table.extendPath(publicMethod.getMethodName()));
            Binding functionBinding = new Binding(this, publicMethod.getMethodName(), this.PASS, tempType, Binding.Kind.FUNCTION);
            Map<String, Set<Binding>> moduleTable = moduleType.table.table;
            String methodName = publicMethod.getMethodName();
            if (moduleTable.containsKey(methodName)) {
                moduleTable.get(methodName).add(functionBinding);
                continue;
            }
            moduleTable.put(methodName, new HashSet<Binding>(Collections.singletonList(functionBinding)));
        }
        return libraryModules;
    }

    private List<MethodInfo> filterNonNullMethods(List<MethodInfo> methods) {
        ArrayList<MethodInfo> result = new ArrayList<MethodInfo>();
        for (MethodInfo method : methods) {
            if (method == null || method.getModuleName() == null) continue;
            result.add(method);
        }
        return result;
    }

    public void unionPublicMethods(Map<String, Type> additions) {
        for (Map.Entry<String, Type> entry : additions.entrySet()) {
            this.state.addPublicMethod(entry.getKey(), entry.getValue());
        }
    }

    public void stubPublicMethods(Path path, List<MethodInfo> stubs) {
        Map<String, Type> additions = this.loadPublicMethods(path, stubs);
        this.unionPublicMethods(additions);
    }

    public void analyzeCallGraph(Path path) throws IOException {
        this.analyze(path);
        this.finish();
        if (Files.isDirectory(path, new LinkOption[0])) {
            try {
                Files.walkFileTree(this.projectDir, new PythonProjectFileVisitor(this.config){

                    @Override
                    public FileVisitResult visitPythonFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Analyzer.this.analyzeCallGraphForFile(file);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                LOGGER.error("Failed to load project files in: {}", (Object)this.projectDir, (Object)e);
                throw e;
            }
        } else if (Utils.isPythonFile(path)) {
            this.analyzeCallGraphForFile(path);
        } else {
            LOGGER.info("File {} is not a python file, nothing loaded.", (Object)path);
        }
    }

    private void analyzeCallGraphForFile(Path path) throws IOException {
        if (Files.isReadable(path)) {
            Node ast = this.getAstForFile(path);
            this.callGraphVisitor.visit(ast);
            this.state.addMethods(this.callGraphVisitor.getMethods());
        }
    }

    private void setCWD(Path cd) throws IOException {
        if (cd != null) {
            try {
                this.cwd = cd.toRealPath(new LinkOption[0]);
            }
            catch (IOException e) {
                LOGGER.error("Unable to set current working directory to {}.", (Object)cd.toString(), (Object)e);
                throw e;
            }
        }
    }

    private void addPythonPath() {
        String path = System.getenv("PYTHONPATH");
        if (path != null) {
            String[] segments;
            for (String p : segments = path.split(File.pathSeparator)) {
                Path pythonPath = Paths.get(p, new String[0]);
                if (pythonPath.toAbsolutePath().normalize().equals(pythonPath)) {
                    this.state.addPath(pythonPath);
                    continue;
                }
                LOGGER.debug("Ignoring unacceptable path " + pythonPath + " in PYTHONPATH.");
            }
        }
    }

    @NotNull
    public List<Path> getLoadPath() {
        ArrayList<Path> loadPath = new ArrayList<Path>();
        if (this.cwd != null) {
            loadPath.add(this.cwd);
        }
        if (this.projectDir != null && Files.isDirectory(this.projectDir, new LinkOption[0])) {
            loadPath.add(this.projectDir);
        }
        loadPath.addAll(this.state.getLoadPathAdditions());
        return loadPath;
    }

    @Nullable
    ModuleType getCachedModule(Path path) {
        Type t = this.moduleTable.lookupType(Utils.moduleQname(path));
        if (t == null) {
            return null;
        }
        if (t instanceof UnionType) {
            for (Type tt : ((UnionType)t).types) {
                if (!(tt instanceof ModuleType)) continue;
                return (ModuleType)tt;
            }
            return null;
        }
        if (t instanceof ModuleType) {
            return (ModuleType)t;
        }
        return null;
    }

    public void putProblem(@NotNull Node loc, String msg) {
        Path file = loc.getFile();
        if (file != null) {
            this.addFileErr(file, loc.start, loc.end, msg);
        }
    }

    public void putProblem(@Nullable Path file, int begin, int end, String msg) {
        if (file != null) {
            this.addFileErr(file, begin, end, msg);
        }
    }

    void addFileErr(Path file, int begin, int end, String msg) {
        Diagnostic d = new Diagnostic(file, Diagnostic.Category.ERROR, begin, end, msg);
        this.getFileErrs(file, this.state.getAllSemanticErrors()).add(d);
    }

    List<Diagnostic> getFileErrs(Path file, @NotNull Map<Path, List<Diagnostic>> map) {
        List<Diagnostic> msgs = map.get(file);
        if (msgs == null) {
            msgs = new ArrayList<Diagnostic>();
            map.put(file, msgs);
        }
        return msgs;
    }

    @Nullable
    public Type loadFile(Path path) throws IOException {
        if (!Files.isReadable(path)) {
            return null;
        }
        ModuleType module = this.getCachedModule(path);
        if (module != null) {
            return module;
        }
        if (this.state.inImportStack(path)) {
            return null;
        }
        Path oldcwd = this.cwd;
        this.setCWD(path.getParent());
        this.state.pushImportStack(path);
        Type type = this.parseAndResolve(path);
        this.state.popImportStack(path);
        this.setCWD(oldcwd);
        return type;
    }

    @Nullable
    private Type parseAndResolve(Path file) throws IOException {
        Node ast = this.getAstForFile(file);
        if (ast == null) {
            return null;
        }
        Type type = (Type)this.inferencer.visit(ast, this.moduleTable);
        return type;
    }

    @Nullable
    public Node getAstForFile(Path file) throws IOException {
        return this.astCache.getAST(file);
    }

    @Nullable
    public ModuleType getBuiltinModule(@NotNull String qname) {
        return this.builtins.get(qname);
    }

    @Nullable
    public String makeQname(@NotNull List<Name> names) {
        if (names.isEmpty()) {
            return "";
        }
        String ret = "";
        for (int i = 0; i < names.size() - 1; ++i) {
            ret = ret + names.get((int)i).id + ".";
        }
        ret = ret + names.get((int)(names.size() - 1)).id;
        return ret;
    }

    public Path locateModule(String headName) {
        List<Path> loadPath = this.getLoadPath();
        for (Path p : loadPath) {
            if (!p.toAbsolutePath().normalize().equals(p.toAbsolutePath())) {
                LOGGER.debug("Ignoring unacceptable load path " + p);
                continue;
            }
            Path startDir = SecurityUtils.securePathsResolve(p, headName);
            Path initPath = startDir.resolve("__init__.py");
            if (Files.exists(initPath, new LinkOption[0])) {
                return p;
            }
            Path startFile = Paths.get(startDir.toAbsolutePath().toString() + ".py", new String[0]);
            if (!Files.exists(startFile, new LinkOption[0])) continue;
            return p;
        }
        return null;
    }

    @Nullable
    public Type loadModule(@NotNull List<Name> name, @NotNull State state) throws IOException {
        if (name.isEmpty()) {
            return null;
        }
        String qname = this.makeQname(name);
        ModuleType mt = this.getBuiltinModule(qname);
        if (mt != null) {
            state.insert(name.get((int)0).id, new Url(this, "http://docs.python.org/library/" + mt.table.path + ".html"), mt, Binding.Kind.SCOPE);
            return mt;
        }
        assert (!name.isEmpty());
        Type prev = null;
        Path startPath = this.locateModule(name.get((int)0).id);
        if (startPath == null) {
            ArrayList<String> fullName = new ArrayList<String>();
            for (Name n : name) {
                fullName.add(n.id);
            }
            String qualifiedName = Utils.joinQname(fullName);
            Type moduleType = this.state.getPublicMethodType(qualifiedName);
            if (moduleType == null) {
                return null;
            }
            state.insert(Utils.baseQname(qualifiedName), name.get(0), moduleType, Binding.Kind.VARIABLE);
            return moduleType;
        }
        Path path = Paths.get(startPath.toAbsolutePath().toString(), new String[0]);
        for (int i = 0; i < name.size(); ++i) {
            Path initPath = (path = SecurityUtils.securePathsResolve(path, name.get((int)i).id)).toAbsolutePath().resolve("__init__.py");
            if (Files.exists(initPath, new LinkOption[0]) && !Files.isDirectory(initPath, new LinkOption[0])) {
                Type mod = this.loadFile(initPath);
                if (mod == null) {
                    return null;
                }
                if (prev != null) {
                    prev.table.insert(name.get((int)i).id, name.get(i), mod, Binding.Kind.VARIABLE);
                } else {
                    state.insert(name.get((int)i).id, name.get(i), mod, Binding.Kind.VARIABLE);
                }
                prev = mod;
                continue;
            }
            if (i != name.size() - 1) continue;
            Path startFile = Paths.get(path + ".py", new String[0]);
            if (Files.exists(startFile, new LinkOption[0]) && !Files.isDirectory(startFile, new LinkOption[0])) {
                Type mod = this.loadFile(startFile);
                if (mod == null) {
                    return null;
                }
                if (prev != null) {
                    prev.table.insert(name.get((int)i).id, name.get(i), mod, Binding.Kind.VARIABLE);
                } else {
                    state.insert(name.get((int)i).id, name.get(i), mod, Binding.Kind.VARIABLE);
                }
                prev = mod;
                continue;
            }
            return null;
        }
        return prev;
    }

    private void loadFileRecursive(Path fullname) throws IOException {
        if (Files.isDirectory(fullname, new LinkOption[0])) {
            try {
                Files.walkFileTree(fullname, new PythonProjectFileVisitor(this.config){

                    @Override
                    public FileVisitResult visitPythonFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Analyzer.this.loadFile(file);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IOException("Failed to load project files: " + fullname, e);
            }
        } else if (Utils.isPythonFile(fullname)) {
            this.loadFile(fullname);
        } else {
            LOGGER.info("File is not a python file. Nothing loaded.");
        }
    }

    public void finish() throws IOException {
        this.applyUncalled();
        for (List<Binding> bset : Utils.correlateBindings(this.state.getAllBindings())) {
            if (!this.unusedBindingSet(bset)) continue;
            Binding first = bset.get(0);
            this.putProblem(first.node, "Unused variable: " + first.name);
        }
    }

    private boolean unusedBindingSet(List<Binding> bindings) {
        for (Binding binding : bindings) {
            if (this.unused(binding)) continue;
            return false;
        }
        return true;
    }

    private boolean unused(Binding binding) {
        return !(binding.type instanceof ClassType) && !(binding.type instanceof FunType) && !(binding.type instanceof ModuleType) && binding.refs.isEmpty();
    }

    @Override
    public void close() {
        try {
            this.astCache.close();
        }
        catch (IOException e) {
            LOGGER.warn("Failed to clean up AST cache", e);
        }
    }

    public void applyUncalled() throws IOException {
        while (this.state.hasUncalledFunctions()) {
            List<FunType> uncalled = this.state.getUncalledFunctions();
            for (FunType cl : uncalled) {
                this.inferencer.apply(cl, null, null, null, null, null);
            }
        }
    }

    @NotNull
    public Type newUnion(@NotNull Collection<Type> types) {
        Type t = this.TYPE_UNKNOWN;
        for (Type nt : types) {
            t = this.union(t, nt);
        }
        return t;
    }

    public Type makeUnion(Set<Binding> bs) {
        Type t = this.TYPE_UNKNOWN;
        for (Binding b : bs) {
            t = this.union(t, b.type);
        }
        return t;
    }

    @NotNull
    public Type union(@NotNull Type u, @NotNull Type v) {
        if (u.equals(v)) {
            return u;
        }
        if (u != this.TYPE_UNKNOWN && v == this.TYPE_UNKNOWN) {
            return u;
        }
        if (v != this.TYPE_UNKNOWN && u == this.TYPE_UNKNOWN) {
            return v;
        }
        if (u != this.TYPE_NONE && v == this.TYPE_NONE) {
            return u;
        }
        if (v != this.TYPE_NONE && v == this.TYPE_NONE) {
            return v;
        }
        return new UnionType(this, u, v);
    }

    public Type union(Collection<Type> types) {
        Type result = this.TYPE_UNKNOWN;
        for (Type type : types) {
            result = this.union(result, type);
        }
        return result;
    }

    public Type union(Type ... types) {
        return this.union(types);
    }
}

