/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.publicmethods.v2;

import com.google.common.base.Strings;
import com.sourceclear.analysis.dotnet.SrcDotV2;
import com.sourceclear.analysis.utils.Utils;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.methods.MethodInfoImpl;
import com.sourceclear.methods.VulnMethodsConfig;
import com.sourceclear.publicmethods.java.JavaVisitor;
import com.sourceclear.publicmethods.python.PythonMethodVisitor;
import com.sourceclear.publicmethods.python.PythonProjectAnalysis;
import com.sourceclear.publicmethods.ruby.RubyMethodsVisitor;
import com.sourceclear.pysonar.Analyzer;
import com.sourceclear.pysonar.ast.Node;
import io.vavr.Tuple2;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.jar.JarInputStream;
import org.objectweb.asm.ClassVisitor;

public class PublicMethodsV2 {
    private PublicMethodsV2() {
    }

    public static MethodInfo pythonMethod(String moduleName, String className, String methodName) {
        return MethodInfoImpl.builder().withModuleName(moduleName).withClassName(className).withMethodName(methodName).build();
    }

    public static List<MethodInfo> findDotNet(Path fileOrDirectory) throws IOException {
        return new PublicMethodsV2().findDotNetPublicMethods(fileOrDirectory);
    }

    public static List<MethodInfo> findDotNet(InputStream nupkgStream) throws IOException {
        return new PublicMethodsV2().findDotNetPublicMethods(nupkgStream);
    }

    public static List<MethodInfo> findPython(Path fileOrDirectory) throws IOException {
        return new PublicMethodsV2().findPythonPublicMethods(fileOrDirectory);
    }

    public static List<MethodInfo> findRuby(Path fileOrDirectory) throws IOException {
        return new PublicMethodsV2().findRubyPublicMethods(fileOrDirectory);
    }

    public static List<MethodInfo> findJava(Path fileOrDirectory) throws IOException {
        return new PublicMethodsV2().findJavaPublicMethods(fileOrDirectory);
    }

    public static List<MethodInfo> findJava(InputStream jarStream) throws IOException {
        return new PublicMethodsV2().findJavaPublicMethods(jarStream);
    }

    public static List<MethodInfo> findPython(InputStream archiveStream) throws IOException {
        return Utils.processPythonArchive(archiveStream, PublicMethodsV2::findPython);
    }

    public static List<MethodInfo> findRuby(InputStream archiveStream) throws IOException {
        return Utils.processRubyGemsArchive(archiveStream, PublicMethodsV2::findRuby);
    }

    private List<MethodInfo> findRubyPublicMethods(Path fileOrDirectory) throws IOException {
        final ArrayList<MethodInfo> result = new ArrayList<MethodInfo>();
        com.sourceclear.rubysonar.Analyzer analyzer = new com.sourceclear.rubysonar.Analyzer(VulnMethodsConfig.Builder.ruby().build());
        RubyMethodsVisitor visitor2 = new RubyMethodsVisitor(){

            @Override
            public void visitMethod(MethodInfo methodInfo, org.jrubyparser.ast.Node body) {
                result.add(methodInfo);
            }
        };
        analyzer.addVisitor(visitor2);
        analyzer.analyze(fileOrDirectory);
        analyzer.finish();
        return result;
    }

    private List<MethodInfo> findPythonPublicMethods(Path fileOrDirectory) throws IOException {
        final ArrayList result = new ArrayList();
        new PythonProjectAnalysis(fileOrDirectory, VulnMethodsConfig.Builder.python().build()){

            @Override
            public void analyseSourceFile(Analyzer analyzer, Path projectDir, Path sourceFile) throws IOException {
                result.addAll(PublicMethodsV2.analysePythonSourceFile(analyzer, projectDir, sourceFile));
            }
        }.run();
        ArrayList<MethodInfo> processedResult = new ArrayList<MethodInfo>();
        for (MethodInfo publicMethod : result) {
            boolean isLambda = publicMethod.getMethodName().contains("%");
            if (isLambda) continue;
            processedResult.add(publicMethod);
        }
        return processedResult;
    }

    private static List<MethodInfo> analysePythonSourceFile(Analyzer analyzer, Path projectDir, Path sourceFile) throws IOException {
        String qualifiedModuleName = Strings.emptyToNull((String)com.sourceclear.pysonar.Utils.getQualifiedModuleName(projectDir, sourceFile));
        Node root = analyzer.getAstForFile(sourceFile);
        final ArrayList<MethodInfo> result = new ArrayList<MethodInfo>();
        new PythonMethodVisitor(qualifiedModuleName){

            @Override
            public void visitMethod(MethodInfo method, Node body) {
                result.add(method);
            }
        }.visit(root);
        return result;
    }

    private List<MethodInfo> findJavaPublicMethods(Path jarFilePath) throws IOException {
        return this.findJavaPublicMethods(new FileInputStream(jarFilePath.toAbsolutePath().toString()));
    }

    private List<MethodInfo> findJavaPublicMethods(InputStream jarFile) throws IOException {
        ArrayList<MethodInfo> arrayList;
        JarInputStream jis = new JarInputStream(jarFile);
        try {
            ArrayList<MethodInfo> result = new ArrayList<MethodInfo>();
            Utils.readEntries(jis, classReader -> {
                JavaVisitor cl = new JavaVisitor();
                classReader.accept((ClassVisitor)cl, 0);
                result.addAll(cl.getResult());
                return Optional.empty();
            });
            arrayList = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new IOException("Error reading bytecode", e);
            }
        }
        jis.close();
        return arrayList;
    }

    private List<MethodInfo> findDotNetPublicMethods(Path dllPath) throws IOException {
        try {
            return new ArrayList<MethodInfo>(SrcDotV2.getPublicMethods((Path)dllPath));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private List<MethodInfo> findDotNetPublicMethods(InputStream nupkgStream) throws IOException {
        boolean noPublicMethodsAndErrorOccurred;
        Tuple2 pair = Utils.readDlls(nupkgStream, paths -> {
            HashSet<MethodInfo> result = new HashSet<MethodInfo>();
            Optional<Object> exception = Optional.empty();
            for (Path path : paths) {
                try {
                    result.addAll(this.findDotNetPublicMethods(path));
                }
                catch (IOException e) {
                    exception = Optional.of(e);
                }
            }
            return new Tuple2(result, exception);
        });
        boolean bl = noPublicMethodsAndErrorOccurred = ((HashSet)pair._1()).isEmpty() && ((Optional)pair._2()).isPresent();
        if (noPublicMethodsAndErrorOccurred) {
            throw new IOException((Throwable)((Optional)pair._2()).get());
        }
        return new ArrayList<MethodInfo>((Collection)pair._1());
    }
}

