/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods.ruby;

import com.sourceclear.analysis.utils.Utils;
import com.sourceclear.methods.Cleaner;
import com.sourceclear.methods.EntryPointResolver;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.methods.MethodScanner;
import com.sourceclear.methods.MethodScannerFactory;
import com.sourceclear.methods.VulnMethodsConfig;
import com.sourceclear.methods.VulnerablePartsDetector;
import com.sourceclear.methods.ruby.RubyCallGraphBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;

public class RubyMethodScannerFactory
extends MethodScannerFactory {
    @Override
    public VulnMethodsConfig.Builder defaultVulnMethodsConfig() {
        return VulnMethodsConfig.Builder.ruby();
    }

    @Override
    public MethodScanner forArchiveStream(InputStream archiveStream, Collection<MethodInfo> vulnerableMethods, EntryPointResolver entryPointResolver) throws IOException {
        Path gemDir = Files.createTempDirectory("gem-archive", new FileAttribute[0]);
        try {
            VulnerablePartsDetector vulnerablePartsDetector;
            block11: {
                ArchiveInputStream archiveInputStream = new ArchiveStreamFactory().createArchiveInputStream("tar", archiveStream);
                try {
                    Utils.unarchiveIntoDirectory(archiveInputStream, gemDir);
                    Path dataDir = Utils.lookForDataTarAndUnarchive(gemDir);
                    RubyCallGraphBuilder rubyCallGraphBuilder = new RubyCallGraphBuilder(dataDir, this.input.publicMethods(), this.config);
                    vulnerablePartsDetector = new VulnerablePartsDetector(vulnerableMethods, entryPointResolver, rubyCallGraphBuilder, this.input, () -> FileUtils.deleteQuietly((File)gemDir.toFile()));
                    if (archiveInputStream == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (archiveInputStream != null) {
                            try {
                                archiveInputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ArchiveException e) {
                        throw new IOException(e);
                    }
                }
                archiveInputStream.close();
            }
            return vulnerablePartsDetector;
        }
        finally {
            IOUtils.closeQuietly((Closeable)archiveStream);
        }
    }

    @Override
    public MethodScanner forFiles(Collection<Path> files2, Collection<MethodInfo> vulnerableMethods, EntryPointResolver entryPointResolver) {
        throw new UnsupportedOperationException("File scanning is unsupported");
    }

    @Override
    public MethodScanner forDirectory(Path directory, Collection<MethodInfo> vulnerableMethods, EntryPointResolver entryPointResolver) throws IOException {
        RubyCallGraphBuilder rubyCallGraphBuilder = new RubyCallGraphBuilder(directory, this.input.publicMethods(), this.config);
        return new VulnerablePartsDetector(vulnerableMethods, entryPointResolver, rubyCallGraphBuilder, this.input, Cleaner.DO_NOTHING);
    }
}

