/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods.analyzers;

import com.sourceclear.methods.CHACallSite;
import com.sourceclear.methods.ClassInfo;
import com.sourceclear.methods.MethodDefinition;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.methods.analyzers.CodeAnalyzer;
import com.sourceclear.methods.java.Constants;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.objectweb.asm.Type;

public class ReflectedMethodsAnalyzer
implements CodeAnalyzer {
    private final Set<ClassInfo> classInfos;
    private final boolean parallel;

    public ReflectedMethodsAnalyzer(Set<ClassInfo> classInfos, boolean parallel) {
        this.classInfos = classInfos;
        this.parallel = parallel;
    }

    @Override
    public Set<CHACallSite> analyze(Set<CHACallSite> callSites2) {
        Set<Type> reflectedClasses = Collections.unmodifiableSet(this.getClassInfoStream(this.classInfos).flatMap(ci -> ci.getReflectedClasses().stream()).collect(Collectors.toSet()));
        if (reflectedClasses.isEmpty()) {
            return callSites2;
        }
        Set<String> reflectedMethodNames = Collections.unmodifiableSet(this.getClassInfoStream(this.classInfos).flatMap(ci -> ci.getReflectedMethodNames().stream()).collect(Collectors.toSet()));
        Map classNameToClassInfo = Collections.unmodifiableMap(this.getClassInfoStream(this.classInfos).collect(Collectors.toMap(ci -> ci.getClassName(), Function.identity(), (c1, ignored) -> c1)));
        HashSet<MethodInfo> reflectedMethods = new HashSet<MethodInfo>();
        for (Type classType : reflectedClasses) {
            for (String methodName : reflectedMethodNames) {
                String className = classType.getInternalName();
                if (!classNameToClassInfo.containsKey(className)) continue;
                ClassInfo classInfo = (ClassInfo)classNameToClassInfo.get(className);
                List<MethodInfo> methods = classInfo.getMethods().stream().map(MethodDefinition::getMethod).collect(Collectors.toList());
                reflectedMethods.addAll(this.getMethodsWithName(methods, methodName));
            }
        }
        HashSet<CHACallSite> result = new HashSet<CHACallSite>();
        for (CHACallSite callSite : callSites2) {
            if (callSite.getCallType().equals((Object)CHACallSite.CallType.VIRTUAL) && callSite.getCallee().equals(Constants.METHOD_INVOKE)) {
                for (MethodInfo method : reflectedMethods) {
                    CHACallSite newCallSite = new CHACallSite(callSite.getCaller(), method, callSite.getFileName(), callSite.getLineNumber(), CHACallSite.CallType.VIRTUAL);
                    result.add(newCallSite);
                }
                continue;
            }
            result.add(callSite);
        }
        return result;
    }

    private Set<MethodInfo> getMethodsWithName(Collection<MethodInfo> methods, String methodName) {
        HashSet<MethodInfo> result = new HashSet<MethodInfo>();
        for (MethodInfo method : methods) {
            if (!method.getMethodName().equals(methodName)) continue;
            result.add(method);
        }
        return result;
    }

    private Stream<ClassInfo> getClassInfoStream(Set<ClassInfo> classInfos) {
        return this.parallel ? classInfos.parallelStream() : classInfos.stream();
    }
}

