/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods.analyzers;

import com.sourceclear.analysis.utils.Utils;
import com.sourceclear.methods.BitSetIterator;
import com.sourceclear.methods.CHACallSite;
import com.sourceclear.methods.CallSite;
import com.sourceclear.methods.ClassInfo;
import com.sourceclear.methods.Mapper;
import com.sourceclear.methods.MethodDefinition;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.methods.MethodInfoImpl;
import com.sourceclear.methods.analyzers.CodeAnalyzer;
import com.zaxxer.sparsebits.SparseBitSet;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ClassHierarchyAnalyzer
implements CodeAnalyzer {
    private static final String SUBMIT_CALLABLE_DESC = "(Ljava/lang/Callable;)";
    private static final String SUBMIT_RUNNABLE_DESC = "(Ljava/lang/Runnable;Ljava/lang/Object;)";
    private final Set<ClassInfo> classInfos;
    private final boolean parallel;
    private Map<String, SparseBitSet> cones;
    private Mapper<String> mapper;
    private SparseBitSet instantiatedTypes;

    public ClassHierarchyAnalyzer(Set<ClassInfo> classInfos) {
        this(classInfos, false);
    }

    public ClassHierarchyAnalyzer(Set<ClassInfo> classInfos, boolean parallel) {
        this.classInfos = classInfos;
        this.parallel = parallel;
    }

    @Override
    public Set<CHACallSite> analyze(Set<CHACallSite> callSites2) {
        Set<ClassInfo> classInfos = this.classInfos;
        Map<String, Set<String>> classHierarchy = ClassHierarchyAnalyzer.buildClassHierarchy(this.getClassInfoStream(classInfos));
        this.mapper = this.initializeMapper();
        this.cones = this.buildCones(classHierarchy, this.mapper);
        Set<MethodInfo> allMethodInfos = this.getClassInfoStream(classInfos).flatMap(c -> c.getMethods().stream()).map(MethodDefinition::getMethod).collect(Collectors.toSet());
        Map<MethodDefinition, SparseBitSet> appliesTos = this.buildAppliesTo(this.getClassInfoStream(classInfos), allMethodInfos, classHierarchy);
        Map<String, Set<MethodDefinition>> classToAppliesToMethods = this.buildCache(appliesTos);
        Map<String, ClassInfo> classNameToClassInfo = Collections.unmodifiableMap(this.getClassInfoStream(classInfos).collect(Collectors.toMap(ci -> ci.getClassName(), Function.identity(), (c1, ignored) -> c1)));
        Set<String> instantiatedTypeNames = Collections.unmodifiableSet(this.getClassInfoStream(this.classInfos).flatMap(ci -> ci.getInstantiatedTypes().stream()).collect(Collectors.toSet()));
        this.instantiatedTypes = this.mapClassesToBitSet(instantiatedTypeNames, this.mapper);
        HashSet<CHACallSite> result = new HashSet<CHACallSite>();
        for (CHACallSite callSite : callSites2) {
            if (callSite.getCallType().equals((Object)CHACallSite.CallType.VIRTUAL)) {
                MethodInfo callee = callSite.getCallee();
                MethodInfo caller = callSite.getCaller();
                String receiver = callee.getClassName();
                if (!classNameToClassInfo.containsKey(receiver)) {
                    result.add(callSite);
                    continue;
                }
                SparseBitSet cone = this.cones.get(receiver);
                if (cone == null) {
                    result.add(callSite);
                    continue;
                }
                Set<CHACallSite> allVirtualCalls = this.isStartingThread(callee) || this.isExecutingThreadThroughExecutor(callee) || this.isExecutingThreadThroughExecutorService(callee) || this.isExecutingThreadThroughCompletionService(callee) ? this.toVirtualCallSites("run", "()", this.cones.get("java/lang/Runnable"), callSite, classNameToClassInfo) : (this.isExecutingCallableThroughExecutorService(callee) || this.isExecutingCallableThroughCompletionService(callee) ? this.toVirtualCallSites("call", "()", this.cones.get("java/util/concurrent/Callable"), callSite, classNameToClassInfo) : this.toVirtualCallSites(callee.getMethodName(), callee.getDesc(), cone, callSite, classNameToClassInfo));
                Collection methods = classToAppliesToMethods.getOrDefault(receiver, Collections.emptySet());
                for (MethodDefinition methodDefinition : methods) {
                    MethodInfo method = methodDefinition.getMethod();
                    boolean hasSameNameAndDesc = method.getMethodName().equals(callee.getMethodName()) && method.getDesc().equals(callee.getDesc());
                    boolean isAbstract = methodDefinition.getAttributes().contains((Object)MethodDefinition.Attribute.ABSTRACT);
                    if (!hasSameNameAndDesc || isAbstract) continue;
                    SparseBitSet appliesTo = appliesTos.get(methodDefinition);
                    for (Integer i : new BitSetIterator(appliesTo)) {
                        String className = this.mapper.reverseLookup(i);
                        MethodInfo m = MethodInfoImpl.builder().withClassName(className).withMethodName(callee.getMethodName()).withDesc(callee.getDesc()).build();
                        CallSite removableCallSite = new CallSite(caller, m, callSite.getFileName(), callSite.getLineNumber());
                        allVirtualCalls.remove(removableCallSite);
                    }
                    allVirtualCalls.add(new CHACallSite(caller, method, callSite.getFileName(), callSite.getLineNumber(), CHACallSite.CallType.VIRTUAL));
                }
                result.addAll(allVirtualCalls);
                continue;
            }
            result.add(callSite);
        }
        return result;
    }

    private Set<CHACallSite> toVirtualCallSites(String methodName, String desc, SparseBitSet cone, CHACallSite oldCallSite, Map<String, ClassInfo> classNameToClassInfo) {
        BitSetIterator bitSetIterator = new BitSetIterator(cone);
        return StreamSupport.stream(bitSetIterator.spliterator(), false).filter(i -> this.instantiatedTypes.get(i.intValue())).map(i -> (ClassInfo)classNameToClassInfo.get(this.mapper.reverseLookup((Integer)i))).filter(Objects::nonNull).map(classInfo -> {
            MethodInfo coneCallee = MethodInfoImpl.builder().withClassName(classInfo.getClassName()).withMethodName(methodName).withDesc(desc).build();
            return new CHACallSite(oldCallSite.getCaller(), coneCallee, oldCallSite.getFileName(), oldCallSite.getLineNumber(), CHACallSite.CallType.VIRTUAL);
        }).collect(Collectors.toSet());
    }

    private Map<String, Set<MethodDefinition>> buildCache(Map<MethodDefinition, SparseBitSet> appliesTos) {
        Stream conesEntries = this.parallel ? this.cones.entrySet().parallelStream() : this.cones.entrySet().stream();
        return conesEntries.collect(Collectors.toMap(e -> (String)e.getKey(), entry -> {
            SparseBitSet cone = (SparseBitSet)entry.getValue();
            Stream appliesTosEntries = this.parallel ? appliesTos.entrySet().parallelStream() : appliesTos.entrySet().stream();
            Set appliesToMethods = appliesTosEntries.map(appliesToEntry -> {
                SparseBitSet appliesTo = (SparseBitSet)appliesToEntry.getValue();
                MethodDefinition methodDefinition = (MethodDefinition)appliesToEntry.getKey();
                SparseBitSet bs = Utils.setDifference(cone, appliesTo);
                return new AbstractMap.SimpleImmutableEntry<MethodDefinition, SparseBitSet>(methodDefinition, bs);
            }).filter(pair -> ((SparseBitSet)pair.getValue()).isEmpty()).map(AbstractMap.SimpleImmutableEntry::getKey).collect(Collectors.toSet());
            return appliesToMethods;
        }));
    }

    private Map<MethodDefinition, SparseBitSet> buildAppliesTo(Stream<ClassInfo> classInfoStream, Set<MethodInfo> methodInfos, Map<String, Set<String>> classHierarchy) {
        return classInfoStream.flatMap(classInfo -> classInfo.getMethods().stream()).collect(Collectors.toMap(Function.identity(), methodDefinition -> {
            SparseBitSet overridersCone = this.directlyOverridingClasses((MethodDefinition)methodDefinition, this.cones, methodInfos, classHierarchy).orElse(new SparseBitSet());
            SparseBitSet bitSet = this.cones.get(methodDefinition.getMethod().getClassName());
            SparseBitSet coneBS = bitSet == null ? new SparseBitSet() : bitSet;
            return Utils.setDifference(coneBS, overridersCone);
        }, (bs1, bs2) -> {
            SparseBitSet result = new SparseBitSet();
            result.or(bs1);
            result.or(bs2);
            return result;
        }));
    }

    private Mapper<String> initializeMapper() {
        HashSet classNames = new HashSet(this.getClassInfoStream(this.classInfos).map(ClassInfo::getClassName).collect(Collectors.toSet()));
        classNames.addAll(this.getClassInfoStream(this.classInfos).map(ClassInfo::getSuperName).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet()));
        classNames.addAll(this.getClassInfoStream(this.classInfos).flatMap(ci -> ci.getImplementedInterfaces().stream()).collect(Collectors.toSet()));
        return new Mapper<String>(classNames);
    }

    static Map<String, Set<String>> buildClassHierarchy(Stream<ClassInfo> classInfos) {
        HashMap initialClasses = new HashMap();
        return Collections.unmodifiableMap(classInfos.reduce(initialClasses, (accum, classInfo) -> {
            HashMap<String, Set> result = new HashMap<String, Set>((Map<String, Set>)accum);
            HashSet<String> superClasses = new HashSet<String>(classInfo.getImplementedInterfaces());
            classInfo.getSuperName().ifPresent(superName -> superClasses.add((String)superName));
            for (String superClass : superClasses) {
                HashSet<String> subclasses = new HashSet<String>(result.computeIfAbsent(superClass, x -> Collections.emptySet()));
                subclasses.add(classInfo.getClassName());
                result.put(superClass, subclasses);
            }
            return result;
        }, ClassHierarchyAnalyzer::mergeMultiMaps));
    }

    private Map<String, SparseBitSet> buildCones(Map<String, Set<String>> classHierarchy, Mapper<String> mapper) {
        HashMap<String, SparseBitSet> cones = new HashMap<String, SparseBitSet>();
        ArrayDeque<String> stack = new ArrayDeque<String>();
        for (String cls : classHierarchy.keySet()) {
            stack.push(cls);
        }
        HashSet<String> visited = new HashSet<String>();
        while (!stack.isEmpty()) {
            SparseBitSet bs;
            String currentClass = (String)stack.peek();
            Collection classChildren = classHierarchy.get(currentClass);
            boolean isLeafNode = classChildren == null || classChildren.isEmpty();
            int bitIndex = mapper.lookup(currentClass);
            if (isLeafNode) {
                bs = new SparseBitSet();
                bs.set(bitIndex);
                cones.put(currentClass, bs);
                visited.add(currentClass);
                stack.pop();
                continue;
            }
            if (visited.contains(currentClass)) {
                bs = new SparseBitSet();
                bs.set(bitIndex);
                for (String child : classChildren) {
                    if (!cones.containsKey(child)) continue;
                    SparseBitSet childCone = cones.get(child);
                    bs.or(childCone);
                }
                cones.put(currentClass, bs);
                stack.removeFirst();
                continue;
            }
            visited.add(currentClass);
            for (String className : classChildren) {
                stack.push(className);
            }
        }
        return cones;
    }

    Optional<SparseBitSet> directlyOverridingClasses(MethodDefinition methodDefinition, Map<String, SparseBitSet> cones, Set<MethodInfo> allMethodInfos, Map<String, Set<String>> classHierarchy) {
        MethodInfo method = methodDefinition.getMethod();
        String className = method.getClassName();
        SparseBitSet overridersCone = new SparseBitSet();
        Set directSubclasses = Collections.unmodifiableSet(classHierarchy.getOrDefault(className, Collections.emptySet()));
        if (directSubclasses == null || directSubclasses.isEmpty()) {
            return Optional.empty();
        }
        ArrayDeque queue = new ArrayDeque(directSubclasses);
        while (!queue.isEmpty()) {
            String currentClass = (String)queue.remove();
            MethodInfo overridingMethod = MethodInfoImpl.builder().withClassName(currentClass).withMethodName(method.getMethodName()).withDesc(method.getDesc()).build();
            if (allMethodInfos.contains(overridingMethod)) {
                SparseBitSet bitSet = cones.get(currentClass);
                if (bitSet == null) continue;
                overridersCone.or(bitSet);
                continue;
            }
            if (classHierarchy.get(currentClass) == null || classHierarchy.get(currentClass).isEmpty()) continue;
            queue.addAll((Collection)classHierarchy.get(currentClass));
        }
        return Optional.of(overridersCone);
    }

    private Stream<ClassInfo> getClassInfoStream(Collection<ClassInfo> classInfos) {
        return this.parallel ? classInfos.parallelStream() : classInfos.stream();
    }

    private static <K, V> HashMap<K, Set<V>> mergeMultiMaps(HashMap<K, Set<V>> x, HashMap<K, Set<V>> y) {
        HashMap<K, Set<Set<Object>>> result = new HashMap<K, Set<Set<Object>>>(x);
        for (Map.Entry<K, Set<V>> entry : y.entrySet()) {
            HashSet xValue = new HashSet(result.getOrDefault(entry.getKey(), Collections.emptySet()));
            xValue.addAll(entry.getValue());
            result.put(entry.getKey(), xValue);
        }
        return result;
    }

    private SparseBitSet mapClassesToBitSet(Collection<String> classes, Mapper<String> mapper) {
        int numberOfClasses = mapper.size();
        SparseBitSet bs = new SparseBitSet(numberOfClasses);
        for (String className : classes) {
            if (!mapper.contains(className)) continue;
            int bitIndex = mapper.lookup(className);
            bs.set(bitIndex);
        }
        return bs;
    }

    private boolean isExecutingCallableThroughCompletionService(MethodInfo callee) {
        return this.isExecutingThroughCompletionService(callee, SUBMIT_CALLABLE_DESC);
    }

    private boolean isExecutingThreadThroughCompletionService(MethodInfo callee) {
        return this.isExecutingThroughCompletionService(callee, SUBMIT_RUNNABLE_DESC);
    }

    private boolean isExecutingThroughCompletionService(MethodInfo callee, String submitMethodDesc) {
        String methodName = callee.getMethodName();
        String desc = callee.getDesc();
        String className = callee.getClassName();
        boolean implementsCompletionService = this.isInConeSet("java/util/concurrent/CompletionService", className);
        boolean isCallingSubmit = methodName.equals("submit") && desc.equals(submitMethodDesc);
        return isCallingSubmit && (className.equals("java/util/concurrent/CompletionService") || implementsCompletionService);
    }

    private boolean isExecutingThreadThroughExecutorService(MethodInfo callee) {
        String methodName = callee.getMethodName();
        String desc = callee.getDesc();
        String className = callee.getClassName();
        boolean implementsExecutorService = this.isInConeSet("java/util/concurrent/ExecutorService", className);
        boolean isCallingSubmit = methodName.equals("submit") && (desc.equals(SUBMIT_RUNNABLE_DESC) || desc.equals("(Ljava/lang/Runnable;"));
        return isCallingSubmit && (className.equals("java/util/concurrent/ExecutorService") || implementsExecutorService);
    }

    private boolean isExecutingCallableThroughExecutorService(MethodInfo callee) {
        String methodName = callee.getMethodName();
        String desc = callee.getDesc();
        String className = callee.getClassName();
        boolean implementsExecutorService = this.isInConeSet("java/util/concurrent/ExecutorService", className);
        boolean isCallingSubmit = methodName.equals("submit") && desc.equals("(Ljava/util/concurrent/Callable;)");
        boolean isCallingInvokeAll = methodName.equals("invokeAll") && (desc.equals("(Ljava/util/Collection;)") || desc.equals("(Ljava/util/Collection;JLjava/util/concurrent/TimeUnit;)"));
        boolean isCallingInvokeAny = methodName.equals("invokeAny") && (desc.equals("(Ljava/util/Collection;)") || desc.equals("(Ljava/util/Collection;JLjava/util/concurrent/TimeUnit;)"));
        return !(!isCallingInvokeAll && !isCallingInvokeAny && !isCallingSubmit || !className.equals("java/util/concurrent/ExecutorService") && !implementsExecutorService);
    }

    private boolean isExecutingThreadThroughExecutor(MethodInfo callee) {
        boolean implementsExecutor = this.isInConeSet("java/util/concurrent/Executor", callee.getClassName());
        return callee.getMethodName().equals("execute") && callee.getDesc().equals("(Ljava/lang/Runnable;)") && (callee.getClassName().equals("java/util/concurrent/Executor") || implementsExecutor);
    }

    private boolean isStartingThread(MethodInfo callee) {
        boolean isAThread = this.isInConeSet("java/lang/Thread", callee.getClassName());
        return callee.getMethodName().equals("start") && callee.getDesc().equals("()") && isAThread;
    }

    private boolean isInConeSet(String classA, String classB) {
        SparseBitSet cone = this.cones.get(classA);
        return cone != null && this.cones.get(classA).get(this.mapper.lookup(classB).intValue());
    }
}

