/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.sourceclear.analysis.latte.frameworks.Frameworks;
import com.sourceclear.methods.CallSite;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.methods.VulnMethodsInput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.BaseStream;

abstract class VulnMethodsInput_Builder {
    private Set<CallSite> dynamicEdges = ImmutableSet.of();
    private List<List<CallSite>> staticCallChains = ImmutableList.of();
    private Set<MethodInfo> publicMethods = ImmutableSet.of();
    private Set<Frameworks.Module> frameworkMethods = ImmutableSet.of();

    VulnMethodsInput_Builder() {
    }

    public static VulnMethodsInput.Builder from(VulnMethodsInput value) {
        if (value instanceof Rebuildable) {
            return ((Rebuildable)value).toBuilder();
        }
        return new VulnMethodsInput.Builder().mergeFrom(value);
    }

    public VulnMethodsInput.Builder addDynamicEdges(CallSite element) {
        if (this.dynamicEdges instanceof ImmutableSet) {
            this.dynamicEdges = new LinkedHashSet<CallSite>(this.dynamicEdges);
        }
        this.dynamicEdges.add(Objects.requireNonNull(element));
        return (VulnMethodsInput.Builder)this;
    }

    public VulnMethodsInput.Builder addDynamicEdges(CallSite ... elements) {
        return this.addAllDynamicEdges(Arrays.asList(elements));
    }

    public VulnMethodsInput.Builder addAllDynamicEdges(Spliterator<? extends CallSite> elements) {
        elements.forEachRemaining(this::addDynamicEdges);
        return (VulnMethodsInput.Builder)this;
    }

    public VulnMethodsInput.Builder addAllDynamicEdges(BaseStream<? extends CallSite, ?> elements) {
        return this.addAllDynamicEdges(elements.spliterator());
    }

    public VulnMethodsInput.Builder addAllDynamicEdges(Iterable<? extends CallSite> elements) {
        elements.forEach(this::addDynamicEdges);
        return (VulnMethodsInput.Builder)this;
    }

    public VulnMethodsInput.Builder removeDynamicEdges(CallSite element) {
        if (this.dynamicEdges instanceof ImmutableSet) {
            this.dynamicEdges = new LinkedHashSet<CallSite>(this.dynamicEdges);
        }
        this.dynamicEdges.remove(Objects.requireNonNull(element));
        return (VulnMethodsInput.Builder)this;
    }

    public VulnMethodsInput.Builder mutateDynamicEdges(Consumer<? super Set<CallSite>> mutator) {
        if (this.dynamicEdges instanceof ImmutableSet) {
            this.dynamicEdges = new LinkedHashSet<CallSite>(this.dynamicEdges);
        }
        mutator.accept(this.dynamicEdges);
        return (VulnMethodsInput.Builder)this;
    }

    public VulnMethodsInput.Builder clearDynamicEdges() {
        if (this.dynamicEdges instanceof ImmutableSet) {
            this.dynamicEdges = ImmutableSet.of();
        } else {
            this.dynamicEdges.clear();
        }
        return (VulnMethodsInput.Builder)this;
    }

    public Set<CallSite> dynamicEdges() {
        if (this.dynamicEdges instanceof ImmutableSet) {
            this.dynamicEdges = new LinkedHashSet<CallSite>(this.dynamicEdges);
        }
        return Collections.unmodifiableSet(this.dynamicEdges);
    }

    public VulnMethodsInput.Builder addStaticCallChains(List<CallSite> element) {
        if (this.staticCallChains instanceof ImmutableList) {
            this.staticCallChains = new ArrayList<List<CallSite>>(this.staticCallChains);
        }
        this.staticCallChains.add(Objects.requireNonNull(element));
        return (VulnMethodsInput.Builder)this;
    }

    @SafeVarargs
    public final VulnMethodsInput.Builder addStaticCallChains(List<CallSite> ... elements) {
        return this.addAllStaticCallChains(Arrays.asList(elements));
    }

    public VulnMethodsInput.Builder addAllStaticCallChains(Spliterator<? extends List<CallSite>> elements) {
        long elementsSize;
        if ((elements.characteristics() & 0x40) != 0 && (elementsSize = elements.estimateSize()) > 0L && elementsSize <= Integer.MAX_VALUE) {
            if (this.staticCallChains instanceof ImmutableList) {
                this.staticCallChains = new ArrayList<List<CallSite>>(this.staticCallChains);
            }
            ((ArrayList)this.staticCallChains).ensureCapacity(this.staticCallChains.size() + (int)elementsSize);
        }
        elements.forEachRemaining(this::addStaticCallChains);
        return (VulnMethodsInput.Builder)this;
    }

    public VulnMethodsInput.Builder addAllStaticCallChains(BaseStream<? extends List<CallSite>, ?> elements) {
        return this.addAllStaticCallChains(elements.spliterator());
    }

    public VulnMethodsInput.Builder addAllStaticCallChains(Iterable<? extends List<CallSite>> elements) {
        return this.addAllStaticCallChains(elements.spliterator());
    }

    public VulnMethodsInput.Builder mutateStaticCallChains(Consumer<? super List<List<CallSite>>> mutator) {
        if (this.staticCallChains instanceof ImmutableList) {
            this.staticCallChains = new ArrayList<List<CallSite>>(this.staticCallChains);
        }
        mutator.accept(this.staticCallChains);
        return (VulnMethodsInput.Builder)this;
    }

    public VulnMethodsInput.Builder clearStaticCallChains() {
        if (this.staticCallChains instanceof ImmutableList) {
            this.staticCallChains = ImmutableList.of();
        } else {
            this.staticCallChains.clear();
        }
        return (VulnMethodsInput.Builder)this;
    }

    public List<List<CallSite>> staticCallChains() {
        if (this.staticCallChains instanceof ImmutableList) {
            this.staticCallChains = new ArrayList<List<CallSite>>(this.staticCallChains);
        }
        return Collections.unmodifiableList(this.staticCallChains);
    }

    public VulnMethodsInput.Builder addPublicMethods(MethodInfo element) {
        if (this.publicMethods instanceof ImmutableSet) {
            this.publicMethods = new LinkedHashSet<MethodInfo>(this.publicMethods);
        }
        this.publicMethods.add(Objects.requireNonNull(element));
        return (VulnMethodsInput.Builder)this;
    }

    public VulnMethodsInput.Builder addPublicMethods(MethodInfo ... elements) {
        return this.addAllPublicMethods(Arrays.asList(elements));
    }

    public VulnMethodsInput.Builder addAllPublicMethods(Spliterator<? extends MethodInfo> elements) {
        elements.forEachRemaining(this::addPublicMethods);
        return (VulnMethodsInput.Builder)this;
    }

    public VulnMethodsInput.Builder addAllPublicMethods(BaseStream<? extends MethodInfo, ?> elements) {
        return this.addAllPublicMethods(elements.spliterator());
    }

    public VulnMethodsInput.Builder addAllPublicMethods(Iterable<? extends MethodInfo> elements) {
        elements.forEach(this::addPublicMethods);
        return (VulnMethodsInput.Builder)this;
    }

    public VulnMethodsInput.Builder removePublicMethods(MethodInfo element) {
        if (this.publicMethods instanceof ImmutableSet) {
            this.publicMethods = new LinkedHashSet<MethodInfo>(this.publicMethods);
        }
        this.publicMethods.remove(Objects.requireNonNull(element));
        return (VulnMethodsInput.Builder)this;
    }

    public VulnMethodsInput.Builder mutatePublicMethods(Consumer<? super Set<MethodInfo>> mutator) {
        if (this.publicMethods instanceof ImmutableSet) {
            this.publicMethods = new LinkedHashSet<MethodInfo>(this.publicMethods);
        }
        mutator.accept(this.publicMethods);
        return (VulnMethodsInput.Builder)this;
    }

    public VulnMethodsInput.Builder clearPublicMethods() {
        if (this.publicMethods instanceof ImmutableSet) {
            this.publicMethods = ImmutableSet.of();
        } else {
            this.publicMethods.clear();
        }
        return (VulnMethodsInput.Builder)this;
    }

    public Set<MethodInfo> publicMethods() {
        if (this.publicMethods instanceof ImmutableSet) {
            this.publicMethods = new LinkedHashSet<MethodInfo>(this.publicMethods);
        }
        return Collections.unmodifiableSet(this.publicMethods);
    }

    public VulnMethodsInput.Builder addFrameworkMethods(Frameworks.Module element) {
        if (this.frameworkMethods instanceof ImmutableSet) {
            this.frameworkMethods = new LinkedHashSet<Frameworks.Module>(this.frameworkMethods);
        }
        this.frameworkMethods.add(Objects.requireNonNull(element));
        return (VulnMethodsInput.Builder)this;
    }

    public VulnMethodsInput.Builder addFrameworkMethods(Frameworks.Module ... elements) {
        return this.addAllFrameworkMethods(Arrays.asList(elements));
    }

    public VulnMethodsInput.Builder addAllFrameworkMethods(Spliterator<? extends Frameworks.Module> elements) {
        elements.forEachRemaining(this::addFrameworkMethods);
        return (VulnMethodsInput.Builder)this;
    }

    public VulnMethodsInput.Builder addAllFrameworkMethods(BaseStream<? extends Frameworks.Module, ?> elements) {
        return this.addAllFrameworkMethods(elements.spliterator());
    }

    public VulnMethodsInput.Builder addAllFrameworkMethods(Iterable<? extends Frameworks.Module> elements) {
        elements.forEach(this::addFrameworkMethods);
        return (VulnMethodsInput.Builder)this;
    }

    public VulnMethodsInput.Builder removeFrameworkMethods(Frameworks.Module element) {
        if (this.frameworkMethods instanceof ImmutableSet) {
            this.frameworkMethods = new LinkedHashSet<Frameworks.Module>(this.frameworkMethods);
        }
        this.frameworkMethods.remove(Objects.requireNonNull(element));
        return (VulnMethodsInput.Builder)this;
    }

    public VulnMethodsInput.Builder mutateFrameworkMethods(Consumer<? super Set<Frameworks.Module>> mutator) {
        if (this.frameworkMethods instanceof ImmutableSet) {
            this.frameworkMethods = new LinkedHashSet<Frameworks.Module>(this.frameworkMethods);
        }
        mutator.accept(this.frameworkMethods);
        return (VulnMethodsInput.Builder)this;
    }

    public VulnMethodsInput.Builder clearFrameworkMethods() {
        if (this.frameworkMethods instanceof ImmutableSet) {
            this.frameworkMethods = ImmutableSet.of();
        } else {
            this.frameworkMethods.clear();
        }
        return (VulnMethodsInput.Builder)this;
    }

    public Set<Frameworks.Module> frameworkMethods() {
        if (this.frameworkMethods instanceof ImmutableSet) {
            this.frameworkMethods = new LinkedHashSet<Frameworks.Module>(this.frameworkMethods);
        }
        return Collections.unmodifiableSet(this.frameworkMethods);
    }

    public VulnMethodsInput.Builder mergeFrom(VulnMethodsInput value) {
        if (value instanceof Value && this.dynamicEdges == ImmutableSet.of()) {
            this.dynamicEdges = ImmutableSet.copyOf(value.dynamicEdges());
        } else {
            this.addAllDynamicEdges(value.dynamicEdges());
        }
        if (value instanceof Value && this.staticCallChains == ImmutableList.of()) {
            this.staticCallChains = ImmutableList.copyOf(value.staticCallChains());
        } else {
            this.addAllStaticCallChains(value.staticCallChains());
        }
        if (value instanceof Value && this.publicMethods == ImmutableSet.of()) {
            this.publicMethods = ImmutableSet.copyOf(value.publicMethods());
        } else {
            this.addAllPublicMethods(value.publicMethods());
        }
        if (value instanceof Value && this.frameworkMethods == ImmutableSet.of()) {
            this.frameworkMethods = ImmutableSet.copyOf(value.frameworkMethods());
        } else {
            this.addAllFrameworkMethods(value.frameworkMethods());
        }
        return (VulnMethodsInput.Builder)this;
    }

    public VulnMethodsInput.Builder mergeFrom(VulnMethodsInput.Builder template) {
        VulnMethodsInput.Builder base = template;
        this.addAllDynamicEdges(base.dynamicEdges);
        this.addAllStaticCallChains(base.staticCallChains);
        this.addAllPublicMethods(base.publicMethods);
        this.addAllFrameworkMethods(base.frameworkMethods);
        return (VulnMethodsInput.Builder)this;
    }

    public VulnMethodsInput.Builder clear() {
        this.clearDynamicEdges();
        this.clearStaticCallChains();
        this.clearPublicMethods();
        this.clearFrameworkMethods();
        return (VulnMethodsInput.Builder)this;
    }

    public VulnMethodsInput build() {
        return new Value(this);
    }

    @VisibleForTesting
    public VulnMethodsInput buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    extends Rebuildable {
        private final ImmutableSet<CallSite> dynamicEdges;
        private final ImmutableList<List<CallSite>> staticCallChains;
        private final ImmutableSet<MethodInfo> publicMethods;
        private final ImmutableSet<Frameworks.Module> frameworkMethods;

        Partial(VulnMethodsInput_Builder builder) {
            this.dynamicEdges = ImmutableSet.copyOf((Collection)builder.dynamicEdges);
            this.staticCallChains = ImmutableList.copyOf((Collection)builder.staticCallChains);
            this.publicMethods = ImmutableSet.copyOf((Collection)builder.publicMethods);
            this.frameworkMethods = ImmutableSet.copyOf((Collection)builder.frameworkMethods);
        }

        @Override
        public Set<CallSite> dynamicEdges() {
            return this.dynamicEdges;
        }

        @Override
        public List<List<CallSite>> staticCallChains() {
            return this.staticCallChains;
        }

        @Override
        public Set<MethodInfo> publicMethods() {
            return this.publicMethods;
        }

        @Override
        public Set<Frameworks.Module> frameworkMethods() {
            return this.frameworkMethods;
        }

        @Override
        public VulnMethodsInput.Builder toBuilder() {
            PartialBuilder builder = new PartialBuilder();
            ((VulnMethodsInput_Builder)builder).dynamicEdges = this.dynamicEdges;
            ((VulnMethodsInput_Builder)builder).staticCallChains = this.staticCallChains;
            ((VulnMethodsInput_Builder)builder).publicMethods = this.publicMethods;
            ((VulnMethodsInput_Builder)builder).frameworkMethods = this.frameworkMethods;
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals(this.dynamicEdges, other.dynamicEdges) && Objects.equals(this.staticCallChains, other.staticCallChains) && Objects.equals(this.publicMethods, other.publicMethods) && Objects.equals(this.frameworkMethods, other.frameworkMethods);
        }

        public int hashCode() {
            return Objects.hash(this.dynamicEdges, this.staticCallChains, this.publicMethods, this.frameworkMethods);
        }

        public String toString() {
            return "partial VulnMethodsInput{dynamicEdges=" + this.dynamicEdges + ", staticCallChains=" + this.staticCallChains + ", publicMethods=" + this.publicMethods + ", frameworkMethods=" + this.frameworkMethods + "}";
        }

        private static class PartialBuilder
        extends VulnMethodsInput.Builder {
            private PartialBuilder() {
            }

            @Override
            public VulnMethodsInput build() {
                return this.buildPartial();
            }
        }
    }

    private static final class Value
    extends Rebuildable {
        private final ImmutableSet<CallSite> dynamicEdges;
        private final ImmutableList<List<CallSite>> staticCallChains;
        private final ImmutableSet<MethodInfo> publicMethods;
        private final ImmutableSet<Frameworks.Module> frameworkMethods;

        private Value(VulnMethodsInput_Builder builder) {
            this.dynamicEdges = ImmutableSet.copyOf((Collection)builder.dynamicEdges);
            this.staticCallChains = ImmutableList.copyOf((Collection)builder.staticCallChains);
            this.publicMethods = ImmutableSet.copyOf((Collection)builder.publicMethods);
            this.frameworkMethods = ImmutableSet.copyOf((Collection)builder.frameworkMethods);
        }

        @Override
        public Set<CallSite> dynamicEdges() {
            return this.dynamicEdges;
        }

        @Override
        public List<List<CallSite>> staticCallChains() {
            return this.staticCallChains;
        }

        @Override
        public Set<MethodInfo> publicMethods() {
            return this.publicMethods;
        }

        @Override
        public Set<Frameworks.Module> frameworkMethods() {
            return this.frameworkMethods;
        }

        @Override
        public VulnMethodsInput.Builder toBuilder() {
            VulnMethodsInput.Builder builder = new VulnMethodsInput.Builder();
            ((VulnMethodsInput_Builder)builder).dynamicEdges = this.dynamicEdges;
            ((VulnMethodsInput_Builder)builder).staticCallChains = this.staticCallChains;
            ((VulnMethodsInput_Builder)builder).publicMethods = this.publicMethods;
            ((VulnMethodsInput_Builder)builder).frameworkMethods = this.frameworkMethods;
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals(this.dynamicEdges, other.dynamicEdges) && Objects.equals(this.staticCallChains, other.staticCallChains) && Objects.equals(this.publicMethods, other.publicMethods) && Objects.equals(this.frameworkMethods, other.frameworkMethods);
        }

        public int hashCode() {
            return Objects.hash(this.dynamicEdges, this.staticCallChains, this.publicMethods, this.frameworkMethods);
        }

        public String toString() {
            return "VulnMethodsInput{dynamicEdges=" + this.dynamicEdges + ", staticCallChains=" + this.staticCallChains + ", publicMethods=" + this.publicMethods + ", frameworkMethods=" + this.frameworkMethods + "}";
        }
    }

    private static abstract class Rebuildable
    implements VulnMethodsInput {
        private Rebuildable() {
        }

        public abstract VulnMethodsInput.Builder toBuilder();
    }
}

