/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sourceclear.methods.MethodInfo;
import java.util.Objects;

public class MethodInfoImpl
implements MethodInfo {
    @JsonProperty
    private final String moduleName;
    @JsonProperty
    private final String className;
    @JsonProperty
    private final String methodName;
    @JsonProperty
    private final String desc;
    private volatile int cachedHashCode = 0;

    @JsonCreator
    public MethodInfoImpl(@JsonProperty(value="module_name") String moduleName, @JsonProperty(value="class_name") String className, @JsonProperty(value="method_name") String methodName, @JsonProperty(value="desc") String desc) {
        this.moduleName = moduleName;
        this.className = className;
        this.methodName = methodName;
        this.desc = desc;
    }

    public MethodInfoImpl(String className, String methodName, String desc) {
        this(null, className, methodName, desc);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodInfoImpl that = (MethodInfoImpl)o;
        return Objects.equals(this.moduleName, that.moduleName) && Objects.equals(this.className, that.className) && Objects.equals(this.methodName, that.methodName) && Objects.equals(this.desc, that.desc);
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            this.cachedHashCode = Objects.hash(this.moduleName, this.className, this.methodName, this.desc);
        }
        return this.cachedHashCode;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.moduleName != null) {
            stringBuilder.append(this.moduleName);
            stringBuilder.append(".");
        }
        if (this.className != null) {
            stringBuilder.append(this.className);
            stringBuilder.append(".");
        }
        if (this.methodName != null) {
            stringBuilder.append(this.methodName);
        }
        if (this.desc != null) {
            stringBuilder.append(this.desc);
        }
        return stringBuilder.toString();
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String moduleName = null;
        private String className = null;
        private String methodName = null;
        private String desc = null;

        public Builder withModuleName(String moduleName) {
            this.moduleName = moduleName;
            return this;
        }

        public Builder withClassName(String className) {
            this.className = className;
            return this;
        }

        public Builder withMethodName(String methodName) {
            this.methodName = methodName;
            return this;
        }

        public Builder withDesc(String desc) {
            this.desc = desc;
            return this;
        }

        public MethodInfo build() {
            return new MethodInfoImpl(this.moduleName, this.className, this.methodName, this.desc);
        }
    }
}

