/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods;

import com.sourceclear.analysis.utils.TempFile;
import com.sourceclear.methods.CallChain;
import com.sourceclear.methods.CallGraph;
import com.sourceclear.methods.CallSite;
import com.sourceclear.methods.JGCallGraph;
import com.sourceclear.methods.JavaCallGraphTraversal;
import com.sourceclear.methods.MethodInfo;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.io.DOTExporter;
import org.jgrapht.io.ExportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallChainsInspector {
    private static final Logger LOGGER = LoggerFactory.getLogger(CallChainsInspector.class);
    private final CallGraph callGraph;

    CallChainsInspector(CallGraph callGraph) {
        this.callGraph = callGraph;
    }

    Map<MethodInfo, Collection<CallChain>> callChainsFrom(Collection<MethodInfo> targetMethods) {
        return new JavaCallGraphTraversal(CallChainsInspector.cast(this.callGraph)).callChainsFrom(targetMethods);
    }

    static JGCallGraph cast(CallGraph callGraph) {
        if (!(callGraph instanceof JGCallGraph)) {
            throw new IllegalStateException();
        }
        return (JGCallGraph)callGraph;
    }

    public static CallGraph createCallGraph() {
        return new JGCallGraph();
    }

    public static void printDotGraph(CallGraph g, String name) {
        CallChainsInspector.printDotGraph(CallChainsInspector.cast(g).getGraph(), name);
    }

    public static void printDotGraph(Graph<MethodInfo, CallSite> g, String name) {
        if (LOGGER.isTraceEnabled()) {
            try {
                TempFile dot = new TempFile(name, ".dot");
                CallChainsInspector.printDotGraph(g, dot.path);
                LOGGER.trace("graph {} printed to {}", (Object)name, (Object)dot.path);
            }
            catch (IOException e) {
                LOGGER.trace("error exporting graph {} to dot", (Object)name, (Object)e);
            }
        }
    }

    public static void printDotGraph(Graph<MethodInfo, CallSite> g, Path filename) {
        try {
            DOTExporter dotExporter = new DOTExporter(m -> "\"" + m.toString() + "\"", Object::toString, cs -> cs.getFileName() + "@" + cs.getLineNumber());
            dotExporter.putGraphAttribute("rankdir", "LR");
            dotExporter.putGraphAttribute("nodesep", "0.1");
            dotExporter.exportGraph(g, filename.toFile());
        }
        catch (ExportException e) {
            throw new RuntimeException(e);
        }
    }
}

