/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.librarydiffs.delta;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.sourceclear.librarydiffs.delta.DeltaMethod;
import com.sourceclear.librarydiffs.delta.LibDelta;
import com.sourceclear.librarydiffs.delta.Op;
import com.sourceclear.librarydiffs.delta.TaggedMethod;
import java.io.IOException;
import java.util.HashMap;

class Deserializer
extends StdDeserializer<LibDelta<TaggedMethod>> {
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModule((Module)new Jdk8Module()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    Deserializer() {
        this(null);
    }

    Deserializer(Class<LibDelta<TaggedMethod>> t) {
        super(t);
    }

    public LibDelta<TaggedMethod> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        if (!node.isArray()) {
            throw new IOException("Not an array: " + node);
        }
        HashMap<TaggedMethod, Op> result = new HashMap<TaggedMethod, Op>();
        for (JsonNode child : node) {
            DeltaMethod dm = (DeltaMethod)MAPPER.treeToValue((TreeNode)child, DeltaMethod.class);
            result.put(new TaggedMethod(dm.getMethod(), dm.getTag()), dm.getOp());
        }
        return new LibDelta<TaggedMethod>(result);
    }
}

