/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.methods;

import com.sourceclear.api.data.methods.MethodCallData;
import com.sourceclear.engine.common.ProjectDLLUtils;
import com.sourceclear.engine.common.StoredFileVisitor;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.methods.BaseMethodsEngine;
import com.sourceclear.engine.methods.MethodScanBatcher;
import com.sourceclear.engine.methods.MethodsEngine;
import com.sourceclear.engine.methods.SimpleFileMethodScanBatcher;
import com.sourceclear.methods.MethodScannerFactory;
import com.sourceclear.methods.VulnMethodsConfig;
import com.sourceclear.methods.dotnet.DotNetMethodScannerFactory;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;

public class DotNetMethodsEngine
extends BaseMethodsEngine {
    private final MethodScannerFactory methodScannerFactory = new DotNetMethodScannerFactory();

    @Override
    MethodScanBatcher setupBatcher(Path scanRoot, LogStream logStream) throws IOException {
        StoredFileVisitor dllVisitor = ProjectDLLUtils.visitorStartingAt(scanRoot);
        return new SimpleFileMethodScanBatcher(this.methodScannerFactory, logStream, dllVisitor);
    }

    @Override
    public MethodsEngine.Result scanMethods(Path scanRoot, Collection<MethodCallData> inputMethodData, LogStream logStream) {
        try {
            return this.innerScanMethods(scanRoot, inputMethodData, logStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MethodsEngine withVulnMethodsConfig(VulnMethodsConfig config) {
        this.methodScannerFactory.withVulnMethodsConfig(config);
        return this;
    }

    @Override
    public VulnMethodsConfig.Builder defaultConfig() {
        return this.methodScannerFactory.defaultVulnMethodsConfig().parallel(true);
    }
}

