/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.common;

import com.google.common.collect.Sets;
import com.sourceclear.engine.common.StoredFileVisitor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;

public class SOFileVisitor
extends StoredFileVisitor {
    private static final Set<String> SOFILE_GLOBS = Sets.newHashSet((Object[])new String[]{"*.so", "*.so.*"});
    private static final byte[] ELF_MAGIC = new byte[]{127, 69, 76, 70};
    private final Set<String> ignoredDirectories;

    public SOFileVisitor(Set<String> ignoredDirectories) {
        this.ignoredDirectories = ignoredDirectories;
    }

    @Override
    public Set<String> getFileTypesLookedFor() {
        return SOFILE_GLOBS;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        return this.ignoredDirectories.contains(dir.getFileName().toString()) ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        for (String glob : SOFILE_GLOBS) {
            if (!FilenameUtils.wildcardMatch((String)file.getFileName().toString(), (String)glob) || !SOFileVisitor.isELF(file)) continue;
            this.files.add(file.toAbsolutePath());
        }
        return FileVisitResult.CONTINUE;
    }

    public static boolean isELF(Path file) throws IOException {
        byte[] supposedMagicBytes = new byte[ELF_MAGIC.length];
        try (InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);){
            inputStream.read(supposedMagicBytes);
        }
        return Arrays.equals(supposedMagicBytes, ELF_MAGIC);
    }
}

