/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.common;

import com.sourceclear.engine.common.StoredFileVisitor;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Set;

public class FileTypeVisitor
extends StoredFileVisitor {
    protected final Set<String> extensions;
    private final Set<String> ignoredDirectories;

    public FileTypeVisitor(Set<String> extensions, Set<String> ignoredDirectories) {
        this.extensions = extensions;
        this.ignoredDirectories = ignoredDirectories;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
        return this.ignoredDirectories.contains(dir.getFileName().toString()) ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
        for (String extension : this.extensions) {
            if (!file.getFileName().toString().endsWith(extension)) continue;
            this.files.add(file);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public Set<String> getFileTypesLookedFor() {
        return this.extensions;
    }
}

