/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.bytecode.toolkit;

import java.io.IOException;
import java.io.InputStream;

public class SlidingWindowInputStream
extends InputStream {
    private final InputStream coreInputStream;
    private final byte[] buffer;
    private final int windowSize;
    private boolean nextByteSequenceRead = false;

    public SlidingWindowInputStream(int windowSize, InputStream coreInputStream) throws IOException {
        this.coreInputStream = coreInputStream;
        this.buffer = new byte[windowSize];
        this.windowSize = windowSize;
        for (int i = 0; i < windowSize; ++i) {
            this.addNextByte(this.readNextByte());
        }
        this.nextByteSequenceRead = true;
    }

    @Override
    public int read() throws IOException {
        return this.coreInputStream.read();
    }

    @Override
    public void close() throws IOException {
        this.coreInputStream.close();
    }

    public boolean hasNextByteSequence() {
        if (!this.nextByteSequenceRead) {
            byte nextByte;
            try {
                nextByte = this.readNextByte();
            }
            catch (IOException e) {
                return this.nextByteSequenceRead;
            }
            this.addNextByte(nextByte);
            this.nextByteSequenceRead = true;
        }
        return this.nextByteSequenceRead;
    }

    public byte[] getNextByteSequence() throws IOException {
        if (this.nextByteSequenceRead) {
            this.nextByteSequenceRead = false;
            return this.buffer;
        }
        this.addNextByte(this.readNextByte());
        return this.buffer;
    }

    private void addNextByte(byte b) {
        for (int i = 0; i < this.windowSize - 1; ++i) {
            this.buffer[i] = this.buffer[i + 1];
        }
        this.buffer[this.windowSize - 1] = b;
    }

    private byte readNextByte() throws IOException {
        int integerNextByte = this.coreInputStream.read();
        if (integerNextByte < 0) {
            throw new IOException("End of file reached");
        }
        return (byte)integerNextByte;
    }
}

