/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.bytecode;

import com.sourceclear.bytecode.InputStreamGenerator;
import com.sourceclear.bytecode.toolkit.SlidingWindowInputStream;
import java.io.IOException;
import java.io.InputStream;

public class JarInputStreamGenerator
implements InputStreamGenerator {
    private InputStreamGenerator coreInputStreamGenerator;
    private final int zipStartIndex;

    public JarInputStreamGenerator(InputStreamGenerator coreInputStreamGenerator) throws IOException {
        this.coreInputStreamGenerator = coreInputStreamGenerator;
        this.zipStartIndex = this.zipStartIndex();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream inputStream = this.coreInputStreamGenerator.getInputStream();
        inputStream.skip(this.zipStartIndex);
        return inputStream;
    }

    private int zipStartIndex() throws IOException {
        try (SlidingWindowInputStream is = new SlidingWindowInputStream(4, this.coreInputStreamGenerator.getInputStream());){
            int i = 0;
            while (is.hasNextByteSequence()) {
                if (this.isZipMagicNumber(is.getNextByteSequence())) {
                    int n = i;
                    return n;
                }
                ++i;
            }
        }
        return 0;
    }

    private boolean isZipMagicNumber(byte[] byteSequence) {
        return byteSequence[0] == 80 && byteSequence[1] == 75 && byteSequence[2] == 3 && byteSequence[3] == 4;
    }

    public String toString() {
        return "JarInputStreamGenerator [coreInputStreamGenerator=" + this.coreInputStreamGenerator + ", zipStartIndex=" + this.zipStartIndex + "]";
    }
}

