/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.bytecode;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.sourceclear.bytecode.ClassDiffInfo;
import com.sourceclear.bytecode.HashedClassFingerprint;
import com.sourceclear.bytecode.MethodDiffInfo;
import com.sourceclear.bytecode.MethodFingerprint;
import com.sourceclear.bytecode.Util;
import java.io.Serializable;

public class ClassFingerprint
implements Serializable {
    private static final long serialVersionUID = -3110202617431674528L;
    private final ImmutableMap<String, MethodFingerprint> methodsMap;
    private final ImmutableSet<String> fieldsSet;
    private final ImmutableSet<String> calledMethodsSet;
    private final ImmutableSet<String> importsSet;
    private final ImmutableSet<String> algorithmsSet;

    public ClassFingerprint(ImmutableMap<String, MethodFingerprint> methodsMap, ImmutableSet<String> fieldsSet, ImmutableSet<String> calledMethodsSet, ImmutableSet<String> importsSet, ImmutableSet<String> algoSet) {
        this.methodsMap = methodsMap;
        this.fieldsSet = fieldsSet;
        this.calledMethodsSet = calledMethodsSet;
        this.importsSet = importsSet;
        this.algorithmsSet = algoSet;
    }

    public ClassFingerprint(HashedClassFingerprint hcfp) {
        this.methodsMap = Util.immutableMapInttoString(hcfp.getMethodsMap());
        this.fieldsSet = Util.immutableSetInttoString(hcfp.getFieldsSet());
        this.calledMethodsSet = Util.immutableSetInttoString(hcfp.getCalledMethodsSet());
        this.importsSet = Util.immutableSetInttoString(hcfp.getImportsSet());
        this.algorithmsSet = new ImmutableSet.Builder().build();
    }

    public ImmutableSet<String> getCalledMethodsSet() {
        return this.calledMethodsSet;
    }

    public ImmutableSet<String> getImportsSet() {
        return this.importsSet;
    }

    public ImmutableMap<String, MethodFingerprint> getMethodsMap() {
        return this.methodsMap;
    }

    public ImmutableSet<String> getFieldsSet() {
        return this.fieldsSet;
    }

    public ImmutableSet<String> getAlgorithmsSet() {
        return this.algorithmsSet;
    }

    public ClassDiffInfo diffClass(ClassFingerprint that) {
        ImmutableList<String> fieldsAdded = Util.addedItems(this.fieldsSet, that.fieldsSet);
        ImmutableList<String> fieldsRemoved = Util.addedItems(that.fieldsSet, this.fieldsSet);
        ImmutableList methodsAdded = Util.addedItems(this.methodsMap.keySet(), that.methodsMap.keySet());
        ImmutableList methodsRemoved = Util.addedItems(that.methodsMap.keySet(), this.methodsMap.keySet());
        ImmutableMap<String, MethodDiffInfo> methodsChanged = Util.changedMethods(this.methodsMap, that.methodsMap);
        return new ClassDiffInfo(methodsAdded, methodsRemoved, fieldsAdded, fieldsRemoved, methodsChanged);
    }
}

