/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.match;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.sourceclear.api.data.match.SafeVersionsQuery;
import com.sourceclear.api.data.match.SafeVersionsResponse_Builder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

@JsonDeserialize(builder=Builder.class)
public interface SafeVersionsResponse {
    public SafeVersionsQuery getSafeVersionsQuery();

    public Map<Long, List<SafeVersion>> getSafeVersions();

    public static class Builder
    extends SafeVersionsResponse_Builder {
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SafeVersion {
        @JsonProperty
        private String version;
        @JsonProperty
        private String uniqueCoordHash;

        SafeVersion() {
        }

        public SafeVersion(@Nonnull String version, @Nonnull String uniqueCoordHash) {
            this.version = version;
            this.uniqueCoordHash = uniqueCoordHash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SafeVersion that = (SafeVersion)o;
            return Objects.equals(this.version, that.version) && Objects.equals(this.uniqueCoordHash, that.uniqueCoordHash);
        }

        public int hashCode() {
            return Objects.hash(this.version, this.uniqueCoordHash);
        }

        public String toString() {
            return "SafeVersion{version='" + this.version + '\'' + ", uniqueCoordHash='" + this.uniqueCoordHash + '\'' + '}';
        }

        @Nonnull
        public String getVersion() {
            return this.version;
        }

        @Nonnull
        public String getUniqueCoordHash() {
            return this.uniqueCoordHash;
        }
    }
}

