/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.evidence;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.sourceclear.api.data.evidence.LicenseRisk;
import javax.annotation.Nullable;
import org.apache.commons.lang3.EnumUtils;

public class LicenseInfoModel {
    private String name;
    private String fullName;
    private String license;
    private String groupId;
    private String artifactId;
    private String version;
    private String licenseFile;
    private String spdxId;
    private String licenseText;
    @JsonProperty
    private LicenseRisk risk;
    @JsonProperty
    private String licenseUrl;

    public static LicenseInfoModel fromLicenseInfo(String license, String groupId, String artifactId, String version, String licenseFile) {
        LicenseInfoModel licenseInfoModel = new LicenseInfoModel();
        licenseInfoModel.setArtifactId(artifactId);
        licenseInfoModel.setGroupId(groupId);
        licenseInfoModel.setLicense(license);
        licenseInfoModel.setVersion(version);
        licenseInfoModel.setLicenseFile(licenseFile);
        return licenseInfoModel;
    }

    public static LicenseInfoModel fromLicense(String name, String fullName, String groupId, String artifactId, String version, String licenseFile, String spdxId, String licenseText, @Nullable LicenseRisk risk) {
        return LicenseInfoModel.fromLicense(name, fullName, groupId, artifactId, version, licenseFile, spdxId, licenseText, risk, null);
    }

    public static LicenseInfoModel fromLicense(String name, String fullName, String groupId, String artifactId, String version, String licenseFile, String spdxId, String licenseText, @Nullable LicenseRisk risk, @Nullable String licenseUrl) {
        LicenseInfoModel licenseInfoModel = new LicenseInfoModel();
        licenseInfoModel.setName(name);
        licenseInfoModel.setLicense(fullName);
        licenseInfoModel.setFullName(fullName);
        licenseInfoModel.setArtifactId(artifactId);
        licenseInfoModel.setGroupId(groupId);
        licenseInfoModel.setVersion(version);
        licenseInfoModel.setLicenseFile(licenseFile);
        licenseInfoModel.setSpdxId(spdxId);
        licenseInfoModel.setLicenseText(licenseText);
        licenseInfoModel.risk = risk;
        licenseInfoModel.setLicenseUrl(licenseUrl);
        return licenseInfoModel;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getLicenseFile() {
        return this.licenseFile;
    }

    public void setLicenseFile(String licenseFile) {
        this.licenseFile = licenseFile;
    }

    @Nullable
    public String getSpdxId() {
        return this.spdxId;
    }

    public void setSpdxId(String spdxId) {
        this.spdxId = spdxId;
    }

    @Nullable
    public String getLicenseText() {
        return this.licenseText;
    }

    public void setLicenseText(String licenseText) {
        this.licenseText = licenseText;
    }

    @Nullable
    public LicenseRisk getRisk() {
        return this.risk;
    }

    @JsonProperty
    void setLicenseRiskRating(String licenseRiskRating) {
        if (licenseRiskRating != null) {
            LicenseRisk risk = (LicenseRisk)EnumUtils.getEnum(LicenseRisk.class, (String)licenseRiskRating);
            if (risk == null) {
                risk = LicenseRisk.UNKNOWN;
            }
            this.risk = risk;
        }
    }

    @JsonProperty
    String getLicenseRiskRating() {
        if (this.risk == null) {
            return null;
        }
        return this.risk.toString();
    }

    @Nullable
    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    public void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }
}

