/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.evidence;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.sourceclear.api.data.evidence.Coordinates;
import com.sourceclear.api.data.evidence.EvidencePath;
import com.sourceclear.api.data.evidence.EvidenceType;
import com.sourceclear.api.data.evidence.ValidEvidence;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@ValidEvidence
@JsonDeserialize(builder=Builder.class)
public class Evidence {
    @JsonProperty(value="evidenceId")
    private String evidenceId;
    @JsonProperty(value="evidencePaths")
    private List<EvidencePath> evidencePaths = new ArrayList<EvidencePath>();
    @Valid
    @JsonProperty(value="coordinates")
    private Coordinates coordinates;
    @JsonProperty(value="sha1")
    private String sha1;
    @JsonProperty(value="sha2")
    private String sha2;
    @JsonProperty(value="bytecodeHash")
    private String bytecodeHash;
    @JsonProperty(value="commitHash")
    private String commitHash;
    @NotNull(message="evidenceType is required")
    @JsonProperty(value="evidenceType")
    private @NotNull(message="evidenceType is required") EvidenceType evidenceType;

    public Evidence() {
    }

    public Evidence(Builder builder) {
        this.sha2 = builder.sha2;
        this.evidenceId = builder.evidenceId;
        this.coordinates = builder.coordinates;
        this.evidenceType = builder.evidenceType;
        if (this.evidenceType == EvidenceType.COORDINATES && (this.coordinates == null || this.coordinates.getCoordinateType() == null)) {
            throw new IllegalStateException("Coordinates are required for an Evidence object of COORDINATES type.");
        }
        this.sha1 = builder.sha1;
        this.bytecodeHash = builder.bytecodeHash;
        this.commitHash = builder.commitHash;
        this.evidencePaths = new ArrayList<EvidencePath>();
        builder.evidencePaths.iterator().forEachRemaining(evidencePath -> this.evidencePaths.add((EvidencePath)evidencePath));
    }

    public String toString() {
        return "Evidence{evidenceId='" + this.evidenceId + '\'' + ", coordinates=" + this.coordinates + ", evidencePaths=" + this.evidencePaths + ", sha1='" + this.sha1 + '\'' + ", sha2='" + this.sha2 + '\'' + ", bytecodeHash='" + this.bytecodeHash + '\'' + ", commitHash='" + this.commitHash + '\'' + ", evidenceType=" + this.evidenceType + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Evidence)) {
            return false;
        }
        Evidence evidence = (Evidence)o;
        return Objects.equals(this.getEvidenceId(), evidence.getEvidenceId()) && Objects.equals(this.getEvidencePaths(), evidence.getEvidencePaths()) && Objects.equals(this.getCoordinates(), evidence.getCoordinates()) && Objects.equals(this.getSha1(), evidence.getSha1()) && Objects.equals(this.getSha2(), evidence.getSha2()) && Objects.equals(this.getBytecodeHash(), evidence.getBytecodeHash()) && Objects.equals(this.getCommitHash(), evidence.getCommitHash()) && Objects.equals(this.getEvidenceType(), evidence.getEvidenceType());
    }

    public int hashCode() {
        return Objects.hash(this.getEvidenceId(), this.getEvidencePaths(), this.getCoordinates(), this.getSha1(), this.getSha2(), this.getBytecodeHash(), this.getCommitHash(), this.getEvidenceType());
    }

    public String getEvidenceId() {
        return this.evidenceId;
    }

    public List<EvidencePath> getEvidencePaths() {
        return this.evidencePaths;
    }

    public Coordinates getCoordinates() {
        return this.coordinates;
    }

    public String getSha1() {
        return this.sha1;
    }

    public String getSha2() {
        return this.sha2;
    }

    public String getBytecodeHash() {
        return this.bytecodeHash;
    }

    public String getCommitHash() {
        return this.commitHash;
    }

    public EvidenceType getEvidenceType() {
        return this.evidenceType;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Builder {
        private String evidenceId = UUID.randomUUID().toString();
        private Set<EvidencePath> evidencePaths = new TreeSet<EvidencePath>();
        private Coordinates coordinates;
        private String sha1;
        private String sha2;
        private String bytecodeHash;
        private String commitHash;
        private EvidenceType evidenceType;

        public Builder rebuildFromEvidenceAndPaths(Evidence evidence, List<EvidencePath> evidencePaths) {
            this.evidenceId = evidence.getEvidenceId();
            this.withEvidencePaths(evidencePaths);
            this.coordinates = evidence.getCoordinates();
            this.sha1 = evidence.getSha1();
            this.sha2 = evidence.getSha2();
            this.bytecodeHash = evidence.getBytecodeHash();
            this.commitHash = evidence.getCommitHash();
            this.evidenceType = evidence.getEvidenceType();
            return this;
        }

        public Builder withEvidenceId(String evidenceId) {
            this.evidenceId = evidenceId;
            return this;
        }

        public Builder withEvidencePath(EvidencePath path) {
            this.evidencePaths.add(path);
            return this;
        }

        public Builder withEvidencePaths(List<EvidencePath> evidencePaths) {
            this.evidencePaths.addAll(evidencePaths);
            return this;
        }

        public Builder withCoordinates(Coordinates coordinates) {
            this.coordinates = coordinates;
            return this;
        }

        public Builder withSha1(String sha1) {
            this.sha1 = sha1;
            return this;
        }

        public Builder withSha2(String sha2) {
            this.sha2 = sha2;
            return this;
        }

        public Builder withByteCodeHash(String bytecodeHash) {
            this.bytecodeHash = bytecodeHash;
            return this;
        }

        public Builder withBytecodeHash(String bytecodeHash) {
            return this.withByteCodeHash(bytecodeHash);
        }

        public Builder withCommitHash(String commitHash) {
            this.commitHash = commitHash;
            return this;
        }

        public Builder withEvidenceType(EvidenceType evidenceType) {
            this.evidenceType = evidenceType;
            return this;
        }

        public Evidence build() {
            return new Evidence(this);
        }
    }
}

