/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.evidence;

import javax.annotation.Nonnull;

public enum ArtifactSeverity {
    LOW(0.0f, 3.9f),
    MEDIUM(4.0f, 6.9f),
    HIGH(7.0f, 10.0f),
    CRITICAL(9.0f, 10.0f);

    private final float lowerBound;
    private final float upperBound;

    @Nonnull
    public static ArtifactSeverity fromCvss2Score(float value) {
        if ((double)value < 4.0) {
            return LOW;
        }
        if ((double)value < 7.0) {
            return MEDIUM;
        }
        return HIGH;
    }

    public static ArtifactSeverity fromCvss3Score(float value) {
        if ((double)value < 4.0) {
            return LOW;
        }
        if ((double)value < 7.0) {
            return MEDIUM;
        }
        if ((double)value < 9.0) {
            return HIGH;
        }
        return CRITICAL;
    }

    private ArtifactSeverity(float lowerBound, float upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public float getLowerBoundInclusive() {
        return this.lowerBound;
    }

    public float getUpperBoundInclusive() {
        return this.upperBound;
    }
}

