/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sourceclear.api.data.events.WorkspaceModel;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.LongUnaryOperator;
import java.util.function.UnaryOperator;

abstract class WorkspaceModel_Builder {
    private long id;
    private String name;
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    WorkspaceModel_Builder() {
    }

    public static WorkspaceModel.Builder from(WorkspaceModel value) {
        if (value instanceof Rebuildable) {
            return ((Rebuildable)value).toBuilder();
        }
        return new WorkspaceModel.Builder().mergeFrom(value);
    }

    @JsonProperty(value="id")
    public WorkspaceModel.Builder setId(long id) {
        this.id = id;
        this._unsetProperties.remove((Object)Property.ID);
        return (WorkspaceModel.Builder)this;
    }

    public WorkspaceModel.Builder mapId(LongUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return this.setId(mapper.applyAsLong(this.getId()));
    }

    public long getId() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.ID) ? 1 : 0) != 0, (Object)"id not set");
        return this.id;
    }

    @JsonProperty(value="name")
    public WorkspaceModel.Builder setName(String name) {
        this.name = Objects.requireNonNull(name);
        this._unsetProperties.remove((Object)Property.NAME);
        return (WorkspaceModel.Builder)this;
    }

    public WorkspaceModel.Builder mapName(UnaryOperator<String> mapper) {
        Objects.requireNonNull(mapper);
        return this.setName((String)mapper.apply(this.getName()));
    }

    public String getName() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.NAME) ? 1 : 0) != 0, (Object)"name not set");
        return this.name;
    }

    public WorkspaceModel.Builder mergeFrom(WorkspaceModel value) {
        WorkspaceModel.Builder defaults = new WorkspaceModel.Builder();
        if (defaults._unsetProperties.contains((Object)Property.ID) || value.getId() != ((WorkspaceModel_Builder)defaults).getId()) {
            this.setId(value.getId());
        }
        if (defaults._unsetProperties.contains((Object)Property.NAME) || !Objects.equals(value.getName(), ((WorkspaceModel_Builder)defaults).getName())) {
            this.setName(value.getName());
        }
        return (WorkspaceModel.Builder)this;
    }

    public WorkspaceModel.Builder mergeFrom(WorkspaceModel.Builder template) {
        WorkspaceModel.Builder base = template;
        WorkspaceModel.Builder defaults = new WorkspaceModel.Builder();
        if (!base._unsetProperties.contains((Object)Property.ID) && (defaults._unsetProperties.contains((Object)Property.ID) || template.getId() != ((WorkspaceModel_Builder)defaults).getId())) {
            this.setId(template.getId());
        }
        if (!(base._unsetProperties.contains((Object)Property.NAME) || !defaults._unsetProperties.contains((Object)Property.NAME) && Objects.equals(template.getName(), ((WorkspaceModel_Builder)defaults).getName()))) {
            this.setName(template.getName());
        }
        return (WorkspaceModel.Builder)this;
    }

    public WorkspaceModel.Builder clear() {
        WorkspaceModel.Builder defaults = new WorkspaceModel.Builder();
        this.id = defaults.id;
        this.name = defaults.name;
        this._unsetProperties.clear();
        this._unsetProperties.addAll(defaults._unsetProperties);
        return (WorkspaceModel.Builder)this;
    }

    public WorkspaceModel build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", this._unsetProperties);
        return new Value(this);
    }

    @VisibleForTesting
    public WorkspaceModel buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    extends Rebuildable {
        private final long id;
        private final String name;
        private final EnumSet<Property> _unsetProperties;

        Partial(WorkspaceModel_Builder builder) {
            this.id = builder.id;
            this.name = builder.name;
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        @JsonProperty(value="id")
        public long getId() {
            if (this._unsetProperties.contains((Object)Property.ID)) {
                throw new UnsupportedOperationException("id not set");
            }
            return this.id;
        }

        @Override
        @JsonProperty(value="name")
        public String getName() {
            if (this._unsetProperties.contains((Object)Property.NAME)) {
                throw new UnsupportedOperationException("name not set");
            }
            return this.name;
        }

        @Override
        public WorkspaceModel.Builder toBuilder() {
            PartialBuilder builder = new PartialBuilder();
            ((WorkspaceModel_Builder)builder).id = this.id;
            ((WorkspaceModel_Builder)builder).name = this.name;
            ((WorkspaceModel_Builder)builder)._unsetProperties.clear();
            ((WorkspaceModel_Builder)builder)._unsetProperties.addAll(this._unsetProperties);
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return this.id == other.id && Objects.equals(this.name, other.name) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name, this._unsetProperties);
        }

        public String toString() {
            StringBuilder result = new StringBuilder("partial WorkspaceModel{");
            String separator = "";
            if (!this._unsetProperties.contains((Object)Property.ID)) {
                result.append("id=").append(this.id);
                separator = ", ";
            }
            if (!this._unsetProperties.contains((Object)Property.NAME)) {
                result.append(separator).append("name=").append(this.name);
            }
            return result.append("}").toString();
        }

        private static class PartialBuilder
        extends WorkspaceModel.Builder {
            private PartialBuilder() {
            }

            @Override
            public WorkspaceModel build() {
                return this.buildPartial();
            }
        }
    }

    private static final class Value
    extends Rebuildable {
        private final long id;
        private final String name;

        private Value(WorkspaceModel_Builder builder) {
            this.id = builder.id;
            this.name = builder.name;
        }

        @Override
        @JsonProperty(value="id")
        public long getId() {
            return this.id;
        }

        @Override
        @JsonProperty(value="name")
        public String getName() {
            return this.name;
        }

        @Override
        public WorkspaceModel.Builder toBuilder() {
            WorkspaceModel.Builder builder = new WorkspaceModel.Builder();
            ((WorkspaceModel_Builder)builder).id = this.id;
            ((WorkspaceModel_Builder)builder).name = this.name;
            ((WorkspaceModel_Builder)builder)._unsetProperties.clear();
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return this.id == other.id && Objects.equals(this.name, other.name);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name);
        }

        public String toString() {
            return "WorkspaceModel{id=" + this.id + ", name=" + this.name + "}";
        }
    }

    private static abstract class Rebuildable
    implements WorkspaceModel {
        private Rebuildable() {
        }

        public abstract WorkspaceModel.Builder toBuilder();
    }

    private static enum Property {
        ID("id"),
        NAME("name");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

