/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.analytics;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.sourceclear.api.data.analytics.BuildCommandType;
import com.sourceclear.api.data.analytics.CollectorData;
import java.util.Objects;
import java.util.function.UnaryOperator;

abstract class CollectorData_Builder {
    private String collectorName;
    private String buildCommand;
    private BuildCommandType buildCommandType;
    private boolean buildCommandSuccessful;

    CollectorData_Builder() {
    }

    public static CollectorData.Builder from(CollectorData value) {
        if (value instanceof Rebuildable) {
            return ((Rebuildable)value).toBuilder();
        }
        return new CollectorData.Builder().mergeFrom(value);
    }

    @JsonProperty(value="collectorName")
    public CollectorData.Builder setCollectorName(String collectorName) {
        this.collectorName = Objects.requireNonNull(collectorName);
        return (CollectorData.Builder)this;
    }

    public CollectorData.Builder mapCollectorName(UnaryOperator<String> mapper) {
        return this.setCollectorName((String)mapper.apply(this.getCollectorName()));
    }

    public String getCollectorName() {
        return this.collectorName;
    }

    @JsonProperty(value="buildCommand")
    public CollectorData.Builder setBuildCommand(String buildCommand) {
        this.buildCommand = Objects.requireNonNull(buildCommand);
        return (CollectorData.Builder)this;
    }

    public CollectorData.Builder mapBuildCommand(UnaryOperator<String> mapper) {
        return this.setBuildCommand((String)mapper.apply(this.getBuildCommand()));
    }

    public String getBuildCommand() {
        return this.buildCommand;
    }

    @JsonProperty(value="buildCommandType")
    public CollectorData.Builder setBuildCommandType(BuildCommandType buildCommandType) {
        this.buildCommandType = Objects.requireNonNull(buildCommandType);
        return (CollectorData.Builder)this;
    }

    public CollectorData.Builder mapBuildCommandType(UnaryOperator<BuildCommandType> mapper) {
        return this.setBuildCommandType((BuildCommandType)((Object)mapper.apply(this.getBuildCommandType())));
    }

    public BuildCommandType getBuildCommandType() {
        return this.buildCommandType;
    }

    @JsonProperty(value="buildCommandSuccessful")
    public CollectorData.Builder setBuildCommandSuccessful(boolean buildCommandSuccessful) {
        this.buildCommandSuccessful = buildCommandSuccessful;
        return (CollectorData.Builder)this;
    }

    public CollectorData.Builder mapBuildCommandSuccessful(UnaryOperator<Boolean> mapper) {
        return this.setBuildCommandSuccessful((Boolean)mapper.apply(this.isBuildCommandSuccessful()));
    }

    public boolean isBuildCommandSuccessful() {
        return this.buildCommandSuccessful;
    }

    public CollectorData.Builder mergeFrom(CollectorData value) {
        CollectorData.Builder defaults = new CollectorData.Builder();
        if (!Objects.equals(value.getCollectorName(), ((CollectorData_Builder)defaults).getCollectorName())) {
            this.setCollectorName(value.getCollectorName());
        }
        if (!Objects.equals(value.getBuildCommand(), ((CollectorData_Builder)defaults).getBuildCommand())) {
            this.setBuildCommand(value.getBuildCommand());
        }
        if (!Objects.equals((Object)value.getBuildCommandType(), (Object)((CollectorData_Builder)defaults).getBuildCommandType())) {
            this.setBuildCommandType(value.getBuildCommandType());
        }
        if (value.isBuildCommandSuccessful() != ((CollectorData_Builder)defaults).isBuildCommandSuccessful()) {
            this.setBuildCommandSuccessful(value.isBuildCommandSuccessful());
        }
        return (CollectorData.Builder)this;
    }

    public CollectorData.Builder mergeFrom(CollectorData.Builder template) {
        CollectorData.Builder defaults = new CollectorData.Builder();
        if (!Objects.equals(template.getCollectorName(), ((CollectorData_Builder)defaults).getCollectorName())) {
            this.setCollectorName(template.getCollectorName());
        }
        if (!Objects.equals(template.getBuildCommand(), ((CollectorData_Builder)defaults).getBuildCommand())) {
            this.setBuildCommand(template.getBuildCommand());
        }
        if (!Objects.equals((Object)template.getBuildCommandType(), (Object)((CollectorData_Builder)defaults).getBuildCommandType())) {
            this.setBuildCommandType(template.getBuildCommandType());
        }
        if (template.isBuildCommandSuccessful() != ((CollectorData_Builder)defaults).isBuildCommandSuccessful()) {
            this.setBuildCommandSuccessful(template.isBuildCommandSuccessful());
        }
        return (CollectorData.Builder)this;
    }

    public CollectorData.Builder clear() {
        CollectorData.Builder defaults = new CollectorData.Builder();
        this.collectorName = defaults.collectorName;
        this.buildCommand = defaults.buildCommand;
        this.buildCommandType = defaults.buildCommandType;
        this.buildCommandSuccessful = defaults.buildCommandSuccessful;
        return (CollectorData.Builder)this;
    }

    public CollectorData build() {
        return new Value(this);
    }

    @VisibleForTesting
    public CollectorData buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    extends Rebuildable {
        private final String collectorName;
        private final String buildCommand;
        private final BuildCommandType buildCommandType;
        private final boolean buildCommandSuccessful;

        Partial(CollectorData_Builder builder) {
            this.collectorName = builder.collectorName;
            this.buildCommand = builder.buildCommand;
            this.buildCommandType = builder.buildCommandType;
            this.buildCommandSuccessful = builder.buildCommandSuccessful;
        }

        @Override
        @JsonProperty(value="collectorName")
        public String getCollectorName() {
            return this.collectorName;
        }

        @Override
        @JsonProperty(value="buildCommand")
        public String getBuildCommand() {
            return this.buildCommand;
        }

        @Override
        @JsonProperty(value="buildCommandType")
        public BuildCommandType getBuildCommandType() {
            return this.buildCommandType;
        }

        @Override
        @JsonProperty(value="buildCommandSuccessful")
        public boolean isBuildCommandSuccessful() {
            return this.buildCommandSuccessful;
        }

        @Override
        public CollectorData.Builder toBuilder() {
            PartialBuilder builder = new PartialBuilder();
            ((CollectorData_Builder)builder).collectorName = this.collectorName;
            ((CollectorData_Builder)builder).buildCommand = this.buildCommand;
            ((CollectorData_Builder)builder).buildCommandType = this.buildCommandType;
            ((CollectorData_Builder)builder).buildCommandSuccessful = this.buildCommandSuccessful;
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals(this.collectorName, other.collectorName) && Objects.equals(this.buildCommand, other.buildCommand) && Objects.equals((Object)this.buildCommandType, (Object)other.buildCommandType) && this.buildCommandSuccessful == other.buildCommandSuccessful;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.collectorName, this.buildCommand, this.buildCommandType, this.buildCommandSuccessful});
        }

        public String toString() {
            return "partial CollectorData{collectorName=" + this.collectorName + ", buildCommand=" + this.buildCommand + ", buildCommandType=" + (Object)((Object)this.buildCommandType) + ", buildCommandSuccessful=" + this.buildCommandSuccessful + "}";
        }

        private static class PartialBuilder
        extends CollectorData.Builder {
            private PartialBuilder() {
            }

            @Override
            public CollectorData build() {
                return this.buildPartial();
            }
        }
    }

    private static final class Value
    extends Rebuildable {
        private final String collectorName;
        private final String buildCommand;
        private final BuildCommandType buildCommandType;
        private final boolean buildCommandSuccessful;

        private Value(CollectorData_Builder builder) {
            this.collectorName = builder.collectorName;
            this.buildCommand = builder.buildCommand;
            this.buildCommandType = builder.buildCommandType;
            this.buildCommandSuccessful = builder.buildCommandSuccessful;
        }

        @Override
        @JsonProperty(value="collectorName")
        public String getCollectorName() {
            return this.collectorName;
        }

        @Override
        @JsonProperty(value="buildCommand")
        public String getBuildCommand() {
            return this.buildCommand;
        }

        @Override
        @JsonProperty(value="buildCommandType")
        public BuildCommandType getBuildCommandType() {
            return this.buildCommandType;
        }

        @Override
        @JsonProperty(value="buildCommandSuccessful")
        public boolean isBuildCommandSuccessful() {
            return this.buildCommandSuccessful;
        }

        @Override
        public CollectorData.Builder toBuilder() {
            CollectorData.Builder builder = new CollectorData.Builder();
            ((CollectorData_Builder)builder).collectorName = this.collectorName;
            ((CollectorData_Builder)builder).buildCommand = this.buildCommand;
            ((CollectorData_Builder)builder).buildCommandType = this.buildCommandType;
            ((CollectorData_Builder)builder).buildCommandSuccessful = this.buildCommandSuccessful;
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals(this.collectorName, other.collectorName) && Objects.equals(this.buildCommand, other.buildCommand) && Objects.equals((Object)this.buildCommandType, (Object)other.buildCommandType) && this.buildCommandSuccessful == other.buildCommandSuccessful;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.collectorName, this.buildCommand, this.buildCommandType, this.buildCommandSuccessful});
        }

        public String toString() {
            return "CollectorData{collectorName=" + this.collectorName + ", buildCommand=" + this.buildCommand + ", buildCommandType=" + (Object)((Object)this.buildCommandType) + ", buildCommandSuccessful=" + this.buildCommandSuccessful + "}";
        }
    }

    private static abstract class Rebuildable
    implements CollectorData {
        private Rebuildable() {
        }

        public abstract CollectorData.Builder toBuilder();
    }
}

