/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.analytics;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.sourceclear.api.data.analytics.AgentRuntimeData;
import com.sourceclear.api.data.analytics.CollectorData;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.BaseStream;
import javax.annotation.Nullable;

abstract class AgentRuntimeData_Builder {
    private final CollectorDataBuilderList collectorsRun = new CollectorDataBuilderList();
    private final CollectorDataBuilderList unsupportedBuildSystems = new CollectorDataBuilderList();
    private String scanAttributesJSON;
    private String agentType;
    private String agentVersion;
    private String OS;
    private String OSVersion;
    private String JVMVersion;
    private boolean quickScan;
    private boolean recursiveScan;
    @Nullable
    private Long scanTime = null;
    @Nullable
    private String scanErrorMessage = null;

    AgentRuntimeData_Builder() {
    }

    public static AgentRuntimeData.Builder from(AgentRuntimeData value) {
        if (value instanceof Rebuildable) {
            return ((Rebuildable)value).toBuilder();
        }
        return new AgentRuntimeData.Builder().mergeFrom(value);
    }

    public AgentRuntimeData.Builder addCollectorsRun(CollectorData element) {
        this.collectorsRun.addValue(element);
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder addCollectorsRun(CollectorData.Builder builder) {
        this.collectorsRun.add(new CollectorData.Builder().mergeFrom(builder));
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder addCollectorsRun(CollectorData ... elements) {
        return this.addAllCollectorsRun(Arrays.asList(elements));
    }

    public AgentRuntimeData.Builder addCollectorsRun(CollectorData.Builder ... elementBuilders) {
        return this.addAllBuildersOfCollectorsRun(Arrays.asList(elementBuilders));
    }

    public AgentRuntimeData.Builder addAllCollectorsRun(Spliterator<? extends CollectorData> elements) {
        long newSize;
        if ((elements.characteristics() & 0x40) != 0 && (newSize = elements.estimateSize() + (long)this.collectorsRun.size()) <= Integer.MAX_VALUE) {
            this.collectorsRun.ensureCapacity((int)newSize);
        }
        elements.forEachRemaining(this::addCollectorsRun);
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder addAllBuildersOfCollectorsRun(Spliterator<? extends CollectorData.Builder> elementBuilders) {
        long newSize;
        if ((elementBuilders.characteristics() & 0x40) != 0 && (newSize = elementBuilders.estimateSize() + (long)this.collectorsRun.size()) <= Integer.MAX_VALUE) {
            this.collectorsRun.ensureCapacity((int)newSize);
        }
        elementBuilders.forEachRemaining(this::addCollectorsRun);
        return (AgentRuntimeData.Builder)this;
    }

    @JsonProperty(value="collectorsRun")
    public AgentRuntimeData.Builder addAllCollectorsRun(Iterable<? extends CollectorData> elements) {
        this.collectorsRun.addAllValues(elements);
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder addAllBuildersOfCollectorsRun(Iterable<? extends CollectorData.Builder> elementBuilders) {
        return this.addAllBuildersOfCollectorsRun(elementBuilders.spliterator());
    }

    public AgentRuntimeData.Builder addAllCollectorsRun(BaseStream<? extends CollectorData, ?> elements) {
        return this.addAllCollectorsRun(elements.spliterator());
    }

    public AgentRuntimeData.Builder addAllBuildersOfCollectorsRun(BaseStream<? extends CollectorData.Builder, ?> elementBuilders) {
        return this.addAllBuildersOfCollectorsRun(elementBuilders.spliterator());
    }

    public AgentRuntimeData.Builder mutateCollectorsRun(Consumer<? super List<CollectorData.Builder>> mutator) {
        mutator.accept(this.collectorsRun);
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder clearCollectorsRun() {
        this.collectorsRun.clear();
        return (AgentRuntimeData.Builder)this;
    }

    public List<CollectorData.Builder> getBuildersOfCollectorsRun() {
        return Collections.unmodifiableList(this.collectorsRun);
    }

    public AgentRuntimeData.Builder addUnsupportedBuildSystems(CollectorData element) {
        this.unsupportedBuildSystems.addValue(element);
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder addUnsupportedBuildSystems(CollectorData.Builder builder) {
        this.unsupportedBuildSystems.add(new CollectorData.Builder().mergeFrom(builder));
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder addUnsupportedBuildSystems(CollectorData ... elements) {
        return this.addAllUnsupportedBuildSystems(Arrays.asList(elements));
    }

    public AgentRuntimeData.Builder addUnsupportedBuildSystems(CollectorData.Builder ... elementBuilders) {
        return this.addAllBuildersOfUnsupportedBuildSystems(Arrays.asList(elementBuilders));
    }

    public AgentRuntimeData.Builder addAllUnsupportedBuildSystems(Spliterator<? extends CollectorData> elements) {
        long newSize;
        if ((elements.characteristics() & 0x40) != 0 && (newSize = elements.estimateSize() + (long)this.unsupportedBuildSystems.size()) <= Integer.MAX_VALUE) {
            this.unsupportedBuildSystems.ensureCapacity((int)newSize);
        }
        elements.forEachRemaining(this::addUnsupportedBuildSystems);
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder addAllBuildersOfUnsupportedBuildSystems(Spliterator<? extends CollectorData.Builder> elementBuilders) {
        long newSize;
        if ((elementBuilders.characteristics() & 0x40) != 0 && (newSize = elementBuilders.estimateSize() + (long)this.unsupportedBuildSystems.size()) <= Integer.MAX_VALUE) {
            this.unsupportedBuildSystems.ensureCapacity((int)newSize);
        }
        elementBuilders.forEachRemaining(this::addUnsupportedBuildSystems);
        return (AgentRuntimeData.Builder)this;
    }

    @JsonProperty(value="unsupportedBuildSystems")
    public AgentRuntimeData.Builder addAllUnsupportedBuildSystems(Iterable<? extends CollectorData> elements) {
        this.unsupportedBuildSystems.addAllValues(elements);
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder addAllBuildersOfUnsupportedBuildSystems(Iterable<? extends CollectorData.Builder> elementBuilders) {
        return this.addAllBuildersOfUnsupportedBuildSystems(elementBuilders.spliterator());
    }

    public AgentRuntimeData.Builder addAllUnsupportedBuildSystems(BaseStream<? extends CollectorData, ?> elements) {
        return this.addAllUnsupportedBuildSystems(elements.spliterator());
    }

    public AgentRuntimeData.Builder addAllBuildersOfUnsupportedBuildSystems(BaseStream<? extends CollectorData.Builder, ?> elementBuilders) {
        return this.addAllBuildersOfUnsupportedBuildSystems(elementBuilders.spliterator());
    }

    public AgentRuntimeData.Builder mutateUnsupportedBuildSystems(Consumer<? super List<CollectorData.Builder>> mutator) {
        mutator.accept(this.unsupportedBuildSystems);
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder clearUnsupportedBuildSystems() {
        this.unsupportedBuildSystems.clear();
        return (AgentRuntimeData.Builder)this;
    }

    public List<CollectorData.Builder> getBuildersOfUnsupportedBuildSystems() {
        return Collections.unmodifiableList(this.unsupportedBuildSystems);
    }

    @JsonProperty(value="scanAttributesJSON")
    public AgentRuntimeData.Builder setScanAttributesJSON(String scanAttributesJSON) {
        this.scanAttributesJSON = Objects.requireNonNull(scanAttributesJSON);
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder mapScanAttributesJSON(UnaryOperator<String> mapper) {
        return this.setScanAttributesJSON((String)mapper.apply(this.getScanAttributesJSON()));
    }

    public String getScanAttributesJSON() {
        return this.scanAttributesJSON;
    }

    @JsonProperty(value="agentType")
    public AgentRuntimeData.Builder setAgentType(String agentType) {
        this.agentType = Objects.requireNonNull(agentType);
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder mapAgentType(UnaryOperator<String> mapper) {
        return this.setAgentType((String)mapper.apply(this.getAgentType()));
    }

    public String getAgentType() {
        return this.agentType;
    }

    @JsonProperty(value="agentVersion")
    public AgentRuntimeData.Builder setAgentVersion(String agentVersion) {
        this.agentVersion = Objects.requireNonNull(agentVersion);
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder mapAgentVersion(UnaryOperator<String> mapper) {
        return this.setAgentVersion((String)mapper.apply(this.getAgentVersion()));
    }

    public String getAgentVersion() {
        return this.agentVersion;
    }

    @JsonProperty(value="OS")
    public AgentRuntimeData.Builder setOS(String OS2) {
        this.OS = Objects.requireNonNull(OS2);
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder mapOS(UnaryOperator<String> mapper) {
        return this.setOS((String)mapper.apply(this.getOS()));
    }

    public String getOS() {
        return this.OS;
    }

    @JsonProperty(value="OSVersion")
    public AgentRuntimeData.Builder setOSVersion(String OSVersion) {
        this.OSVersion = Objects.requireNonNull(OSVersion);
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder mapOSVersion(UnaryOperator<String> mapper) {
        return this.setOSVersion((String)mapper.apply(this.getOSVersion()));
    }

    public String getOSVersion() {
        return this.OSVersion;
    }

    @JsonProperty(value="JVMVersion")
    public AgentRuntimeData.Builder setJVMVersion(String JVMVersion) {
        this.JVMVersion = Objects.requireNonNull(JVMVersion);
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder mapJVMVersion(UnaryOperator<String> mapper) {
        return this.setJVMVersion((String)mapper.apply(this.getJVMVersion()));
    }

    public String getJVMVersion() {
        return this.JVMVersion;
    }

    @JsonProperty(value="quickScan")
    public AgentRuntimeData.Builder setQuickScan(boolean quickScan) {
        this.quickScan = quickScan;
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder mapQuickScan(UnaryOperator<Boolean> mapper) {
        return this.setQuickScan((Boolean)mapper.apply(this.isQuickScan()));
    }

    public boolean isQuickScan() {
        return this.quickScan;
    }

    @JsonProperty(value="recursiveScan")
    public AgentRuntimeData.Builder setRecursiveScan(boolean recursiveScan) {
        this.recursiveScan = recursiveScan;
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder mapRecursiveScan(UnaryOperator<Boolean> mapper) {
        return this.setRecursiveScan((Boolean)mapper.apply(this.isRecursiveScan()));
    }

    public boolean isRecursiveScan() {
        return this.recursiveScan;
    }

    @JsonProperty(value="scanTime")
    public AgentRuntimeData.Builder setScanTime(@Nullable Long scanTime) {
        this.scanTime = scanTime;
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder mapScanTime(UnaryOperator<Long> mapper) {
        Objects.requireNonNull(mapper);
        Long scanTime = this.getScanTime();
        if (scanTime != null) {
            this.setScanTime((Long)mapper.apply(scanTime));
        }
        return (AgentRuntimeData.Builder)this;
    }

    @Nullable
    public Long getScanTime() {
        return this.scanTime;
    }

    @JsonProperty(value="scanErrorMessage")
    public AgentRuntimeData.Builder setScanErrorMessage(@Nullable String scanErrorMessage) {
        this.scanErrorMessage = scanErrorMessage;
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder mapScanErrorMessage(UnaryOperator<String> mapper) {
        Objects.requireNonNull(mapper);
        String scanErrorMessage = this.getScanErrorMessage();
        if (scanErrorMessage != null) {
            this.setScanErrorMessage((String)mapper.apply(scanErrorMessage));
        }
        return (AgentRuntimeData.Builder)this;
    }

    @Nullable
    public String getScanErrorMessage() {
        return this.scanErrorMessage;
    }

    public AgentRuntimeData.Builder mergeFrom(AgentRuntimeData value) {
        this.addAllCollectorsRun(value.getCollectorsRun());
        this.addAllUnsupportedBuildSystems(value.getUnsupportedBuildSystems());
        AgentRuntimeData.Builder defaults = new AgentRuntimeData.Builder();
        if (!Objects.equals(value.getScanAttributesJSON(), ((AgentRuntimeData_Builder)defaults).getScanAttributesJSON())) {
            this.setScanAttributesJSON(value.getScanAttributesJSON());
        }
        if (!Objects.equals(value.getAgentType(), ((AgentRuntimeData_Builder)defaults).getAgentType())) {
            this.setAgentType(value.getAgentType());
        }
        if (!Objects.equals(value.getAgentVersion(), ((AgentRuntimeData_Builder)defaults).getAgentVersion())) {
            this.setAgentVersion(value.getAgentVersion());
        }
        if (!Objects.equals(value.getOS(), ((AgentRuntimeData_Builder)defaults).getOS())) {
            this.setOS(value.getOS());
        }
        if (!Objects.equals(value.getOSVersion(), ((AgentRuntimeData_Builder)defaults).getOSVersion())) {
            this.setOSVersion(value.getOSVersion());
        }
        if (!Objects.equals(value.getJVMVersion(), ((AgentRuntimeData_Builder)defaults).getJVMVersion())) {
            this.setJVMVersion(value.getJVMVersion());
        }
        if (value.isQuickScan() != ((AgentRuntimeData_Builder)defaults).isQuickScan()) {
            this.setQuickScan(value.isQuickScan());
        }
        if (value.isRecursiveScan() != ((AgentRuntimeData_Builder)defaults).isRecursiveScan()) {
            this.setRecursiveScan(value.isRecursiveScan());
        }
        if (!Objects.equals(value.getScanTime(), ((AgentRuntimeData_Builder)defaults).getScanTime())) {
            this.setScanTime(value.getScanTime());
        }
        if (!Objects.equals(value.getScanErrorMessage(), ((AgentRuntimeData_Builder)defaults).getScanErrorMessage())) {
            this.setScanErrorMessage(value.getScanErrorMessage());
        }
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder mergeFrom(AgentRuntimeData.Builder template) {
        AgentRuntimeData.Builder base = template;
        this.addAllBuildersOfCollectorsRun(base.collectorsRun);
        this.addAllBuildersOfUnsupportedBuildSystems(base.unsupportedBuildSystems);
        AgentRuntimeData.Builder defaults = new AgentRuntimeData.Builder();
        if (!Objects.equals(template.getScanAttributesJSON(), ((AgentRuntimeData_Builder)defaults).getScanAttributesJSON())) {
            this.setScanAttributesJSON(template.getScanAttributesJSON());
        }
        if (!Objects.equals(template.getAgentType(), ((AgentRuntimeData_Builder)defaults).getAgentType())) {
            this.setAgentType(template.getAgentType());
        }
        if (!Objects.equals(template.getAgentVersion(), ((AgentRuntimeData_Builder)defaults).getAgentVersion())) {
            this.setAgentVersion(template.getAgentVersion());
        }
        if (!Objects.equals(template.getOS(), ((AgentRuntimeData_Builder)defaults).getOS())) {
            this.setOS(template.getOS());
        }
        if (!Objects.equals(template.getOSVersion(), ((AgentRuntimeData_Builder)defaults).getOSVersion())) {
            this.setOSVersion(template.getOSVersion());
        }
        if (!Objects.equals(template.getJVMVersion(), ((AgentRuntimeData_Builder)defaults).getJVMVersion())) {
            this.setJVMVersion(template.getJVMVersion());
        }
        if (template.isQuickScan() != ((AgentRuntimeData_Builder)defaults).isQuickScan()) {
            this.setQuickScan(template.isQuickScan());
        }
        if (template.isRecursiveScan() != ((AgentRuntimeData_Builder)defaults).isRecursiveScan()) {
            this.setRecursiveScan(template.isRecursiveScan());
        }
        if (!Objects.equals(template.getScanTime(), ((AgentRuntimeData_Builder)defaults).getScanTime())) {
            this.setScanTime(template.getScanTime());
        }
        if (!Objects.equals(template.getScanErrorMessage(), ((AgentRuntimeData_Builder)defaults).getScanErrorMessage())) {
            this.setScanErrorMessage(template.getScanErrorMessage());
        }
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData.Builder clear() {
        this.clearCollectorsRun();
        this.clearUnsupportedBuildSystems();
        AgentRuntimeData.Builder defaults = new AgentRuntimeData.Builder();
        this.scanAttributesJSON = defaults.scanAttributesJSON;
        this.agentType = defaults.agentType;
        this.agentVersion = defaults.agentVersion;
        this.OS = defaults.OS;
        this.OSVersion = defaults.OSVersion;
        this.JVMVersion = defaults.JVMVersion;
        this.quickScan = defaults.quickScan;
        this.recursiveScan = defaults.recursiveScan;
        this.scanTime = defaults.scanTime;
        this.scanErrorMessage = defaults.scanErrorMessage;
        return (AgentRuntimeData.Builder)this;
    }

    public AgentRuntimeData build() {
        return new Value(this);
    }

    @VisibleForTesting
    public AgentRuntimeData buildPartial() {
        return new Partial(this);
    }

    private class CollectorDataBuilderList
    extends AbstractList<CollectorData.Builder>
    implements RandomAccess {
        private List elements = ImmutableList.of();

        private CollectorDataBuilderList() {
        }

        @Override
        public int size() {
            return this.elements.size();
        }

        @Override
        public CollectorData.Builder get(int index) {
            Object element = this.elements.get(index);
            if (element instanceof CollectorData) {
                if (this.elements instanceof ImmutableList) {
                    this.elements = new ArrayList(this.elements);
                }
                element = new CollectorData.Builder().mergeFrom((CollectorData)element);
                this.elements.set(index, element);
            }
            return (CollectorData.Builder)element;
        }

        @Override
        public CollectorData.Builder set(int index, CollectorData.Builder element) {
            CollectorData.Builder oldElement;
            if (this.elements instanceof ImmutableList) {
                this.elements = new ArrayList(this.elements);
            }
            if ((oldElement = this.elements.set(index, element)) instanceof CollectorData) {
                oldElement = new CollectorData.Builder().mergeFrom((CollectorData)((Object)oldElement));
            }
            return oldElement;
        }

        @Override
        public void add(int index, CollectorData.Builder element) {
            if (this.elements instanceof ImmutableList) {
                this.elements = new ArrayList(this.elements);
            }
            this.elements.add(index, element);
        }

        @Override
        public CollectorData.Builder remove(int index) {
            Object oldElement;
            if (this.elements instanceof ImmutableList) {
                this.elements = new ArrayList(this.elements);
            }
            if ((oldElement = this.elements.remove(index)) instanceof CollectorData) {
                oldElement = new CollectorData.Builder().mergeFrom((CollectorData)oldElement);
            }
            return (CollectorData.Builder)oldElement;
        }

        void ensureCapacity(int minCapacity) {
            if (this.elements instanceof ImmutableList) {
                this.elements = new ArrayList(this.elements);
            }
            ((ArrayList)this.elements).ensureCapacity(minCapacity);
        }

        void addValue(CollectorData element) {
            Objects.requireNonNull(element);
            if (this.elements instanceof ImmutableList) {
                this.elements = new ArrayList(this.elements);
            }
            this.elements.add(element);
        }

        void addAllValues(Iterable<? extends CollectorData> values) {
            if (this.elements.isEmpty() && values instanceof ImmutableList) {
                this.elements = (ImmutableList)values;
            } else {
                if (this.elements instanceof ImmutableList) {
                    this.elements = new ArrayList(this.elements);
                }
                if (values instanceof Collection) {
                    int newSize = this.elements.size() + ((Collection)values).size();
                    ((ArrayList)this.elements).ensureCapacity(newSize);
                }
                values.forEach(this::addValue);
            }
        }

        ImmutableList<CollectorData> build() {
            if (this.elements instanceof ImmutableList) {
                return (ImmutableList)this.elements;
            }
            ImmutableList.Builder values = ImmutableList.builder();
            for (Object element : this.elements) {
                values.add((Object)this.build(element));
            }
            return values.build();
        }

        private CollectorData build(Object element) {
            if (element instanceof CollectorData) {
                return (CollectorData)element;
            }
            return ((CollectorData.Builder)element).build();
        }

        ImmutableList<CollectorData> buildPartial() {
            if (this.elements instanceof ImmutableList) {
                return (ImmutableList)this.elements;
            }
            ImmutableList.Builder values = ImmutableList.builder();
            for (Object element : this.elements) {
                values.add((Object)this.buildPartial(element));
            }
            return values.build();
        }

        private CollectorData buildPartial(Object element) {
            if (element instanceof CollectorData) {
                return (CollectorData)element;
            }
            return ((CollectorData.Builder)element).buildPartial();
        }
    }

    private static final class Partial
    extends Rebuildable {
        private final ImmutableList<CollectorData> collectorsRun;
        private final ImmutableList<CollectorData> unsupportedBuildSystems;
        private final String scanAttributesJSON;
        private final String agentType;
        private final String agentVersion;
        private final String OS;
        private final String OSVersion;
        private final String JVMVersion;
        private final boolean quickScan;
        private final boolean recursiveScan;
        @Nullable
        private final Long scanTime;
        @Nullable
        private final String scanErrorMessage;

        Partial(AgentRuntimeData_Builder builder) {
            this.collectorsRun = builder.collectorsRun.buildPartial();
            this.unsupportedBuildSystems = builder.unsupportedBuildSystems.buildPartial();
            this.scanAttributesJSON = builder.scanAttributesJSON;
            this.agentType = builder.agentType;
            this.agentVersion = builder.agentVersion;
            this.OS = builder.OS;
            this.OSVersion = builder.OSVersion;
            this.JVMVersion = builder.JVMVersion;
            this.quickScan = builder.quickScan;
            this.recursiveScan = builder.recursiveScan;
            this.scanTime = builder.scanTime;
            this.scanErrorMessage = builder.scanErrorMessage;
        }

        @Override
        @JsonProperty(value="collectorsRun")
        public List<CollectorData> getCollectorsRun() {
            return this.collectorsRun;
        }

        @Override
        @JsonProperty(value="unsupportedBuildSystems")
        public List<CollectorData> getUnsupportedBuildSystems() {
            return this.unsupportedBuildSystems;
        }

        @Override
        @JsonProperty(value="scanAttributesJSON")
        public String getScanAttributesJSON() {
            return this.scanAttributesJSON;
        }

        @Override
        @JsonProperty(value="agentType")
        public String getAgentType() {
            return this.agentType;
        }

        @Override
        @JsonProperty(value="agentVersion")
        public String getAgentVersion() {
            return this.agentVersion;
        }

        @Override
        @JsonProperty(value="OS")
        public String getOS() {
            return this.OS;
        }

        @Override
        @JsonProperty(value="OSVersion")
        public String getOSVersion() {
            return this.OSVersion;
        }

        @Override
        @JsonProperty(value="JVMVersion")
        public String getJVMVersion() {
            return this.JVMVersion;
        }

        @Override
        @JsonProperty(value="quickScan")
        public boolean isQuickScan() {
            return this.quickScan;
        }

        @Override
        @JsonProperty(value="recursiveScan")
        public boolean isRecursiveScan() {
            return this.recursiveScan;
        }

        @Override
        @JsonProperty(value="scanTime")
        @Nullable
        public Long getScanTime() {
            return this.scanTime;
        }

        @Override
        @JsonProperty(value="scanErrorMessage")
        @Nullable
        public String getScanErrorMessage() {
            return this.scanErrorMessage;
        }

        @Override
        public AgentRuntimeData.Builder toBuilder() {
            PartialBuilder builder = new PartialBuilder();
            ((AgentRuntimeData_Builder)builder).addAllCollectorsRun((Iterable<? extends CollectorData>)this.collectorsRun);
            ((AgentRuntimeData_Builder)builder).addAllUnsupportedBuildSystems((Iterable<? extends CollectorData>)this.unsupportedBuildSystems);
            ((AgentRuntimeData_Builder)builder).scanAttributesJSON = this.scanAttributesJSON;
            ((AgentRuntimeData_Builder)builder).agentType = this.agentType;
            ((AgentRuntimeData_Builder)builder).agentVersion = this.agentVersion;
            ((AgentRuntimeData_Builder)builder).OS = this.OS;
            ((AgentRuntimeData_Builder)builder).OSVersion = this.OSVersion;
            ((AgentRuntimeData_Builder)builder).JVMVersion = this.JVMVersion;
            ((AgentRuntimeData_Builder)builder).quickScan = this.quickScan;
            ((AgentRuntimeData_Builder)builder).recursiveScan = this.recursiveScan;
            ((AgentRuntimeData_Builder)builder).scanTime = this.scanTime;
            ((AgentRuntimeData_Builder)builder).scanErrorMessage = this.scanErrorMessage;
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals(this.collectorsRun, other.collectorsRun) && Objects.equals(this.unsupportedBuildSystems, other.unsupportedBuildSystems) && Objects.equals(this.scanAttributesJSON, other.scanAttributesJSON) && Objects.equals(this.agentType, other.agentType) && Objects.equals(this.agentVersion, other.agentVersion) && Objects.equals(this.OS, other.OS) && Objects.equals(this.OSVersion, other.OSVersion) && Objects.equals(this.JVMVersion, other.JVMVersion) && this.quickScan == other.quickScan && this.recursiveScan == other.recursiveScan && Objects.equals(this.scanTime, other.scanTime) && Objects.equals(this.scanErrorMessage, other.scanErrorMessage);
        }

        public int hashCode() {
            return Objects.hash(this.collectorsRun, this.unsupportedBuildSystems, this.scanAttributesJSON, this.agentType, this.agentVersion, this.OS, this.OSVersion, this.JVMVersion, this.quickScan, this.recursiveScan, this.scanTime, this.scanErrorMessage);
        }

        public String toString() {
            StringBuilder result = new StringBuilder("partial AgentRuntimeData{collectorsRun=").append(this.collectorsRun).append(", unsupportedBuildSystems=").append(this.unsupportedBuildSystems).append(", scanAttributesJSON=").append(this.scanAttributesJSON).append(", agentType=").append(this.agentType).append(", agentVersion=").append(this.agentVersion).append(", OS=").append(this.OS).append(", OSVersion=").append(this.OSVersion).append(", JVMVersion=").append(this.JVMVersion).append(", quickScan=").append(this.quickScan).append(", recursiveScan=").append(this.recursiveScan);
            if (this.scanTime != null) {
                result.append(", scanTime=").append(this.scanTime);
            }
            if (this.scanErrorMessage != null) {
                result.append(", scanErrorMessage=").append(this.scanErrorMessage);
            }
            return result.append("}").toString();
        }

        private static class PartialBuilder
        extends AgentRuntimeData.Builder {
            private PartialBuilder() {
            }

            @Override
            public AgentRuntimeData build() {
                return this.buildPartial();
            }
        }
    }

    private static final class Value
    extends Rebuildable {
        private final ImmutableList<CollectorData> collectorsRun;
        private final ImmutableList<CollectorData> unsupportedBuildSystems;
        private final String scanAttributesJSON;
        private final String agentType;
        private final String agentVersion;
        private final String OS;
        private final String OSVersion;
        private final String JVMVersion;
        private final boolean quickScan;
        private final boolean recursiveScan;
        @Nullable
        private final Long scanTime;
        @Nullable
        private final String scanErrorMessage;

        private Value(AgentRuntimeData_Builder builder) {
            this.collectorsRun = builder.collectorsRun.build();
            this.unsupportedBuildSystems = builder.unsupportedBuildSystems.build();
            this.scanAttributesJSON = builder.scanAttributesJSON;
            this.agentType = builder.agentType;
            this.agentVersion = builder.agentVersion;
            this.OS = builder.OS;
            this.OSVersion = builder.OSVersion;
            this.JVMVersion = builder.JVMVersion;
            this.quickScan = builder.quickScan;
            this.recursiveScan = builder.recursiveScan;
            this.scanTime = builder.scanTime;
            this.scanErrorMessage = builder.scanErrorMessage;
        }

        @Override
        @JsonProperty(value="collectorsRun")
        public List<CollectorData> getCollectorsRun() {
            return this.collectorsRun;
        }

        @Override
        @JsonProperty(value="unsupportedBuildSystems")
        public List<CollectorData> getUnsupportedBuildSystems() {
            return this.unsupportedBuildSystems;
        }

        @Override
        @JsonProperty(value="scanAttributesJSON")
        public String getScanAttributesJSON() {
            return this.scanAttributesJSON;
        }

        @Override
        @JsonProperty(value="agentType")
        public String getAgentType() {
            return this.agentType;
        }

        @Override
        @JsonProperty(value="agentVersion")
        public String getAgentVersion() {
            return this.agentVersion;
        }

        @Override
        @JsonProperty(value="OS")
        public String getOS() {
            return this.OS;
        }

        @Override
        @JsonProperty(value="OSVersion")
        public String getOSVersion() {
            return this.OSVersion;
        }

        @Override
        @JsonProperty(value="JVMVersion")
        public String getJVMVersion() {
            return this.JVMVersion;
        }

        @Override
        @JsonProperty(value="quickScan")
        public boolean isQuickScan() {
            return this.quickScan;
        }

        @Override
        @JsonProperty(value="recursiveScan")
        public boolean isRecursiveScan() {
            return this.recursiveScan;
        }

        @Override
        @JsonProperty(value="scanTime")
        @Nullable
        public Long getScanTime() {
            return this.scanTime;
        }

        @Override
        @JsonProperty(value="scanErrorMessage")
        @Nullable
        public String getScanErrorMessage() {
            return this.scanErrorMessage;
        }

        @Override
        public AgentRuntimeData.Builder toBuilder() {
            AgentRuntimeData.Builder builder = new AgentRuntimeData.Builder();
            ((AgentRuntimeData_Builder)builder).addAllCollectorsRun((Iterable<? extends CollectorData>)this.collectorsRun);
            ((AgentRuntimeData_Builder)builder).addAllUnsupportedBuildSystems((Iterable<? extends CollectorData>)this.unsupportedBuildSystems);
            ((AgentRuntimeData_Builder)builder).scanAttributesJSON = this.scanAttributesJSON;
            ((AgentRuntimeData_Builder)builder).agentType = this.agentType;
            ((AgentRuntimeData_Builder)builder).agentVersion = this.agentVersion;
            ((AgentRuntimeData_Builder)builder).OS = this.OS;
            ((AgentRuntimeData_Builder)builder).OSVersion = this.OSVersion;
            ((AgentRuntimeData_Builder)builder).JVMVersion = this.JVMVersion;
            ((AgentRuntimeData_Builder)builder).quickScan = this.quickScan;
            ((AgentRuntimeData_Builder)builder).recursiveScan = this.recursiveScan;
            ((AgentRuntimeData_Builder)builder).scanTime = this.scanTime;
            ((AgentRuntimeData_Builder)builder).scanErrorMessage = this.scanErrorMessage;
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals(this.collectorsRun, other.collectorsRun) && Objects.equals(this.unsupportedBuildSystems, other.unsupportedBuildSystems) && Objects.equals(this.scanAttributesJSON, other.scanAttributesJSON) && Objects.equals(this.agentType, other.agentType) && Objects.equals(this.agentVersion, other.agentVersion) && Objects.equals(this.OS, other.OS) && Objects.equals(this.OSVersion, other.OSVersion) && Objects.equals(this.JVMVersion, other.JVMVersion) && this.quickScan == other.quickScan && this.recursiveScan == other.recursiveScan && Objects.equals(this.scanTime, other.scanTime) && Objects.equals(this.scanErrorMessage, other.scanErrorMessage);
        }

        public int hashCode() {
            return Objects.hash(this.collectorsRun, this.unsupportedBuildSystems, this.scanAttributesJSON, this.agentType, this.agentVersion, this.OS, this.OSVersion, this.JVMVersion, this.quickScan, this.recursiveScan, this.scanTime, this.scanErrorMessage);
        }

        public String toString() {
            StringBuilder result = new StringBuilder("AgentRuntimeData{collectorsRun=").append(this.collectorsRun).append(", unsupportedBuildSystems=").append(this.unsupportedBuildSystems).append(", scanAttributesJSON=").append(this.scanAttributesJSON).append(", agentType=").append(this.agentType).append(", agentVersion=").append(this.agentVersion).append(", OS=").append(this.OS).append(", OSVersion=").append(this.OSVersion).append(", JVMVersion=").append(this.JVMVersion).append(", quickScan=").append(this.quickScan).append(", recursiveScan=").append(this.recursiveScan);
            if (this.scanTime != null) {
                result.append(", scanTime=").append(this.scanTime);
            }
            if (this.scanErrorMessage != null) {
                result.append(", scanErrorMessage=").append(this.scanErrorMessage);
            }
            return result.append("}").toString();
        }
    }

    private static abstract class Rebuildable
    implements AgentRuntimeData {
        private Rebuildable() {
        }

        public abstract AgentRuntimeData.Builder toBuilder();
    }
}

