/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.analysis.utils;

import com.google.common.io.ByteStreams;
import com.sourceclear.analysis.utils.JarStreamConsumer;
import com.sourceclear.analysis.utils.PeFileType;
import com.sourceclear.analysis.utils.PeFileTypeDetector;
import com.sourceclear.analysis.utils.TempDirectory;
import com.sourceclear.methods.MethodDefinition;
import com.veracode.security.logging.SecureLogger;
import com.zaxxer.sparsebits.SparseBitSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import javax.annotation.Nonnull;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassReader;

public class Utils {
    private static final SecureLogger LOGGER = SecureLogger.getLogger(Utils.class);
    private static final Path DATA_ARCHIVE = Paths.get("data.tar.gz", new String[0]);
    private static final CompressorStreamFactory COMP_STREAM_FACTORY = new CompressorStreamFactory();
    private static final ArchiveStreamFactory ARCHIVE_STREAM_FACTORY = new ArchiveStreamFactory();
    private static final PathMatcher DIST_INFO_MATCHER = FileSystems.getDefault().getPathMatcher("glob:*.dist-info");
    static final PathMatcher DLL_MATCHER = FileSystems.getDefault().getPathMatcher("glob:**/*.{dll}");

    public static String stripReturnType(String descriptor) {
        return descriptor.split("\\)")[0] + ")";
    }

    public static EnumSet<MethodDefinition.Attribute> attributesFromAccess(int access) {
        EnumSet<MethodDefinition.Attribute> attributes = EnumSet.noneOf(MethodDefinition.Attribute.class);
        if ((access & 0x1000) == 4096) {
            attributes.add(MethodDefinition.Attribute.SYNTHETIC);
        } else if ((access & 0x400) == 1024) {
            attributes.add(MethodDefinition.Attribute.ABSTRACT);
        }
        return attributes;
    }

    public static SparseBitSet setDifference(@NotNull SparseBitSet a, @NotNull SparseBitSet b) {
        Objects.requireNonNull(a, "BitSet[a] must not be null");
        Objects.requireNonNull(b, "BitSet[b] must not be null");
        int nbits = Math.max(a.length(), b.length());
        if (nbits == 0) {
            return new SparseBitSet();
        }
        SparseBitSet result = new SparseBitSet(nbits);
        result.or(a);
        result.andNot(b);
        return result;
    }

    public static String classNameToInternalName(String className) {
        return className.replaceAll(Pattern.quote("."), "/");
    }

    public static boolean is(int value, int flag) {
        return (value & flag) != 0;
    }

    public static List<ClassReader> classReaders(JarFile jar) {
        Function<JarEntry, Optional> getIS = jarEntry -> {
            try {
                return Optional.ofNullable(jar.getInputStream((ZipEntry)jarEntry));
            }
            catch (IOException e) {
                return Optional.empty();
            }
        };
        Function<Optional, Optional> newOptionalCR = is -> is.map(inputStream -> {
            try {
                return new ClassReader(inputStream);
            }
            catch (IOException e) {
                return null;
            }
        });
        return jar.stream().filter(jarEntry -> !Utils.isInvalidEntry(jarEntry)).map(getIS).map(newOptionalCR).filter(Optional::isPresent).map(Optional::get).distinct().filter(classReader -> Utils.getOptionalClassName(classReader).isPresent()).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readEntries(JarInputStream jar, JarStreamConsumer consumer) throws IOException {
        HashSet<String> classes = new HashSet<String>();
        try (JarInputStream jis = jar;){
            JarEntry jarEntry;
            while ((jarEntry = jis.getNextJarEntry()) != null) {
                if (Utils.isInvalidEntry(jarEntry)) {
                    jis.closeEntry();
                    continue;
                }
                ClassReader classReader = null;
                try {
                    classReader = new ClassReader((InputStream)jis);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (classReader == null || Utils.isInvalidClass(classReader, classes)) {
                    jis.closeEntry();
                    continue;
                }
                classes.add(classReader.getClassName());
                try {
                    Optional<IOException> maybeThrow = consumer.apply(classReader);
                    if (!maybeThrow.isPresent()) continue;
                    throw maybeThrow.get();
                }
                finally {
                    jis.closeEntry();
                }
            }
        }
    }

    private static boolean isInvalidEntry(JarEntry jarEntry) {
        String entryName = jarEntry.getName();
        boolean notClass = jarEntry.isDirectory() || !entryName.endsWith(".class");
        boolean ignored = entryName.equals("module-info.class");
        return notClass || ignored;
    }

    private static Optional<String> getOptionalClassName(@Nonnull ClassReader classReader) {
        String className;
        try {
            className = classReader.getClassName();
        }
        catch (Exception ex) {
            return Optional.empty();
        }
        return Optional.ofNullable(className);
    }

    private static boolean isInvalidClass(@NotNull ClassReader classReader, Set<String> classes) {
        Optional<String> optionalClassName = Utils.getOptionalClassName(classReader);
        return !optionalClassName.isPresent() || classes.contains(optionalClassName.get());
    }

    /*
     * Exception decompiling
     */
    public static <T> T processPythonArchive(InputStream archiveStream, CheckedFunction<Path, T, IOException> action) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static <T> T processRubyGemsArchive(InputStream archiveStream, CheckedFunction<Path, T, IOException> action) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static Path lookForDataTarAndUnarchive(Path gemDir) throws IOException {
        Path dataDir = Files.createDirectories(gemDir.resolve("data"), new FileAttribute[0]);
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(gemDir);){
            for (Path path : paths) {
                if (!path.equals(gemDir.resolve(DATA_ARCHIVE))) continue;
                try {
                    InputStream dataStream = Files.newInputStream(path, new OpenOption[0]);
                    try {
                        CompressorInputStream compressorInputStream = COMP_STREAM_FACTORY.createCompressorInputStream("gz", dataStream);
                        try {
                            ArchiveInputStream dataArchive = ARCHIVE_STREAM_FACTORY.createArchiveInputStream("tar", (InputStream)compressorInputStream);
                            try {
                                Utils.unarchiveIntoDirectory(dataArchive, dataDir);
                            }
                            finally {
                                if (dataArchive == null) continue;
                                dataArchive.close();
                            }
                        }
                        finally {
                            if (compressorInputStream == null) continue;
                            compressorInputStream.close();
                        }
                    }
                    finally {
                        if (dataStream == null) continue;
                        dataStream.close();
                    }
                }
                catch (ArchiveException | CompressorException e) {
                    throw new IOException("Unable to uncompress gem's data.tar.gz", e);
                    return dataDir;
                }
            }
        }
    }

    public static <T> T readDlls(InputStream nupkgStream, CheckedFunction<Collection<Path>, T, IOException> f) throws IOException {
        try (TempDirectory tempDirectory = new TempDirectory("process-nupkg");){
            T t;
            try (ZipArchiveInputStream zipInputStream = new ZipArchiveInputStream(nupkgStream);){
                Utils.unarchiveIntoDirectory((ArchiveInputStream)zipInputStream, tempDirectory.path);
                t = f.apply(Files.walk(tempDirectory.path, new FileVisitOption[0]).filter(DLL_MATCHER::matches).filter(Utils::isManagedDll).collect(Collectors.toSet()));
            }
            return t;
        }
    }

    public static String hashObjects(Collection<? extends Serializable> objects) throws IOException {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             ObjectOutputStream out = new ObjectOutputStream(bos);){
            out.writeObject(objects);
            result.add(bos.toByteArray());
        }
        return Utils.hashBytes(result);
    }

    @SafeVarargs
    public static <T extends Serializable> String hashObjects(T ... os) throws IOException {
        return Utils.hashObjects(Arrays.asList(os));
    }

    private static String hashBytes(Collection<byte[]> collection) {
        MessageDigest digest = DigestUtils.getSha256Digest();
        for (byte[] b : collection) {
            digest.update(b);
        }
        return Hex.encodeHexString((byte[])digest.digest());
    }

    public static byte[] toByteArray(InputStream in) throws IOException {
        try (InputStream input = in;){
            byte[] byArray = ByteStreams.toByteArray((InputStream)input);
            return byArray;
        }
    }

    public static InputStream fromByteArray(byte[] bytes) {
        return new ByteArrayInputStream(bytes);
    }

    public static String getStackTrace() {
        StackTraceElement[] elements;
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement element : elements = Thread.currentThread().getStackTrace()) {
            sb.append(String.format("at %s.%s(%s:%d)\n", element.getClassName(), element.getMethodName(), element.getFileName(), element.getLineNumber()));
        }
        return sb.toString();
    }

    public static void unarchiveIntoDirectory(ArchiveInputStream archiveInputStream, Path directory) throws IOException {
        ArchiveEntry entry;
        while ((entry = archiveInputStream.getNextEntry()) != null) {
            Path entryPath;
            try {
                entryPath = directory.resolve(entry.getName());
            }
            catch (InvalidPathException e) {
                LOGGER.info("Skipping unarchiving of archive entry {} due to an error resolving its path.", (Object)entry.getName(), (Object)e);
                continue;
            }
            if (!entryPath.normalize().startsWith(directory)) {
                throw new IllegalArgumentException(String.format("Bad zip entry: %s", entry.getName()));
            }
            if (!Files.exists(entryPath.getParent(), new LinkOption[0])) {
                Files.createDirectories(entryPath.getParent(), new FileAttribute[0]);
            }
            if (entry.getName().endsWith("/") || Files.exists(entryPath, new LinkOption[0])) continue;
            Files.copy((InputStream)archiveInputStream, entryPath, new CopyOption[0]);
        }
    }

    static boolean containsDistInfo(Path directory) throws IOException {
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(directory);){
            for (Path path : paths) {
                if (!DIST_INFO_MATCHER.matches(path.getFileName())) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    static boolean isManagedDll(Path path) {
        try {
            return PeFileTypeDetector.detectFileType(path).filter(t -> t == PeFileType.ManagedPe).isPresent();
        }
        catch (IOException e) {
            return false;
        }
    }

    private Utils() {
    }

    public static interface CheckedFunction<A, B, E extends Throwable> {
        public B apply(A var1) throws E;
    }
}

