/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.analysis.latte.staticCG;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003H\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00102\u0006\u0010\u000e\u001a\u00020\u0003H\u0002J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/sourceclear/analysis/latte/staticCG/RequiresResolver;", "", "projectRoot", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "assertPathInProject", "", "path", "loadAsDirectory", "name", "loadAsFile", "loadIndex", "loadNodeModules", "", "start", "nodeModulePaths", "", "resolveRequire", "sourceFile", "Companion", "vulnerable-methods"})
public final class RequiresResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path projectRoot;
    @NotNull
    private static final Set<String> CORE_MODULES;

    public RequiresResolver(@NotNull Path projectRoot) {
        Intrinsics.checkNotNullParameter((Object)projectRoot, (String)"projectRoot");
        this.projectRoot = projectRoot;
    }

    @Nullable
    public final String resolveRequire(@NotNull String name, @NotNull Path sourceFile) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        if (CORE_MODULES.contains(name)) {
            return name;
        }
        Path asbStart = sourceFile.toAbsolutePath();
        if (StringsKt.startsWith$default((String)name, (String)"./", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"../", (boolean)false, (int)2, null)) {
            Path path = asbStart.getParent().resolve(name);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"asbStart.parent.resolve(name)");
            Path path2 = this.loadAsFile(path);
            if (path2 == null) {
                path = asbStart.getParent().resolve(name);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"asbStart.parent.resolve(name)");
                path2 = this.loadAsDirectory(path);
            }
            return path2 == null ? null : ((Object)path2).toString();
        }
        Path path = asbStart.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"asbStart.parent");
        Path path3 = this.loadNodeModules(name, path);
        return (path3 == null ? (Comparable)((Object)name) : (Comparable)path3).toString();
    }

    private final Path loadNodeModules(String name, Path start) {
        List<Path> dirs = this.nodeModulePaths(start);
        for (Path dir : dirs) {
            Path found;
            Path path = dir.resolve(name);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"dir.resolve(name)");
            Path path2 = this.loadAsFile(path);
            if (path2 == null) {
                path = dir.resolve(name);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"dir.resolve(name)");
                path2 = this.loadAsDirectory(path);
            }
            if ((found = path2) == null) continue;
            return found;
        }
        return null;
    }

    private final List<Path> nodeModulePaths(Path start) {
        List dirs = new ArrayList();
        for (Path current = start; current != null; current = current.getParent()) {
            Path path = current.getFileName();
            if (Intrinsics.areEqual((Object)(path == null ? null : ((Object)path).toString()), (Object)"node_modules")) continue;
            Path dir = current.resolve("node_modules");
            Intrinsics.checkNotNullExpressionValue((Object)dir, (String)"dir");
            dirs.add(dir);
        }
        return dirs;
    }

    private final Path loadAsDirectory(Path name) {
        Path path;
        if (Files.exists(name.resolve("package.json"), new LinkOption[0])) {
            String string;
            String mainFile;
            ObjectMapper mapper = new ObjectMapper();
            Map json = (Map)mapper.readValue(name.resolve("package.json").toFile(), Map.class);
            Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
            Object v = json.get("main");
            String string2 = v == null ? null : (mainFile = (string = v.toString()) == null ? null : ((Object)StringsKt.trim((CharSequence)string)).toString());
            if (mainFile != null && !StringsKt.isBlank((CharSequence)mainFile) && Files.exists(name.resolve(mainFile), new LinkOption[0])) {
                Path path2 = name.resolve(mainFile);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"name.resolve(mainFile)");
                path = this.loadAsFile(path2);
            } else {
                path = this.loadIndex(name);
            }
        } else {
            path = this.loadIndex(name);
        }
        return path;
    }

    private final Path loadIndex(Path name) {
        return Files.exists(name.resolve("index.js"), new LinkOption[0]) ? name.resolve("index.js").toAbsolutePath().normalize() : (Files.exists(name.resolve("index.json"), new LinkOption[0]) ? name.resolve("index.json").toAbsolutePath().normalize() : (Files.exists(name.resolve("index.node"), new LinkOption[0]) ? name.resolve("index.node").toAbsolutePath().normalize() : (Path)null));
    }

    private final Path loadAsFile(Path name) {
        Path path;
        Path withJsExtension;
        Path result;
        Path path2 = result = Files.exists(name, new LinkOption[0]) && Files.isRegularFile(name, new LinkOption[0]) ? name.toAbsolutePath().normalize() : (Files.exists(withJsExtension = Paths.get(name + ".js", new String[0]), new LinkOption[0]) && Files.isRegularFile(withJsExtension, new LinkOption[0]) ? withJsExtension.normalize() : this.loadIndex(name));
        if (path2 == null) {
            path = null;
        } else {
            Path path3;
            Path it = path3 = path2;
            boolean bl = false;
            this.assertPathInProject(it);
            path = path3;
        }
        return path;
    }

    private final void assertPathInProject(Path path) {
        if (!path.toRealPath(new LinkOption[0]).startsWith(this.projectRoot.toRealPath(new LinkOption[0]))) {
            throw new IllegalAccessException("Potential directory traversal attempt detected." + path + " is a path outside of the project root.");
        }
    }

    static {
        Object[] objectArray = new String[]{"async_hooks", "assert", "buffer", "child_process", "console", "constants", "crypto", "cluster", "dgram", "dns", "domain", "events", "fs", "http", "http2", "_http_agent", "_http_client", "_http_common", "_http_incoming", "_http_outgoing", "_http_server", "https", "inspector", "module", "net", "os", "path", "perf_hooks", "process", "punycode", "querystring", "readline", "repl", "stream", "_stream_readable", "_stream_writable", "_stream_duplex", "_stream_transform", "_stream_passthrough", "_stream_wrap", "string_decoder", "sys", "timers", "tls", "_tls_common", "_tls_legacy", "_tls_wrap", "tty", "url", "util", "v8", "vm", "zlib", "v8/tools/splaytree", "v8/tools/codemap", "v8/tools/consarray", "v8/tools/csvparser", "v8/tools/profile", "v8/tools/profile_view", "v8/tools/logreader", "v8/tools/tickprocessor", "v8/tools/SourceMap", "v8/tools/tickprocessor-driver", "node-inspect/lib/_inspect", "node-inspect/lib/internal/inspect_client", "node-inspect/lib/internal/inspect_repl"};
        CORE_MODULES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/sourceclear/analysis/latte/staticCG/RequiresResolver$Companion;", "", "()V", "CORE_MODULES", "", "", "vulnerable-methods"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

