/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.schema.CycleChecker;
import com.squareup.wire.schema.EnumConstant;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.ErrorCollector;
import com.squareup.wire.schema.Extend;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.FileLinker;
import com.squareup.wire.schema.Loader;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Reserved;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.SyntaxRules;
import com.squareup.wire.schema.Type;
import com.squareup.wire.schema.internal.UtilJVMKt;
import com.squareup.wire.schema.internal.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tB\u0017\b\u0012\u0012\u0006\u0010\n\u001a\u00020\u0000\u0012\u0006\u0010\u000b\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\fJ\u0016\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020\u001bJ\u0013\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00140\u000eH\u0000\u00a2\u0006\u0002\b&J\u0018\u0010'\u001a\u0004\u0018\u00010\u001e2\u0006\u0010#\u001a\u00020 2\u0006\u0010(\u001a\u00020\u0013J\u0010\u0010)\u001a\u0004\u0018\u00010\u001b2\u0006\u0010#\u001a\u00020 J\u0015\u0010*\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b,J\u0010\u0010-\u001a\u0004\u0018\u00010\u001b2\u0006\u0010#\u001a\u00020 J\u0014\u0010.\u001a\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020201J\u000e\u00103\u001a\u00020\"2\u0006\u0010(\u001a\u00020\u001eJ/\u00104\u001a\u0004\u0018\u0001H5\"\u0004\b\u0000\u001052\u0006\u00106\u001a\u00020\u00132\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u0002H508\u00a2\u0006\u0002\u00109J\u0006\u0010:\u001a\u00020\u0013J\u000e\u0010;\u001a\u00020 2\u0006\u00106\u001a\u00020\u0013J\u000e\u0010<\u001a\u00020 2\u0006\u00106\u001a\u00020\u0013J\u0018\u0010<\u001a\u00020 2\u0006\u00106\u001a\u00020\u00132\u0006\u0010=\u001a\u00020\u0007H\u0002J\u0014\u0010>\u001a\u00020\"2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u001b01J*\u0010@\u001a\u00020\"2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u001e012\f\u0010B\u001a\b\u0012\u0004\u0012\u00020C0\u000e2\u0006\u0010D\u001a\u00020EJ\u0016\u0010F\u001a\u00020\"2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020\u0013J\u0016\u0010J\u001a\u00020\"2\u0006\u0010G\u001a\u00020H2\u0006\u0010$\u001a\u00020 J\b\u0010K\u001a\u00020\"H\u0002J\u000e\u0010L\u001a\u00020\u00002\u0006\u0010M\u001a\u00020\u0001R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0016j\b\u0012\u0004\u0012\u00020\u0014`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lcom/squareup/wire/schema/Linker;", "", "loader", "Lcom/squareup/wire/schema/Loader;", "errors", "Lcom/squareup/wire/schema/ErrorCollector;", "permitPackageCycles", "", "loadExhaustively", "(Lcom/squareup/wire/schema/Loader;Lcom/squareup/wire/schema/ErrorCollector;ZZ)V", "enclosing", "additionalContext", "(Lcom/squareup/wire/schema/Linker;Ljava/lang/Object;)V", "contextStack", "", "getErrors", "()Lcom/squareup/wire/schema/ErrorCollector;", "fileLinkers", "", "", "Lcom/squareup/wire/schema/FileLinker;", "fileOptionsQueue", "Ljava/util/Queue;", "Lcom/squareup/wire/schema/internal/MutableQueue;", "getLoadExhaustively", "()Z", "protoTypeNames", "Lcom/squareup/wire/schema/Type;", "requestedFields", "", "Lcom/squareup/wire/schema/Field;", "requestedTypes", "Lcom/squareup/wire/schema/ProtoType;", "addType", "", "protoType", "type", "contextImportedTypes", "contextImportedTypes$wire_schema", "dereference", "field", "get", "getFileLinker", "path", "getFileLinker$wire_schema", "getForOptions", "link", "Lcom/squareup/wire/schema/Schema;", "sourceProtoFiles", "", "Lcom/squareup/wire/schema/ProtoFile;", "request", "resolve", "T", "name", "map", "", "(Ljava/lang/String;Ljava/util/Map;)Ljava/lang/Object;", "resolveContext", "resolveMessageType", "resolveType", "messageOnly", "validateEnumConstantNameUniqueness", "nestedTypes", "validateFields", "fields", "reserveds", "Lcom/squareup/wire/schema/Reserved;", "syntaxRules", "Lcom/squareup/wire/schema/SyntaxRules;", "validateImportForPath", "location", "Lcom/squareup/wire/schema/Location;", "requiredImport", "validateImportForType", "validatePackages", "withContext", "context", "wire-schema"})
public final class Linker {
    @NotNull
    private final Loader loader;
    @NotNull
    private final Map<String, FileLinker> fileLinkers;
    @NotNull
    private final Queue<FileLinker> fileOptionsQueue;
    @NotNull
    private final Map<String, Type> protoTypeNames;
    @NotNull
    private final List<Object> contextStack;
    @NotNull
    private final Set<ProtoType> requestedTypes;
    @NotNull
    private final Set<Field> requestedFields;
    private final boolean permitPackageCycles;
    private final boolean loadExhaustively;
    @NotNull
    private final ErrorCollector errors;

    public final boolean getLoadExhaustively() {
        return this.loadExhaustively;
    }

    @NotNull
    public final ErrorCollector getErrors() {
        return this.errors;
    }

    public Linker(@NotNull Loader loader, @NotNull ErrorCollector errors, boolean permitPackageCycles, boolean loadExhaustively) {
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        Intrinsics.checkNotNullParameter((Object)errors, (String)"errors");
        this.loader = loader;
        this.fileLinkers = new LinkedHashMap();
        this.fileOptionsQueue = UtilJVMKt.mutableQueueOf();
        this.protoTypeNames = new LinkedHashMap();
        this.contextStack = CollectionsKt.emptyList();
        this.requestedTypes = new LinkedHashSet();
        this.requestedFields = new LinkedHashSet();
        this.errors = errors;
        this.permitPackageCycles = permitPackageCycles;
        this.loadExhaustively = loadExhaustively;
    }

    private Linker(Linker enclosing, Object additionalContext) {
        this.loader = enclosing.loader;
        this.fileLinkers = enclosing.fileLinkers;
        this.fileOptionsQueue = enclosing.fileOptionsQueue;
        this.protoTypeNames = enclosing.protoTypeNames;
        this.contextStack = CollectionsKt.plus((Collection)enclosing.contextStack, (Object)additionalContext);
        this.requestedTypes = enclosing.requestedTypes;
        this.requestedFields = enclosing.requestedFields;
        this.errors = enclosing.errors.at(additionalContext);
        this.permitPackageCycles = false;
        this.loadExhaustively = enclosing.loadExhaustively;
    }

    @NotNull
    public final FileLinker getFileLinker$wire_schema(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        FileLinker existing = this.fileLinkers.get(path);
        if (existing != null) {
            return existing;
        }
        ProtoFile protoFile = this.loader.withErrors(this.errors).load(path);
        FileLinker result = new FileLinker(protoFile, this.withContext(protoFile));
        this.fileLinkers.put(path, result);
        ((Collection)this.fileOptionsQueue).add(result);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Schema link(@NotNull Iterable<ProtoFile> sourceProtoFiles) {
        SyntaxRules syntaxRules;
        Iterator fileLinker;
        Intrinsics.checkNotNullParameter(sourceProtoFiles, (String)"sourceProtoFiles");
        List sourceFiles = new ArrayList();
        Collection collection = sourceFiles;
        FileLinker fileLinker2 = this.getFileLinker$wire_schema("google/protobuf/descriptor.proto");
        collection.add(fileLinker2);
        for (ProtoFile protoFile : sourceProtoFiles) {
            fileLinker = new FileLinker(protoFile, this.withContext(protoFile));
            Map<String, FileLinker> map = this.fileLinkers;
            String string = protoFile.getLocation().getPath();
            map.put(string, (FileLinker)((Object)fileLinker));
            ((Collection)sourceFiles).add(fileLinker);
        }
        if (this.loadExhaustively) {
            Iterator queue = UtilJVMKt.mutableQueueOf();
            Collection collection2 = (Collection)((Object)queue);
            fileLinker = this.fileLinkers.values();
            CollectionsKt.addAll((Collection)collection2, (Iterable)((Object)fileLinker));
            while ((FileLinker)queue.poll() != null) {
                FileLinker fileLinker3;
                for (String importPath : CollectionsKt.plus((Collection)fileLinker3.getProtoFile().getImports(), (Iterable)fileLinker3.getProtoFile().getPublicImports())) {
                    if (this.fileLinkers.containsKey(importPath)) continue;
                    FileLinker imported = this.withContext(fileLinker3.getProtoFile()).getFileLinker$wire_schema(importPath);
                    ((Collection)sourceFiles).add(imported);
                    ((Collection)((Object)queue)).add(imported);
                }
            }
        }
        for (FileLinker fileLinker4 : sourceFiles) {
            fileLinker4.requireTypesRegistered();
        }
        for (FileLinker fileLinker5 : sourceFiles) {
            fileLinker5.requireExtensionsLinked();
        }
        for (FileLinker fileLinker6 : sourceFiles) {
            fileLinker6.requireImportedExtensionsRegistered();
        }
        for (FileLinker fileLinker7 : sourceFiles) {
            fileLinker7.linkMembers();
        }
        for (FileLinker fileLinker8 : sourceFiles) {
            syntaxRules = SyntaxRules.Companion.get(fileLinker8.getProtoFile().getSyntax());
            fileLinker8.linkOptions(syntaxRules, true);
        }
        for (FileLinker fileLinker9 : sourceFiles) {
            fileLinker9.requireImportedExtensionOptionsLinked(false);
        }
        while (!((Collection)this.fileOptionsQueue).isEmpty()) {
            Object fileLinker4;
            Intrinsics.checkNotNull((Object)this.fileOptionsQueue.poll());
            ((FileLinker)fileLinker4).requireFileOptionsLinked(false);
        }
        this.validatePackages();
        for (FileLinker fileLinker10 : sourceFiles) {
            syntaxRules = SyntaxRules.Companion.get(fileLinker10.getProtoFile().getSyntax());
            fileLinker10.validate(syntaxRules);
        }
        CycleChecker cycleChecker = new CycleChecker(this.fileLinkers, this.errors);
        cycleChecker.checkForImportCycles();
        if (!this.permitPackageCycles) {
            cycleChecker.checkForPackageCycles();
        }
        this.errors.throwIfNonEmpty();
        List list = new ArrayList();
        for (FileLinker fileLinker5 : this.fileLinkers.values()) {
            boolean anyFieldIsUsed;
            boolean anyTypeIsUsed;
            block26: {
                boolean bl;
                void $this$any$iv;
                boolean bl2;
                block24: {
                    void $this$any$iv2;
                    if (sourceFiles.contains(fileLinker5)) {
                        list.add(fileLinker5.getProtoFile());
                        continue;
                    }
                    Iterable iterable = fileLinker5.getProtoFile().typesAndNestedTypes();
                    boolean $i$f$any = false;
                    if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv2) {
                            Type type = (Type)element$iv;
                            boolean bl3 = false;
                            if (!this.requestedTypes.contains(type.getType())) continue;
                            bl2 = true;
                            break block24;
                        }
                        bl2 = false;
                    }
                }
                anyTypeIsUsed = bl2;
                Iterable $i$f$any = fileLinker5.getProtoFile().getExtendList();
                boolean $i$f$any2 = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        boolean bl3;
                        block25: {
                            Extend extend = (Extend)element$iv;
                            boolean bl5 = false;
                            Iterable $this$any$iv3 = extend.getFields();
                            boolean $i$f$any3 = false;
                            if ($this$any$iv3 instanceof Collection && ((Collection)$this$any$iv3).isEmpty()) {
                                bl3 = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv3) {
                                    Field it = (Field)element$iv2;
                                    boolean bl6 = false;
                                    if (!this.requestedFields.contains(it)) continue;
                                    bl3 = true;
                                    break block25;
                                }
                                bl3 = false;
                            }
                        }
                        if (!bl3) continue;
                        bl = true;
                        break block26;
                    }
                    bl = anyFieldIsUsed = false;
                }
            }
            if (!anyTypeIsUsed && !anyFieldIsUsed) continue;
            list.add(fileLinker5.getProtoFile().retainLinked(CollectionsKt.toSet((Iterable)this.requestedTypes), this.requestedFields));
        }
        return new Schema(list);
    }

    @NotNull
    public final ProtoType resolveType(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.resolveType(name, false);
    }

    @NotNull
    public final ProtoType resolveMessageType(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.resolveType(name, true);
    }

    private final ProtoType resolveType(String name, boolean messageOnly) {
        ProtoType type = ProtoType.Companion.get(name);
        if (type.isScalar()) {
            if (messageOnly) {
                this.errors.plusAssign(Intrinsics.stringPlus((String)"expected a message but was ", (Object)name));
            }
            return type;
        }
        if (type.isMap()) {
            if (messageOnly) {
                this.errors.plusAssign(Intrinsics.stringPlus((String)"expected a message but was ", (Object)name));
            }
            ProtoType keyType = this.resolveType(String.valueOf(type.getKeyType()), false);
            ProtoType valueType = this.resolveType(String.valueOf(type.getValueType()), false);
            return ProtoType.Companion.get(keyType, valueType, name);
        }
        Type resolved = this.resolve(name, this.protoTypeNames);
        if (resolved == null) {
            for (FileLinker fileLinker : this.contextImportedTypes$wire_schema()) {
                fileLinker.requireTypesRegistered();
            }
            resolved = this.resolve(name, this.protoTypeNames);
        }
        if (resolved == null) {
            this.errors.plusAssign(Intrinsics.stringPlus((String)"unable to resolve ", (Object)name));
            return ProtoType.BYTES;
        }
        if (messageOnly && !(resolved instanceof MessageType)) {
            this.errors.plusAssign(Intrinsics.stringPlus((String)"expected a message but was ", (Object)name));
            return ProtoType.BYTES;
        }
        this.requestedTypes.add(resolved.getType());
        return resolved.getType();
    }

    @Nullable
    public final <T> T resolve(@NotNull String name, @NotNull Map<String, ? extends T> map) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(map, (String)"map");
        if (StringsKt.startsWith$default((String)name, (String)".", (boolean)false, (int)2, null)) {
            String string = name;
            int n = 1;
            String string2 = string.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            T result = map.get(string2);
            if (result != null) {
                return result;
            }
        } else {
            T result;
            String prefix = this.resolveContext();
            while (((CharSequence)prefix).length() > 0) {
                String string;
                result = map.get(prefix + '.' + name);
                if (result != null) {
                    return result;
                }
                int dot = StringsKt.lastIndexOf$default((CharSequence)prefix, (char)'.', (int)0, (boolean)false, (int)6, null);
                if (dot != -1) {
                    String string3 = prefix;
                    int n = 0;
                    String string4 = string3.substring(n, dot);
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                } else {
                    string = "";
                }
                prefix = string;
            }
            result = map.get(name);
            if (result != null) {
                return result;
            }
        }
        return null;
    }

    @NotNull
    public final String resolveContext() {
        int n = this.contextStack.size() + -1;
        if (0 <= n) {
            do {
                int i;
                Object context;
                if ((context = this.contextStack.get(i = n--)) instanceof Type) {
                    return ((Type)context).getType().toString();
                }
                if (!(context instanceof ProtoFile)) continue;
                String packageName = ((ProtoFile)context).getPackageName();
                String string = packageName;
                if (string == null) {
                    string = "";
                }
                return string;
            } while (0 <= n);
        }
        throw new IllegalStateException();
    }

    @NotNull
    public final List<FileLinker> contextImportedTypes$wire_schema() {
        List result = new ArrayList();
        int n = this.contextStack.size() + -1;
        if (0 <= n) {
            do {
                Location location;
                int i = n--;
                Object context = this.contextStack.get(i);
                Location location2 = context instanceof ProtoFile ? ((ProtoFile)context).getLocation() : (location = context instanceof Field && ((Field)context).isExtension() ? ((Field)context).getLocation() : null);
                if (location == null) continue;
                String path = location.getPath();
                FileLinker fileLinker = this.getFileLinker$wire_schema(path);
                for (String effectiveImport : fileLinker.effectiveImports()) {
                    result.add(this.getFileLinker$wire_schema(effectiveImport));
                }
            } while (0 <= n);
        }
        return result;
    }

    public final void addType(@NotNull ProtoType protoType, @NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)protoType, (String)"protoType");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Map<String, Type> map = this.protoTypeNames;
        String string = protoType.toString();
        map.put(string, type);
    }

    @Nullable
    public final Type get(@NotNull ProtoType protoType) {
        Intrinsics.checkNotNullParameter((Object)protoType, (String)"protoType");
        Type result = this.protoTypeNames.get(protoType.toString());
        if (result == null) {
            for (FileLinker fileLinker : this.contextImportedTypes$wire_schema()) {
                fileLinker.requireTypesRegistered();
            }
            result = this.protoTypeNames.get(protoType.toString());
        }
        if (result != null) {
            this.requestedTypes.add(protoType);
        }
        return result;
    }

    @Nullable
    public final Type getForOptions(@NotNull ProtoType protoType) {
        Intrinsics.checkNotNullParameter((Object)protoType, (String)"protoType");
        Type type = this.get(protoType);
        if (type == null) {
            return null;
        }
        Type result = type;
        FileLinker fileLinker = this.getFileLinker$wire_schema(result.getLocation().getPath());
        fileLinker.requireMembersLinked(result);
        return result;
    }

    public final void request(@NotNull Field field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        this.requestedFields.add(field);
    }

    @Nullable
    public final Field dereference(@NotNull ProtoType protoType, @NotNull String field) {
        Type type;
        Intrinsics.checkNotNullParameter((Object)protoType, (String)"protoType");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        String field2 = field;
        if (StringsKt.startsWith$default((String)field2, (String)"[", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)field2, (String)"]", (boolean)false, (int)2, null)) {
            String string = field2.substring(1, field2.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            field2 = string;
        }
        if ((type = this.getForOptions(protoType)) instanceof MessageType) {
            Field messageField = ((MessageType)type).field(field2);
            if (messageField != null) {
                return messageField;
            }
            Map<String, Field> typeExtensions = ((MessageType)type).extensionFieldsMap();
            Field extensionField = this.resolve(field2, typeExtensions);
            if (extensionField != null) {
                return extensionField;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final void validateFields(@NotNull Iterable<Field> fields, @NotNull List<Reserved> reserveds, @NotNull SyntaxRules syntaxRules) {
        Field field;
        boolean bl;
        int n;
        Object item$iv;
        Iterator iterator;
        StringBuilder error;
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        Intrinsics.checkNotNullParameter(reserveds, (String)"reserveds");
        Intrinsics.checkNotNullParameter((Object)syntaxRules, (String)"syntaxRules");
        LinkedHashMap tagToField = new LinkedHashMap();
        LinkedHashMap nameToField = new LinkedHashMap();
        LinkedHashMap jsonNameToField = new LinkedHashMap();
        for (Field iterator2 : fields) {
            Object object;
            Object object2;
            Set answer$iv;
            Map $this$getOrPut$iv;
            int tag = iterator2.getTag();
            if (!UtilKt.isValidTag(tag)) {
                this.errors.at(iterator2).plusAssign(Intrinsics.stringPlus((String)"tag is out of range: ", (Object)tag));
            }
            for (Reserved reserved : reserveds) {
                if (reserved.matchesTag(tag)) {
                    this.errors.at(iterator2).plusAssign("tag " + tag + " is reserved (" + reserved.getLocation() + ')');
                }
                if (!reserved.matchesName(iterator2.getName())) continue;
                this.errors.at(iterator2).plusAssign("name '" + iterator2.getName() + "' is reserved (" + reserved.getLocation() + ')');
            }
            Map map = tagToField;
            Object key$iv = tag;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            ((Set)object2).add(iterator2);
            $this$getOrPut$iv = nameToField;
            key$iv = iterator2.getQualifiedName();
            $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl3 = false;
                answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((Set)object).add(iterator2);
            if (!iterator2.isExtension()) {
                Object object3;
                $this$getOrPut$iv = jsonNameToField;
                key$iv = syntaxRules.jsonName(iterator2.getName(), iterator2.getDeclaredJsonName());
                $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl4 = false;
                    answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object3 = answer$iv;
                } else {
                    object3 = value$iv;
                }
                ((Set)object3).add(iterator2);
            }
            ProtoType protoType = iterator2.getType();
            Intrinsics.checkNotNull((Object)protoType);
            syntaxRules.validateTypeReference(this.get(protoType), this.errors.at(iterator2));
        }
        for (Map.Entry entry : ((Map)tagToField).entrySet()) {
            int key = ((Number)entry.getKey()).intValue();
            Set values = (Set)entry.getValue();
            if (values.size() <= 1) continue;
            error = new StringBuilder();
            error.append("multiple fields share tag " + key + ':');
            Object $this$forEachIndexed$iv = values;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            iterator = $this$forEachIndexed$iv.iterator();
            while (iterator.hasNext()) {
                item$iv = iterator.next();
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Field field2 = (Field)item$iv;
                int index = n;
                bl = false;
                error.append("\n  " + (index + 1) + ". " + field.getName() + " (" + field.getLocation() + ')');
            }
            $this$forEachIndexed$iv = error.toString();
            Intrinsics.checkNotNullExpressionValue((Object)$this$forEachIndexed$iv, (String)"error.toString()");
            this.errors.plusAssign((String)$this$forEachIndexed$iv);
        }
        boolean hasCollidingFields = false;
        for (Set collidingFields : nameToField.values()) {
            if (collidingFields.size() <= 1) continue;
            hasCollidingFields = true;
            Field first = (Field)collidingFields.iterator().next();
            error = new StringBuilder();
            error.append("multiple fields share name " + first.getName() + ':');
            Intrinsics.checkNotNullExpressionValue((Object)collidingFields, (String)"collidingFields");
            Object $this$forEachIndexed$iv = collidingFields;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            iterator = $this$forEachIndexed$iv.iterator();
            while (iterator.hasNext()) {
                item$iv = iterator.next();
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                field = (Field)item$iv;
                int index2 = n;
                bl = false;
                error.append("\n  " + (index2 + 1) + ". " + field.getName() + " (" + field.getLocation() + ')');
            }
            $this$forEachIndexed$iv = error.toString();
            Intrinsics.checkNotNullExpressionValue((Object)$this$forEachIndexed$iv, (String)"error.toString()");
            this.errors.plusAssign((String)$this$forEachIndexed$iv);
        }
        if (!hasCollidingFields) {
            for (Map.Entry entry : ((Map)jsonNameToField).entrySet()) {
                String jsonName = (String)entry.getKey();
                Set fields2 = (Set)entry.getValue();
                if (fields2.size() <= 1) continue;
                StringBuilder error2 = new StringBuilder();
                error2.append("multiple fields share same JSON name '" + jsonName + "':");
                Iterable $this$forEachIndexed$iv = fields2;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv2 : $this$forEachIndexed$iv) {
                    void field4;
                    int n2;
                    if ((n2 = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Field index2 = (Field)item$iv2;
                    int index3 = n2;
                    boolean bl5 = false;
                    error2.append("\n  " + (index3 + 1) + ". " + field4.getName() + " (" + field4.getLocation() + ')');
                }
                String string = error2.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"error.toString()");
                this.errors.plusAssign(string);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validatePackages() {
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = this.fileLinkers.values();
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            FileLinker it = (FileLinker)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getProtoFile().getPackageName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map filesByPackageName = destination$iv$iv;
        for (List fileLinkers : filesByPackageName.values()) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = fileLinkers;
            boolean $i$f$flatMap = false;
            Iterable iterable2 = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                FileLinker it = (FileLinker)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getProtoFile().getTypes();
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            List types = (List)destination$iv$iv2;
            this.withContext(((FileLinker)fileLinkers.get(0)).getProtoFile()).validateEnumConstantNameUniqueness(types);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void validateEnumConstantNameUniqueness(@NotNull Iterable<? extends Type> nestedTypes) {
        Intrinsics.checkNotNullParameter(nestedTypes, (String)"nestedTypes");
        Map nameToType = new LinkedHashMap();
        for (Type entry : nestedTypes) {
            if (!(entry instanceof EnumType)) continue;
            for (EnumConstant enumConstant : ((EnumType)entry).getConstants()) {
                Set set;
                Set $this$getOrPut$iv;
                Map map = nameToType;
                String key$iv = enumConstant.getName();
                boolean $i$f$getOrPut = false;
                Set value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put((String)key$iv, (Set)answer$iv);
                    set = answer$iv;
                } else {
                    set = value$iv;
                }
                $this$getOrPut$iv = set;
                Set it = $this$getOrPut$iv;
                boolean bl = false;
                ((Collection)it).add(entry);
            }
        }
        for (Map.Entry entry : nameToType.entrySet()) {
            String error;
            StringBuilder stringBuilder;
            String constant = (String)entry.getKey();
            Set values = (Set)entry.getValue();
            if (values.size() <= 1) continue;
            StringBuilder $this$validateEnumConstantNameUniqueness_u24lambda_u2d14 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$validateEnumConstantNameUniqueness_u24lambda_u2d14.append("multiple enums share constant " + constant + ':');
            Iterable $this$forEachIndexed$iv = values;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void enumType;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                EnumType enumType2 = (EnumType)item$iv;
                int index = n;
                boolean bl2 = false;
                StringBuilder stringBuilder2 = new StringBuilder().append("\n  ").append(index + 1).append(". ").append(enumType.getType()).append('.').append(constant).append(" (");
                EnumConstant enumConstant = enumType.constant(constant);
                Intrinsics.checkNotNull((Object)enumConstant);
                $this$validateEnumConstantNameUniqueness_u24lambda_u2d14.append(stringBuilder2.append(enumConstant.getLocation()).append(')').toString());
            }
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.toString(), (String)"StringBuilder().apply(builderAction).toString()");
            this.errors.plusAssign(error);
        }
    }

    public final void validateImportForType(@NotNull Location location, @NotNull ProtoType type) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        ProtoType type2 = type;
        if (type2.isMap()) {
            ProtoType protoType = type2.getValueType();
            Intrinsics.checkNotNull((Object)protoType);
            type2 = protoType;
        }
        if (type2.isScalar()) {
            return;
        }
        String path = location.getPath();
        Type type3 = this.get(type2);
        Intrinsics.checkNotNull((Object)type3);
        String requiredImport = type3.getLocation().getPath();
        FileLinker fileLinker = this.getFileLinker$wire_schema(path);
        if (!Intrinsics.areEqual((Object)path, (Object)requiredImport) && !fileLinker.effectiveImports().contains(requiredImport)) {
            this.errors.plusAssign(path + " needs to import " + requiredImport);
        }
    }

    public final void validateImportForPath(@NotNull Location location, @NotNull String requiredImport) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)requiredImport, (String)"requiredImport");
        String path = location.getPath();
        FileLinker fileLinker = this.getFileLinker$wire_schema(path);
        if (!Intrinsics.areEqual((Object)path, (Object)requiredImport) && !fileLinker.effectiveImports().contains(requiredImport)) {
            this.errors.plusAssign(path + " needs to import " + requiredImport);
        }
    }

    @NotNull
    public final Linker withContext(@NotNull Object context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new Linker(this, context);
    }
}

