/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.schema.CoreLoader;
import com.squareup.wire.schema.ErrorCollector;
import com.squareup.wire.schema.Loader;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import com.squareup.wire.schema.internal.parser.ProtoParser;
import java.io.Closeable;
import kotlin.ExceptionsKt;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import okio.BufferedSource;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0004J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u0004H\u0016J\u0010\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lcom/squareup/wire/schema/CoreLoader;", "Lcom/squareup/wire/schema/Loader;", "()V", "ANY_PROTO", "", "DESCRIPTOR_PROTO", "DURATION_PROTO", "EMPTY_PROTO", "STRUCT_PROTO", "TIMESTAMP_PROTO", "WIRE_EXTENSIONS_PROTO", "WIRE_RUNTIME_JAR", "WRAPPERS_PROTO", "resourceFileSystem", "Lokio/FileSystem;", "getResourceFileSystem", "()Lokio/FileSystem;", "resourceFileSystem$delegate", "Lkotlin/Lazy;", "isWireRuntimeProto", "", "location", "Lcom/squareup/wire/schema/Location;", "path", "load", "Lcom/squareup/wire/schema/ProtoFile;", "withErrors", "errors", "Lcom/squareup/wire/schema/ErrorCollector;", "wire-schema"})
public final class CoreLoader
implements Loader {
    @NotNull
    public static final CoreLoader INSTANCE = new CoreLoader();
    @NotNull
    private static final String ANY_PROTO = "google/protobuf/any.proto";
    @NotNull
    private static final String DESCRIPTOR_PROTO = "google/protobuf/descriptor.proto";
    @NotNull
    private static final String DURATION_PROTO = "google/protobuf/duration.proto";
    @NotNull
    private static final String EMPTY_PROTO = "google/protobuf/empty.proto";
    @NotNull
    private static final String STRUCT_PROTO = "google/protobuf/struct.proto";
    @NotNull
    private static final String TIMESTAMP_PROTO = "google/protobuf/timestamp.proto";
    @NotNull
    private static final String WRAPPERS_PROTO = "google/protobuf/wrappers.proto";
    @NotNull
    private static final String WIRE_EXTENSIONS_PROTO = "wire/extensions.proto";
    @NotNull
    public static final String WIRE_RUNTIME_JAR = "wire-runtime.jar";
    @NotNull
    private static final Lazy resourceFileSystem$delegate = LazyKt.lazy((Function0)resourceFileSystem.2.INSTANCE);

    private CoreLoader() {
    }

    private final FileSystem getResourceFileSystem() {
        Lazy lazy = resourceFileSystem$delegate;
        return (FileSystem)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ProtoFile load(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (this.isWireRuntimeProto(path)) {
            void this_$iv;
            FileSystem fileSystem = this.getResourceFileSystem();
            Path file$iv = Path.Companion.get$default((Path.Companion)Path.Companion, (String)"/", (boolean)false, (int)1, null).resolve(path);
            boolean bl = false;
            Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
            boolean $i$f$use = false;
            Object result$iv$iv = null;
            Throwable thrown$iv$iv = null;
            try {
                BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
                boolean bl2 = false;
                BufferedSource $this$load_u24lambda_u2d0 = it$iv;
                boolean bl3 = false;
                String data = $this$load_u24lambda_u2d0.readUtf8();
                Location location = Location.Companion.get(path);
                ProtoFileElement element = ProtoParser.Companion.parse(location, data);
                return ProtoFile.Companion.get(element);
            }
            catch (Throwable t$iv$iv) {
                block8: {
                    thrown$iv$iv = t$iv$iv;
                    try {
                        Closeable closeable = $this$use$iv$iv;
                        if (closeable != null) {
                            closeable.close();
                        }
                    }
                    catch (Throwable t$iv$iv2) {
                        if (thrown$iv$iv == null) {
                            thrown$iv$iv = t$iv$iv2;
                            break block8;
                        }
                        ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                    }
                }
                if (thrown$iv$iv != null) {
                    throw thrown$iv$iv;
                }
                Intrinsics.checkNotNull(result$iv$iv);
                throw new KotlinNothingValueException();
            }
        }
        throw new IllegalStateException(Intrinsics.stringPlus((String)"unexpected load: ", (Object)path).toString());
    }

    public final boolean isWireRuntimeProto(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return Intrinsics.areEqual((Object)location.getBase(), (Object)WIRE_RUNTIME_JAR) && this.isWireRuntimeProto(location.getPath());
    }

    public final boolean isWireRuntimeProto(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return Intrinsics.areEqual((Object)path, (Object)ANY_PROTO) || Intrinsics.areEqual((Object)path, (Object)DESCRIPTOR_PROTO) || Intrinsics.areEqual((Object)path, (Object)DURATION_PROTO) || Intrinsics.areEqual((Object)path, (Object)EMPTY_PROTO) || Intrinsics.areEqual((Object)path, (Object)STRUCT_PROTO) || Intrinsics.areEqual((Object)path, (Object)TIMESTAMP_PROTO) || Intrinsics.areEqual((Object)path, (Object)WRAPPERS_PROTO) || Intrinsics.areEqual((Object)path, (Object)WIRE_EXTENSIONS_PROTO);
    }

    @Override
    @NotNull
    public CoreLoader withErrors(@NotNull ErrorCollector errors) {
        Intrinsics.checkNotNullParameter((Object)errors, (String)"errors");
        return this;
    }
}

