/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.schema.DirectoryRoot;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.ProtoFilePath;
import com.squareup.wire.schema.Root;
import com.squareup.wire.schema.internal.UtilKt;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/squareup/wire/schema/DirectoryRoot;", "Lcom/squareup/wire/schema/Root;", "base", "", "fileSystem", "Lokio/FileSystem;", "rootDirectory", "Lokio/Path;", "(Ljava/lang/String;Lokio/FileSystem;Lokio/Path;)V", "getBase", "()Ljava/lang/String;", "getFileSystem", "()Lokio/FileSystem;", "getRootDirectory", "()Lokio/Path;", "allProtoFiles", "", "Lcom/squareup/wire/schema/ProtoFilePath;", "resolve", "import", "toString", "wire-compiler"})
public final class DirectoryRoot
extends Root {
    @NotNull
    private final String base;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Path rootDirectory;

    public DirectoryRoot(@NotNull String base, @NotNull FileSystem fileSystem, @NotNull Path rootDirectory) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)rootDirectory, (String)"rootDirectory");
        super(null);
        this.base = base;
        this.fileSystem = fileSystem;
        this.rootDirectory = rootDirectory;
    }

    @Override
    @NotNull
    public String getBase() {
        return this.base;
    }

    @NotNull
    public final FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @NotNull
    public final Path getRootDirectory() {
        return this.rootDirectory;
    }

    @Override
    @NotNull
    public Set<ProtoFilePath> allProtoFiles() {
        return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)this.fileSystem.listRecursively(this.rootDirectory), (Function1)allProtoFiles.1.INSTANCE), (Function1)((Function1)new Function1<Path, ProtoFilePath>(this){
            final /* synthetic */ DirectoryRoot this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final ProtoFilePath invoke(@NotNull Path descendant) {
                Intrinsics.checkNotNullParameter((Object)descendant, (String)"descendant");
                Location location = Location.Companion.get(this.this$0.getBase(), UtilKt.withUnixSlashes((Path)descendant.relativeTo(this.this$0.getRootDirectory())).toString());
                return new ProtoFilePath(location, this.this$0.getFileSystem(), descendant);
            }
        })));
    }

    @Override
    @Nullable
    public ProtoFilePath resolve(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"import");
        Path resolved = this.rootDirectory.resolve(string);
        if (!this.fileSystem.exists(resolved)) {
            return null;
        }
        return new ProtoFilePath(Location.Companion.get(this.getBase(), UtilKt.withUnixSlashes((Path)Path.Companion.get$default((Path.Companion)Path.Companion, (String)string, (boolean)false, (int)1, null)).toString()), this.fileSystem, resolved);
    }

    @NotNull
    public String toString() {
        return this.getBase();
    }
}

