/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.converter.gson;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import retrofit2.converter.gson.GsonRequestBodyConverter;

final class GsonStreamingRequestBody<T>
extends RequestBody {
    private final Gson gson;
    private final TypeAdapter<T> adapter;
    private final T value;

    public GsonStreamingRequestBody(Gson gson, TypeAdapter<T> adapter, T value) {
        this.gson = gson;
        this.adapter = adapter;
        this.value = value;
    }

    public MediaType contentType() {
        return GsonRequestBodyConverter.MEDIA_TYPE;
    }

    public void writeTo(BufferedSink sink) throws IOException {
        GsonRequestBodyConverter.writeJson(sink, this.gson, this.adapter, this.value);
    }
}

