//[okio](../../../index.md)/[okio](../index.md)/[GzipSource](index.md)

# GzipSource

[jvm]\
class [GzipSource](index.md)(source: [Source](../-source/index.md#1331753033%2FMain%2F1033915053)) : [Source](../-source/index.md#1331753033%2FMain%2F1033915053)

A source that uses [GZIP](http://www.ietf.org/rfc/rfc1952.txt) to decompress data read from another source.

## Constructors

| | |
|---|---|
| [GzipSource](-gzip-source.md) | [jvm]<br>constructor(source: [Source](../-source/index.md#1331753033%2FMain%2F1033915053)) |

## Functions

| Name | Summary |
|---|---|
| [buffer](../buffer.md) | [common]<br>fun [Source](../-source/index.md).[buffer](../buffer.md)(): [BufferedSource](../-buffered-source/index.md)<br>Returns a new source that buffers reads from `source`. The returned source will perform bulk reads into its in-memory buffer. Use this wherever you read a source to get an ergonomic and efficient access to data. |
| [cipherSource](../cipher-source.md) | [jvm]<br>fun [Source](../-source/index.md#1331753033%2FMain%2F1033915053).[cipherSource](../cipher-source.md)(cipher: [Cipher](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Cipher.html)): [CipherSource](../-cipher-source/index.md)<br>Returns a source that uses [cipher](../cipher-source.md) to encrypt or decrypt this. |
| [close](close.md) | [jvm]<br>open override fun [close](close.md)()<br>Closes this source and releases the resources held by this source. It is an error to read a closed source. It is safe to close a source more than once. |
| [gzip](../gzip.md) | [jvm]<br>inline fun [Source](../-source/index.md#1331753033%2FMain%2F1033915053).[gzip](../gzip.md)(): [GzipSource](index.md)<br>Returns a [GzipSource](index.md) that gzip-decompresses this [Source](../-source/index.md#1331753033%2FMain%2F1033915053) while reading. |
| [hashingSource](../hashing-source.md) | [jvm]<br>fun [Source](../-source/index.md#1331753033%2FMain%2F1033915053).[hashingSource](../hashing-source.md)(digest: [MessageDigest](https://docs.oracle.com/javase/8/docs/api/java/security/MessageDigest.html)): [HashingSource](../-hashing-source/index.md)<br>Returns a source that uses [digest](../hashing-source.md) to hash this.<br>[jvm]<br>fun [Source](../-source/index.md#1331753033%2FMain%2F1033915053).[hashingSource](../hashing-source.md)(mac: [Mac](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Mac.html)): [HashingSource](../-hashing-source/index.md)<br>Returns a source that uses [mac](../hashing-source.md) to hash this. |
| [inflate](../inflate.md) | [jvm]<br>inline fun [Source](../-source/index.md#1331753033%2FMain%2F1033915053).[inflate](../inflate.md)(inflater: [Inflater](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Inflater.html) = Inflater()): [InflaterSource](../-inflater-source/index.md)<br>Returns an [InflaterSource](../-inflater-source/index.md) that DEFLATE-decompresses this [Source](../-source/index.md#1331753033%2FMain%2F1033915053) while reading. |
| [read](read.md) | [jvm]<br>open override fun [read](read.md)(sink: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Removes at least 1, and up to `byteCount` bytes from this and appends them to `sink`. Returns the number of bytes read, or -1 if this source is exhausted. |
| [timeout](timeout.md) | [jvm]<br>open override fun [timeout](timeout.md)(): [Timeout](../-timeout/index.md)<br>Returns the timeout for this source. |
