//[okio](../../../index.md)/[okio](../index.md)/[BufferedSource](index.md)

# BufferedSource

[common]\
interface [BufferedSource](index.md) : [Source](../-source/index.md)

A source that keeps a buffer internally so that callers can do small reads without a performance penalty. It also allows clients to read ahead, buffering as much as necessary before consuming input.

[jvm]\
interface [BufferedSource](index.md) : [Source](../-source/index.md#1331753033%2FExtensions%2F1033915053), [ReadableByteChannel](https://docs.oracle.com/javase/8/docs/api/java/nio/channels/ReadableByteChannel.html)

[nonJvm]\
interface [BufferedSource](index.md) : Source

## Functions

| Name | Summary |
|---|---|
| close | [common, jvm, nonJvm]<br>[common]<br>abstract override fun [close](../-source/close.md)()<br>[jvm]<br>abstract override fun [close](index.md#-267757364%2FFunctions%2F1033915053)()<br>[nonJvm]<br>abstract override fun [close](../-hashing-source/index.md#-267757364%2FFunctions%2F1730460553)()<br>Closes this source and releases the resources held by this source. It is an error to read a closed source. It is safe to close a source more than once. |
| [exhausted](exhausted.md) | [common]<br>abstract fun [exhausted](exhausted.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if there are no more bytes in this source. This will block until there are bytes to read or the source is definitely exhausted.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>abstract fun [exhausted](exhausted.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [indexOf](index-of.md) | [common]<br>abstract fun [indexOf](index-of.md)(b: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Equivalent to [indexOf(b, 0)](index-of.md).<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>abstract fun [indexOf](index-of.md)(b: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[jvm, nonJvm]<br>abstract fun [indexOf](index-of.md)(bytes: [ByteString](../-byte-string/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[jvm, nonJvm]<br>abstract fun [indexOf](index-of.md)(b: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[jvm, nonJvm]<br>abstract fun [indexOf](index-of.md)(bytes: [ByteString](../-byte-string/index.md), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[jvm, nonJvm]<br>abstract fun [indexOf](index-of.md)(b: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), toIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[common]<br>abstract fun [indexOf](index-of.md)(bytes: [ByteString](../-byte-string/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Equivalent to [indexOf(bytes, 0)](index-of.md).<br>[common]<br>abstract fun [indexOf](index-of.md)(b: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the index of the first b in the buffer at or after fromIndex. This expands the buffer as necessary until b is found. This reads an unbounded number of bytes into the buffer. Returns -1 if the stream is exhausted before the requested byte is found.<br>[common]<br>abstract fun [indexOf](index-of.md)(bytes: [ByteString](../-byte-string/index.md), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the index of the first match for bytes in the buffer at or after fromIndex. This expands the buffer as necessary until bytes is found. This reads an unbounded number of bytes into the buffer. Returns -1 if the stream is exhausted before the requested bytes are found.<br>[common]<br>abstract fun [indexOf](index-of.md)(b: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), toIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the index of b if it is found in the range of fromIndex inclusive to toIndex exclusive. If b isn't found, or if fromIndex == toIndex, then -1 is returned. |
| [indexOfElement](index-of-element.md) | [common]<br>abstract fun [indexOfElement](index-of-element.md)(targetBytes: [ByteString](../-byte-string/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Equivalent to [indexOfElement(targetBytes, 0)](index-of-element.md).<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>abstract fun [indexOfElement](index-of-element.md)(targetBytes: [ByteString](../-byte-string/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[jvm, nonJvm]<br>abstract fun [indexOfElement](index-of-element.md)(targetBytes: [ByteString](../-byte-string/index.md), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[common]<br>abstract fun [indexOfElement](index-of-element.md)(targetBytes: [ByteString](../-byte-string/index.md), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the first index in this buffer that is at or after fromIndex and that contains any of the bytes in targetBytes. This expands the buffer as necessary until a target byte is found. This reads an unbounded number of bytes into the buffer. Returns -1 if the stream is exhausted before the requested byte is found. |
| [inputStream](input-stream.md) | [jvm]<br>abstract fun [inputStream](input-stream.md)(): [InputStream](https://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html)<br>Returns an input stream that reads from this source. |
| [isOpen](index.md#1887389732%2FFunctions%2F1033915053) | [jvm]<br>abstract fun [isOpen](index.md#1887389732%2FFunctions%2F1033915053)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [peek](peek.md) | [common]<br>abstract fun [peek](peek.md)(): [BufferedSource](index.md)<br>Returns a new BufferedSource that can read data from this BufferedSource without consuming it. The returned source becomes invalid once this source is next read or closed.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>abstract fun [peek](peek.md)(): [BufferedSource](index.md) |
| [rangeEquals](range-equals.md) | [common]<br>abstract fun [rangeEquals](range-equals.md)(offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), bytes: [ByteString](../-byte-string/index.md)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if the bytes at offset in this source equal bytes. This expands the buffer as necessary until a byte does not match, all bytes are matched, or if the stream is exhausted before enough bytes could determine a match.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>abstract fun [rangeEquals](range-equals.md)(offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), bytes: [ByteString](../-byte-string/index.md)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>[jvm, nonJvm]<br>abstract fun [rangeEquals](range-equals.md)(offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), bytes: [ByteString](../-byte-string/index.md), bytesOffset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>[common]<br>abstract fun [rangeEquals](range-equals.md)(offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), bytes: [ByteString](../-byte-string/index.md), bytesOffset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if byteCount bytes at offset in this source equal bytes at bytesOffset. This expands the buffer as necessary until a byte does not match, all bytes are matched, or if the stream is exhausted before enough bytes could determine a match. |
| read | [jvm, nonJvm]<br>[jvm]<br>abstract fun [read](index.md#-1465706134%2FFunctions%2F1033915053)(p0: [ByteBuffer](https://docs.oracle.com/javase/8/docs/api/java/nio/ByteBuffer.html)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[jvm, nonJvm]<br>abstract fun [read](read.md)(sink: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[jvm, nonJvm]<br>abstract fun [read](read.md)(sink: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[common]<br>abstract fun [read](read.md)(sink: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Removes up to sink.length bytes from this and copies them into sink. Returns the number of bytes read, or -1 if this source is exhausted.<br>[common, jvm, nonJvm]<br>[common]<br>abstract fun [read](../-source/read.md)(sink: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[jvm]<br>abstract fun [read](../-hashing-source/index.md#-934028336%2FFunctions%2F1033915053)(sink: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[nonJvm]<br>abstract fun [read](../-hashing-source/index.md#-934028336%2FFunctions%2F1730460553)(sink: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Removes at least 1, and up to byteCount bytes from this and appends them to sink. Returns the number of bytes read, or -1 if this source is exhausted.<br>[common]<br>abstract fun [read](read.md)(sink: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Removes up to byteCount bytes from this and copies them into sink at offset. Returns the number of bytes read, or -1 if this source is exhausted. |
| [readAll](read-all.md) | [common]<br>abstract fun [readAll](read-all.md)(sink: [Sink](../-sink/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Removes all bytes from this and appends them to sink. Returns the total number of bytes written to sink which will be 0 if this is exhausted.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>abstract fun [readAll](read-all.md)(sink: [Sink](../-sink/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| [readByte](read-byte.md) | [common]<br>abstract fun [readByte](read-byte.md)(): [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)<br>Removes a byte from this source and returns it.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>abstract fun [readByte](read-byte.md)(): [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html) |
| [readByteArray](read-byte-array.md) | [common]<br>abstract fun [readByteArray](read-byte-array.md)(): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>Removes all bytes from this and returns them as a byte array.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>abstract fun [readByteArray](read-byte-array.md)(): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>[jvm, nonJvm]<br>abstract fun [readByteArray](read-byte-array.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>[common]<br>abstract fun [readByteArray](read-byte-array.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>Removes byteCount bytes from this and returns them as a byte array. |
| [readByteString](read-byte-string.md) | [common]<br>abstract fun [readByteString](read-byte-string.md)(): [ByteString](../-byte-string/index.md)<br>Removes all bytes from this and returns them as a byte string.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>abstract fun [readByteString](read-byte-string.md)(): [ByteString](../-byte-string/index.md)<br>[jvm, nonJvm]<br>abstract fun [readByteString](read-byte-string.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [ByteString](../-byte-string/index.md)<br>[common]<br>abstract fun [readByteString](read-byte-string.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [ByteString](../-byte-string/index.md)<br>Removes byteCount bytes from this and returns them as a byte string. |
| [readDecimalLong](read-decimal-long.md) | [common]<br>abstract fun [readDecimalLong](read-decimal-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Reads a long from this source in signed decimal form (i.e., as a string in base 10 with optional leading '-'). This will iterate until a non-digit character is found.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>abstract fun [readDecimalLong](read-decimal-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| [readFully](read-fully.md) | [common]<br>abstract fun [readFully](read-fully.md)(sink: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html))<br>Removes exactly sink.length bytes from this and copies them into sink. Throws an java.io.EOFException if the requested number of bytes cannot be read.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>abstract fun [readFully](read-fully.md)(sink: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html))<br>[jvm, nonJvm]<br>abstract fun [readFully](read-fully.md)(sink: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))<br>[common]<br>abstract fun [readFully](read-fully.md)(sink: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))<br>Removes exactly byteCount bytes from this and appends them to sink. Throws an java.io.EOFException if the requested number of bytes cannot be read. |
| [readHexadecimalUnsignedLong](read-hexadecimal-unsigned-long.md) | [common]<br>abstract fun [readHexadecimalUnsignedLong](read-hexadecimal-unsigned-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Reads a long form this source in hexadecimal form (i.e., as a string in base 16). This will iterate until a non-hexadecimal character is found.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>abstract fun [readHexadecimalUnsignedLong](read-hexadecimal-unsigned-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| [readInt](read-int.md) | [common]<br>abstract fun [readInt](read-int.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Removes four bytes from this source and returns a big-endian int.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>abstract fun [readInt](read-int.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [readIntLe](read-int-le.md) | [common]<br>abstract fun [readIntLe](read-int-le.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Removes four bytes from this source and returns a little-endian int.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>abstract fun [readIntLe](read-int-le.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [readLong](read-long.md) | [common]<br>abstract fun [readLong](read-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Removes eight bytes from this source and returns a big-endian long.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>abstract fun [readLong](read-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| [readLongLe](read-long-le.md) | [common]<br>abstract fun [readLongLe](read-long-le.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Removes eight bytes from this source and returns a little-endian long.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>abstract fun [readLongLe](read-long-le.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| [readShort](read-short.md) | [common]<br>abstract fun [readShort](read-short.md)(): [Short](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html)<br>Removes two bytes from this source and returns a big-endian short.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>abstract fun [readShort](read-short.md)(): [Short](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html) |
| [readShortLe](read-short-le.md) | [common]<br>abstract fun [readShortLe](read-short-le.md)(): [Short](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html)<br>Removes two bytes from this source and returns a little-endian short.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>abstract fun [readShortLe](read-short-le.md)(): [Short](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html) |
| [readString](read-string.md) | [jvm]<br>abstract fun [readString](read-string.md)(charset: [Charset](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Removes all bytes from this, decodes them as charset, and returns the string.<br>[jvm]<br>abstract fun [readString](read-string.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), charset: [Charset](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Removes byteCount bytes from this, decodes them as charset, and returns the string. |
| [readUtf8](read-utf8.md) | [common]<br>abstract fun [readUtf8](read-utf8.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Removes all bytes from this, decodes them as UTF-8, and returns the string. Returns the empty string if this source is empty.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>abstract fun [readUtf8](read-utf8.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>[jvm, nonJvm]<br>abstract fun [readUtf8](read-utf8.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>[common]<br>abstract fun [readUtf8](read-utf8.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Removes byteCount bytes from this, decodes them as UTF-8, and returns the string. |
| [readUtf8CodePoint](read-utf8-code-point.md) | [common]<br>abstract fun [readUtf8CodePoint](read-utf8-code-point.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Removes and returns a single UTF-8 code point, reading between 1 and 4 bytes as necessary.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>abstract fun [readUtf8CodePoint](read-utf8-code-point.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [readUtf8Line](read-utf8-line.md) | [common]<br>abstract fun [readUtf8Line](read-utf8-line.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?<br>Removes and returns characters up to but not including the next line break. A line break is either "\n" or "\r\n"; these characters are not included in the result.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>abstract fun [readUtf8Line](read-utf8-line.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? |
| [readUtf8LineStrict](read-utf8-line-strict.md) | [common]<br>abstract fun [readUtf8LineStrict](read-utf8-line-strict.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Removes and returns characters up to but not including the next line break. A line break is either "\n" or "\r\n"; these characters are not included in the result.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>abstract fun [readUtf8LineStrict](read-utf8-line-strict.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>[jvm, nonJvm]<br>abstract fun [readUtf8LineStrict](read-utf8-line-strict.md)(limit: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>[common]<br>abstract fun [readUtf8LineStrict](read-utf8-line-strict.md)(limit: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Like [readUtf8LineStrict](read-utf8-line-strict.md), except this allows the caller to specify the longest allowed match. Use this to protect against streams that may not include "\n" or "\r\n". |
| [request](request.md) | [common]<br>abstract fun [request](request.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true when the buffer contains at least byteCount bytes, expanding it as necessary. Returns false if the source is exhausted before the requested bytes can be read.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>abstract fun [request](request.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [require](require.md) | [common]<br>abstract fun [require](require.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))<br>Returns when the buffer contains at least byteCount bytes. Throws an java.io.EOFException if the source is exhausted before the required bytes can be read.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>abstract fun [require](require.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)) |
| [select](select.md) | [common]<br>abstract fun [select](select.md)(options: [Options](../-options/index.md)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Finds the first string in options that is a prefix of this buffer, consumes it from this buffer, and returns its index. If no byte string in options is a prefix of this buffer this returns -1 and no bytes are consumed.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>abstract fun [select](select.md)(options: Options): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [skip](skip.md) | [common]<br>abstract fun [skip](skip.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))<br>Reads and discards byteCount bytes from this source. Throws an java.io.EOFException if the source is exhausted before the requested bytes can be skipped.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>abstract fun [skip](skip.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)) |
| timeout | [common, jvm, nonJvm]<br>[common]<br>abstract fun [timeout](../-source/timeout.md)(): [Timeout](../-timeout/index.md)<br>[jvm]<br>abstract fun [timeout](index.md#665058243%2FFunctions%2F1033915053)(): [Timeout](../-timeout/index.md)<br>[nonJvm]<br>abstract fun [timeout](../-hashing-source/index.md#665058243%2FFunctions%2F1730460553)(): [Timeout](../-timeout/index.md)<br>Returns the timeout for this source. |

## Properties

| Name | Summary |
|---|---|
| [buffer](buffer.md) | [common]<br>abstract val [buffer](buffer.md): [Buffer](../-buffer/index.md)<br>This source's internal buffer.<br>[jvm, nonJvm]<br>abstract val [buffer](buffer.md): [Buffer](../-buffer/index.md) |

## Inheritors

| Name |
|---|
| [Buffer](../-buffer/index.md) |
