//[okio](../../../index.md)/[okio](../index.md)/[Buffer](index.md)

# Buffer

[common]\
class [Buffer](index.md) : [BufferedSource](../-buffered-source/index.md), [BufferedSink](../-buffered-sink/index.md)

A collection of bytes in memory.

**Moving data from one buffer to another is fast.** Instead of copying bytes from one place in memory to another, this class just changes ownership of the underlying byte arrays.

**This buffer grows with your data.** Just like ArrayList, each buffer starts small. It consumes only the memory it needs to.

**This buffer pools its byte arrays.** When you allocate a byte array in Java, the runtime must zero-fill the requested array before returning it to you. Even if you're going to write over that space anyway. This class avoids zero-fill and GC churn by pooling byte arrays.

[jvm]\
class [Buffer](index.md) : [BufferedSource](../-buffered-source/index.md), [BufferedSink](../-buffered-sink/index.md), [Cloneable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-cloneable/index.html), [ByteChannel](https://docs.oracle.com/javase/8/docs/api/java/nio/channels/ByteChannel.html)

[nonJvm]\
class [Buffer](index.md) : [BufferedSource](../-buffered-source/index.md), [BufferedSink](../-buffered-sink/index.md)

## Constructors

| | |
|---|---|
| [Buffer](-buffer.md) | [common]<br>fun [Buffer](-buffer.md)() |

## Types

| Name | Summary |
|---|---|
| [UnsafeCursor](-unsafe-cursor/index.md) | [common]<br>class [UnsafeCursor](-unsafe-cursor/index.md)<br>A handle to the underlying data in a buffer. This handle is unsafe because it does not enforce its own invariants. Instead, it assumes a careful user who has studied Okio's implementation details and their consequences.<br>[jvm, nonJvm]<br>[jvm]<br>class [UnsafeCursor](-unsafe-cursor/index.md) : [Closeable](https://docs.oracle.com/javase/8/docs/api/java/io/Closeable.html)<br>[nonJvm]<br>class [UnsafeCursor](-unsafe-cursor/index.md) |

## Functions

| Name | Summary |
|---|---|
| [buffer](buffer.md) | [jvm]<br>open override fun [buffer](buffer.md)(): [Buffer](index.md)<br>Returns this source's internal buffer. |
| [clear](clear.md) | [common]<br>fun [clear](clear.md)()<br>Discards all bytes in this buffer. Calling this method when you're done with a buffer will return its segments to the pool.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>fun [clear](clear.md)() |
| [clone](clone.md) | [jvm]<br>open override fun [clone](clone.md)(): [Buffer](index.md)<br>Returns a deep copy of this buffer. |
| close | [jvm, nonJvm, common]<br>[jvm]<br>open override fun [close]([jvm]close.md)()<br>[nonJvm]<br>open override fun [close]([non-jvm]close.md)()<br>[common]<br>abstract override fun [close](../-source/close.md)()<br>Closes this source and releases the resources held by this source. It is an error to read a closed source. It is safe to close a source more than once. |
| [completeSegmentByteCount](complete-segment-byte-count.md) | [common]<br>fun [completeSegmentByteCount](complete-segment-byte-count.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the number of bytes in segments that are not writable. This is the number of bytes that can be flushed immediately to an underlying sink without harming throughput.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>fun [completeSegmentByteCount](complete-segment-byte-count.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| [copy](copy.md) | [common]<br>fun [copy](copy.md)(): [Buffer](index.md)<br>Returns a deep copy of this buffer.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>fun [copy](copy.md)(): [Buffer](index.md) |
| [copyTo](copy-to.md) | [common]<br>fun [copyTo](copy-to.md)(out: [Buffer](index.md), offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) = 0L): [Buffer](index.md)<br>Overload of [copyTo](copy-to.md) with byteCount = size - offset, work around for https://youtrack.jetbrains.com/issue/KT-30847<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>fun [copyTo](copy-to.md)(out: [Buffer](index.md), offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) = 0L): [Buffer](index.md)<br>[jvm, nonJvm]<br>fun [copyTo](copy-to.md)(out: [Buffer](index.md), offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) = 0L, byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)<br>[jvm, common]<br>[jvm]<br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)<br>fun [copyTo](copy-to.md)(out: [OutputStream](https://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html), offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) = 0L, byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) = size - offset): [Buffer](index.md)<br>[common]<br>fun [copyTo](copy-to.md)(out: [Buffer](index.md), offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) = 0L, byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)<br>Copy byteCount bytes from this, starting at offset, to out. |
| [emit](emit.md) | [common]<br>open override fun [emit](emit.md)(): [Buffer](index.md)<br>Writes all buffered data to the underlying sink, if one exists. Like [flush](index.md#164302971%2FFunctions%2F1348982416), but weaker. Call this before this buffered sink goes out of scope so that its data can reach its destination.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>open override fun [emit](emit.md)(): [Buffer](index.md) |
| [emitCompleteSegments](emit-complete-segments.md) | [common]<br>open override fun [emitCompleteSegments](emit-complete-segments.md)(): [Buffer](index.md)<br>Writes complete segments to the underlying sink, if one exists. Like [flush](index.md#164302971%2FFunctions%2F1348982416), but weaker. Use this to limit the memory held in the buffer to a single segment. Typically application code will not need to call this: it is only necessary when application code writes directly to this [sink's buffer](../buffer.md).<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>open override fun [emitCompleteSegments](emit-complete-segments.md)(): [Buffer](index.md) |
| equals | [jvm, nonJvm]<br>[jvm]<br>open operator override fun [equals]([jvm]equals.md)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>[nonJvm]<br>open operator override fun [equals]([non-jvm]equals.md)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| exhausted | [jvm, nonJvm]<br>[jvm]<br>open override fun [exhausted]([jvm]exhausted.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>[nonJvm]<br>open override fun [exhausted]([non-jvm]exhausted.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>[common]<br>abstract fun [exhausted](../-buffered-source/exhausted.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if there are no more bytes in this source. This will block until there are bytes to read or the source is definitely exhausted. |
| flush | [jvm, nonJvm]<br>[jvm]<br>open override fun [flush]([jvm]flush.md)()<br>[nonJvm]<br>open override fun [flush]([non-jvm]flush.md)()<br>[common]<br>abstract override fun [flush](../-buffered-sink/flush.md)()<br>Writes all buffered data to the underlying sink, if one exists. Then that sink is recursively flushed which pushes data as far as possible towards its ultimate destination. Typically that destination is a network socket or file. |
| [get](get.md) | [common]<br>operator fun [get](get.md)(pos: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)<br>Returns the byte at pos.<br>[jvm, nonJvm]<br>[jvm]<br>@[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "getByte")<br>operator fun [get](get.md)(pos: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)<br>[nonJvm]<br>operator fun [get](get.md)(pos: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html) |
| hashCode | [jvm, nonJvm]<br>[jvm]<br>open override fun [hashCode]([jvm]hash-code.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[nonJvm]<br>open override fun [hashCode]([non-jvm]hash-code.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [hmacSha1](hmac-sha1.md) | [common, jvm, nonJvm]<br>[common, jvm, nonJvm]<br>fun [hmacSha1](hmac-sha1.md)(key: [ByteString](../-byte-string/index.md)): [ByteString](../-byte-string/index.md)<br>Returns the 160-bit SHA-1 HMAC of this buffer. |
| [hmacSha256](hmac-sha256.md) | [common, jvm, nonJvm]<br>[common, jvm, nonJvm]<br>fun [hmacSha256](hmac-sha256.md)(key: [ByteString](../-byte-string/index.md)): [ByteString](../-byte-string/index.md)<br>Returns the 256-bit SHA-256 HMAC of this buffer. |
| [hmacSha512](hmac-sha512.md) | [common, jvm, nonJvm]<br>[common, jvm, nonJvm]<br>fun [hmacSha512](hmac-sha512.md)(key: [ByteString](../-byte-string/index.md)): [ByteString](../-byte-string/index.md)<br>Returns the 512-bit SHA-512 HMAC of this buffer. |
| indexOf | [jvm, nonJvm]<br>[jvm]<br>open override fun [indexOf]([jvm]index-of.md)(b: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[nonJvm]<br>open override fun [indexOf]([non-jvm]index-of.md)(b: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[jvm]<br>open override fun [indexOf]([jvm]index-of.md)(bytes: [ByteString](../-byte-string/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[nonJvm]<br>open override fun [indexOf]([non-jvm]index-of.md)(bytes: [ByteString](../-byte-string/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[nonJvm]<br>open override fun [indexOf]([non-jvm]index-of.md)(b: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[jvm]<br>open override fun [indexOf]([jvm]index-of.md)(bytes: [ByteString](../-byte-string/index.md), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[nonJvm]<br>open override fun [indexOf]([non-jvm]index-of.md)(bytes: [ByteString](../-byte-string/index.md), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[jvm]<br>open override fun [indexOf]([jvm]index-of.md)(b: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), toIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[nonJvm]<br>open override fun [indexOf]([non-jvm]index-of.md)(b: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), toIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[common]<br>abstract fun [indexOf](../-buffered-source/index-of.md)(b: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Equivalent to [indexOf(b, 0)](../-buffered-source/index-of.md).<br>[common]<br>abstract fun [indexOf](../-buffered-source/index-of.md)(bytes: [ByteString](../-byte-string/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Equivalent to [indexOf(bytes, 0)](../-buffered-source/index-of.md).<br>[jvm]<br>open override fun [indexOf]([jvm]index-of.md)(b: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the index of b in this at or beyond fromIndex, or -1 if this buffer does not contain b in that range.<br>[common]<br>abstract fun [indexOf](../-buffered-source/index-of.md)(b: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the index of the first b in the buffer at or after fromIndex. This expands the buffer as necessary until b is found. This reads an unbounded number of bytes into the buffer. Returns -1 if the stream is exhausted before the requested byte is found.<br>[common]<br>abstract fun [indexOf](../-buffered-source/index-of.md)(bytes: [ByteString](../-byte-string/index.md), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the index of the first match for bytes in the buffer at or after fromIndex. This expands the buffer as necessary until bytes is found. This reads an unbounded number of bytes into the buffer. Returns -1 if the stream is exhausted before the requested bytes are found.<br>[common]<br>abstract fun [indexOf](../-buffered-source/index-of.md)(b: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), toIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the index of b if it is found in the range of fromIndex inclusive to toIndex exclusive. If b isn't found, or if fromIndex == toIndex, then -1 is returned. |
| indexOfElement | [jvm, nonJvm]<br>[jvm]<br>open override fun [indexOfElement]([jvm]index-of-element.md)(targetBytes: [ByteString](../-byte-string/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[nonJvm]<br>open override fun [indexOfElement]([non-jvm]index-of-element.md)(targetBytes: [ByteString](../-byte-string/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[jvm]<br>open override fun [indexOfElement]([jvm]index-of-element.md)(targetBytes: [ByteString](../-byte-string/index.md), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[nonJvm]<br>open override fun [indexOfElement]([non-jvm]index-of-element.md)(targetBytes: [ByteString](../-byte-string/index.md), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[common]<br>abstract fun [indexOfElement](../-buffered-source/index-of-element.md)(targetBytes: [ByteString](../-byte-string/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Equivalent to [indexOfElement(targetBytes, 0)](../-buffered-source/index-of-element.md).<br>[common]<br>abstract fun [indexOfElement](../-buffered-source/index-of-element.md)(targetBytes: [ByteString](../-byte-string/index.md), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the first index in this buffer that is at or after fromIndex and that contains any of the bytes in targetBytes. This expands the buffer as necessary until a target byte is found. This reads an unbounded number of bytes into the buffer. Returns -1 if the stream is exhausted before the requested byte is found. |
| [inputStream](input-stream.md) | [jvm]<br>open override fun [inputStream](input-stream.md)(): [InputStream](https://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html)<br>Returns an input stream that reads from this source. |
| [isOpen](is-open.md) | [jvm]<br>open override fun [isOpen](is-open.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [md5](md5.md) | [common, nonJvm]<br>[common, nonJvm]<br>fun [md5](md5.md)(): [ByteString](../-byte-string/index.md)<br>[jvm]<br>fun [md5](md5.md)(): [ByteString](../-byte-string/index.md)<br>Returns the 128-bit MD5 hash of this buffer. |
| [outputStream](output-stream.md) | [jvm]<br>open override fun [outputStream](output-stream.md)(): [OutputStream](https://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html)<br>Returns an output stream that writes to this sink. |
| peek | [jvm, nonJvm]<br>[jvm]<br>open override fun [peek]([jvm]peek.md)(): [BufferedSource](../-buffered-source/index.md)<br>[nonJvm]<br>open override fun [peek]([non-jvm]peek.md)(): [BufferedSource](../-buffered-source/index.md)<br>[common]<br>abstract fun [peek](../-buffered-source/peek.md)(): [BufferedSource](../-buffered-source/index.md)<br>Returns a new BufferedSource that can read data from this BufferedSource without consuming it. The returned source becomes invalid once this source is next read or closed. |
| rangeEquals | [jvm, nonJvm]<br>[jvm]<br>open override fun [rangeEquals]([jvm]range-equals.md)(offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), bytes: [ByteString](../-byte-string/index.md)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>[nonJvm]<br>open override fun [rangeEquals]([non-jvm]range-equals.md)(offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), bytes: [ByteString](../-byte-string/index.md)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>[jvm]<br>open override fun [rangeEquals]([jvm]range-equals.md)(offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), bytes: [ByteString](../-byte-string/index.md), bytesOffset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>[nonJvm]<br>open override fun [rangeEquals]([non-jvm]range-equals.md)(offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), bytes: [ByteString](../-byte-string/index.md), bytesOffset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>[common]<br>abstract fun [rangeEquals](../-buffered-source/range-equals.md)(offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), bytes: [ByteString](../-byte-string/index.md)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if the bytes at offset in this source equal bytes. This expands the buffer as necessary until a byte does not match, all bytes are matched, or if the stream is exhausted before enough bytes could determine a match.<br>[common]<br>abstract fun [rangeEquals](../-buffered-source/range-equals.md)(offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), bytes: [ByteString](../-byte-string/index.md), bytesOffset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if byteCount bytes at offset in this source equal bytes at bytesOffset. This expands the buffer as necessary until a byte does not match, all bytes are matched, or if the stream is exhausted before enough bytes could determine a match. |
| read | [jvm, nonJvm]<br>[jvm]<br>open override fun [read](read.md)(sink: [ByteBuffer](https://docs.oracle.com/javase/8/docs/api/java/nio/ByteBuffer.html)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[jvm]<br>open override fun [read]([jvm]read.md)(sink: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[nonJvm]<br>open override fun [read]([non-jvm]read.md)(sink: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[jvm]<br>open override fun [read]([jvm]read.md)(sink: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[nonJvm]<br>open override fun [read]([non-jvm]read.md)(sink: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[common]<br>abstract fun [read](../-buffered-source/read.md)(sink: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Removes up to sink.length bytes from this and copies them into sink. Returns the number of bytes read, or -1 if this source is exhausted.<br>[jvm, nonJvm, common]<br>[jvm]<br>open override fun [read]([jvm]read.md)(sink: [Buffer](index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[nonJvm]<br>open override fun [read]([non-jvm]read.md)(sink: [Buffer](index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[common]<br>abstract fun [read](../-source/read.md)(sink: [Buffer](index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Removes at least 1, and up to byteCount bytes from this and appends them to sink. Returns the number of bytes read, or -1 if this source is exhausted.<br>[common]<br>abstract fun [read](../-buffered-source/read.md)(sink: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Removes up to byteCount bytes from this and copies them into sink at offset. Returns the number of bytes read, or -1 if this source is exhausted. |
| readAll | [jvm, nonJvm]<br>[jvm]<br>open override fun [readAll]([jvm]read-all.md)(sink: [Sink](../-sink/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[nonJvm]<br>open override fun [readAll]([non-jvm]read-all.md)(sink: [Sink](../-sink/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[common]<br>abstract fun [readAll](../-buffered-source/read-all.md)(sink: [Sink](../-sink/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Removes all bytes from this and appends them to sink. Returns the total number of bytes written to sink which will be 0 if this is exhausted. |
| [readAndWriteUnsafe](read-and-write-unsafe.md) | [common, jvm, nonJvm]<br>[common, nonJvm]<br>fun [readAndWriteUnsafe](read-and-write-unsafe.md)(unsafeCursor: [Buffer.UnsafeCursor](-unsafe-cursor/index.md) = DEFAULT__new_UnsafeCursor): [Buffer.UnsafeCursor](-unsafe-cursor/index.md)<br>[jvm]<br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)<br>fun [readAndWriteUnsafe](read-and-write-unsafe.md)(unsafeCursor: [Buffer.UnsafeCursor](-unsafe-cursor/index.md) = DEFAULT__new_UnsafeCursor): [Buffer.UnsafeCursor](-unsafe-cursor/index.md) |
| readByte | [jvm, nonJvm]<br>[jvm]<br>open override fun [readByte]([jvm]read-byte.md)(): [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)<br>[nonJvm]<br>open override fun [readByte]([non-jvm]read-byte.md)(): [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)<br>[common]<br>abstract fun [readByte](../-buffered-source/read-byte.md)(): [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)<br>Removes a byte from this source and returns it. |
| readByteArray | [jvm, nonJvm]<br>[jvm]<br>open override fun [readByteArray]([jvm]read-byte-array.md)(): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>[nonJvm]<br>open override fun [readByteArray]([non-jvm]read-byte-array.md)(): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>[jvm]<br>open override fun [readByteArray]([jvm]read-byte-array.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>[nonJvm]<br>open override fun [readByteArray]([non-jvm]read-byte-array.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>[common]<br>abstract fun [readByteArray](../-buffered-source/read-byte-array.md)(): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>Removes all bytes from this and returns them as a byte array.<br>[common]<br>abstract fun [readByteArray](../-buffered-source/read-byte-array.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>Removes byteCount bytes from this and returns them as a byte array. |
| readByteString | [jvm, nonJvm]<br>[jvm]<br>open override fun [readByteString]([jvm]read-byte-string.md)(): [ByteString](../-byte-string/index.md)<br>[nonJvm]<br>open override fun [readByteString]([non-jvm]read-byte-string.md)(): [ByteString](../-byte-string/index.md)<br>[jvm]<br>open override fun [readByteString]([jvm]read-byte-string.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [ByteString](../-byte-string/index.md)<br>[nonJvm]<br>open override fun [readByteString]([non-jvm]read-byte-string.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [ByteString](../-byte-string/index.md)<br>[common]<br>abstract fun [readByteString](../-buffered-source/read-byte-string.md)(): [ByteString](../-byte-string/index.md)<br>Removes all bytes from this and returns them as a byte string.<br>[common]<br>abstract fun [readByteString](../-buffered-source/read-byte-string.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [ByteString](../-byte-string/index.md)<br>Removes byteCount bytes from this and returns them as a byte string. |
| readDecimalLong | [jvm, nonJvm]<br>[jvm]<br>open override fun [readDecimalLong]([jvm]read-decimal-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[nonJvm]<br>open override fun [readDecimalLong]([non-jvm]read-decimal-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[common]<br>abstract fun [readDecimalLong](../-buffered-source/read-decimal-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Reads a long from this source in signed decimal form (i.e., as a string in base 10 with optional leading '-'). This will iterate until a non-digit character is found. |
| [readFrom](read-from.md) | [jvm]<br>fun [readFrom](read-from.md)(input: [InputStream](https://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html)): [Buffer](index.md)<br>Read and exhaust bytes from input into this.<br>[jvm]<br>fun [readFrom](read-from.md)(input: [InputStream](https://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)<br>Read byteCount bytes from input into this. |
| readFully | [jvm, nonJvm]<br>[jvm]<br>open override fun [readFully]([jvm]read-fully.md)(sink: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html))<br>[nonJvm]<br>open override fun [readFully]([non-jvm]read-fully.md)(sink: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html))<br>[jvm]<br>open override fun [readFully]([jvm]read-fully.md)(sink: [Buffer](index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))<br>[nonJvm]<br>open override fun [readFully]([non-jvm]read-fully.md)(sink: [Buffer](index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))<br>[common]<br>abstract fun [readFully](../-buffered-source/read-fully.md)(sink: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html))<br>Removes exactly sink.length bytes from this and copies them into sink. Throws an java.io.EOFException if the requested number of bytes cannot be read.<br>[common]<br>abstract fun [readFully](../-buffered-source/read-fully.md)(sink: [Buffer](index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))<br>Removes exactly byteCount bytes from this and appends them to sink. Throws an java.io.EOFException if the requested number of bytes cannot be read. |
| readHexadecimalUnsignedLong | [jvm, nonJvm]<br>[jvm]<br>open override fun [readHexadecimalUnsignedLong]([jvm]read-hexadecimal-unsigned-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[nonJvm]<br>open override fun [readHexadecimalUnsignedLong]([non-jvm]read-hexadecimal-unsigned-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[common]<br>abstract fun [readHexadecimalUnsignedLong](../-buffered-source/read-hexadecimal-unsigned-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Reads a long form this source in hexadecimal form (i.e., as a string in base 16). This will iterate until a non-hexadecimal character is found. |
| readInt | [jvm, nonJvm]<br>[jvm]<br>open override fun [readInt]([jvm]read-int.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[nonJvm]<br>open override fun [readInt]([non-jvm]read-int.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[common]<br>abstract fun [readInt](../-buffered-source/read-int.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Removes four bytes from this source and returns a big-endian int. |
| readIntLe | [jvm, nonJvm]<br>[jvm]<br>open override fun [readIntLe]([jvm]read-int-le.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[nonJvm]<br>open override fun [readIntLe]([non-jvm]read-int-le.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[common]<br>abstract fun [readIntLe](../-buffered-source/read-int-le.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Removes four bytes from this source and returns a little-endian int. |
| readLong | [jvm, nonJvm]<br>[jvm]<br>open override fun [readLong]([jvm]read-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[nonJvm]<br>open override fun [readLong]([non-jvm]read-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[common]<br>abstract fun [readLong](../-buffered-source/read-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Removes eight bytes from this source and returns a big-endian long. |
| readLongLe | [jvm, nonJvm]<br>[jvm]<br>open override fun [readLongLe]([jvm]read-long-le.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[nonJvm]<br>open override fun [readLongLe]([non-jvm]read-long-le.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[common]<br>abstract fun [readLongLe](../-buffered-source/read-long-le.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Removes eight bytes from this source and returns a little-endian long. |
| readShort | [jvm, nonJvm]<br>[jvm]<br>open override fun [readShort]([jvm]read-short.md)(): [Short](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html)<br>[nonJvm]<br>open override fun [readShort]([non-jvm]read-short.md)(): [Short](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html)<br>[common]<br>abstract fun [readShort](../-buffered-source/read-short.md)(): [Short](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html)<br>Removes two bytes from this source and returns a big-endian short. |
| readShortLe | [jvm, nonJvm]<br>[jvm]<br>open override fun [readShortLe]([jvm]read-short-le.md)(): [Short](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html)<br>[nonJvm]<br>open override fun [readShortLe]([non-jvm]read-short-le.md)(): [Short](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html)<br>[common]<br>abstract fun [readShortLe](../-buffered-source/read-short-le.md)(): [Short](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html)<br>Removes two bytes from this source and returns a little-endian short. |
| [readString](read-string.md) | [jvm]<br>open override fun [readString](read-string.md)(charset: [Charset](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Removes all bytes from this, decodes them as charset, and returns the string.<br>[jvm]<br>open override fun [readString](read-string.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), charset: [Charset](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Removes byteCount bytes from this, decodes them as charset, and returns the string. |
| [readUnsafe](read-unsafe.md) | [common, jvm, nonJvm]<br>[common, nonJvm]<br>fun [readUnsafe](read-unsafe.md)(unsafeCursor: [Buffer.UnsafeCursor](-unsafe-cursor/index.md) = DEFAULT__new_UnsafeCursor): [Buffer.UnsafeCursor](-unsafe-cursor/index.md)<br>[jvm]<br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)<br>fun [readUnsafe](read-unsafe.md)(unsafeCursor: [Buffer.UnsafeCursor](-unsafe-cursor/index.md) = DEFAULT__new_UnsafeCursor): [Buffer.UnsafeCursor](-unsafe-cursor/index.md) |
| readUtf8 | [jvm, nonJvm]<br>[jvm]<br>open override fun [readUtf8]([jvm]read-utf8.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>[nonJvm]<br>open override fun [readUtf8]([non-jvm]read-utf8.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>[jvm]<br>open override fun [readUtf8]([jvm]read-utf8.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>[nonJvm]<br>open override fun [readUtf8]([non-jvm]read-utf8.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>[common]<br>abstract fun [readUtf8](../-buffered-source/read-utf8.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Removes all bytes from this, decodes them as UTF-8, and returns the string. Returns the empty string if this source is empty.<br>[common]<br>abstract fun [readUtf8](../-buffered-source/read-utf8.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Removes byteCount bytes from this, decodes them as UTF-8, and returns the string. |
| readUtf8CodePoint | [jvm, nonJvm]<br>[jvm]<br>open override fun [readUtf8CodePoint]([jvm]read-utf8-code-point.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[nonJvm]<br>open override fun [readUtf8CodePoint]([non-jvm]read-utf8-code-point.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[common]<br>abstract fun [readUtf8CodePoint](../-buffered-source/read-utf8-code-point.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Removes and returns a single UTF-8 code point, reading between 1 and 4 bytes as necessary. |
| readUtf8Line | [jvm, nonJvm]<br>[jvm]<br>open override fun [readUtf8Line]([jvm]read-utf8-line.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?<br>[nonJvm]<br>open override fun [readUtf8Line]([non-jvm]read-utf8-line.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?<br>[common]<br>abstract fun [readUtf8Line](../-buffered-source/read-utf8-line.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?<br>Removes and returns characters up to but not including the next line break. A line break is either "\n" or "\r\n"; these characters are not included in the result. |
| readUtf8LineStrict | [jvm, nonJvm]<br>[jvm]<br>open override fun [readUtf8LineStrict]([jvm]read-utf8-line-strict.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>[nonJvm]<br>open override fun [readUtf8LineStrict]([non-jvm]read-utf8-line-strict.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>[jvm]<br>open override fun [readUtf8LineStrict]([jvm]read-utf8-line-strict.md)(limit: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>[nonJvm]<br>open override fun [readUtf8LineStrict]([non-jvm]read-utf8-line-strict.md)(limit: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>[common]<br>abstract fun [readUtf8LineStrict](../-buffered-source/read-utf8-line-strict.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Removes and returns characters up to but not including the next line break. A line break is either "\n" or "\r\n"; these characters are not included in the result.<br>[common]<br>abstract fun [readUtf8LineStrict](../-buffered-source/read-utf8-line-strict.md)(limit: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Like [readUtf8LineStrict](../-buffered-source/read-utf8-line-strict.md), except this allows the caller to specify the longest allowed match. Use this to protect against streams that may not include "\n" or "\r\n". |
| request | [jvm, nonJvm]<br>[jvm]<br>open override fun [request]([jvm]request.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>[nonJvm]<br>open override fun [request]([non-jvm]request.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>[common]<br>abstract fun [request](../-buffered-source/request.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true when the buffer contains at least byteCount bytes, expanding it as necessary. Returns false if the source is exhausted before the requested bytes can be read. |
| require | [jvm, nonJvm]<br>[jvm]<br>open override fun [require]([jvm]require.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))<br>[nonJvm]<br>open override fun [require]([non-jvm]require.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))<br>[common]<br>abstract fun [require](../-buffered-source/require.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))<br>Returns when the buffer contains at least byteCount bytes. Throws an java.io.EOFException if the source is exhausted before the required bytes can be read. |
| select | [jvm, nonJvm]<br>[jvm]<br>open override fun [select]([jvm]select.md)(options: Options): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[nonJvm]<br>open override fun [select]([non-jvm]select.md)(options: Options): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[common]<br>abstract fun [select](../-buffered-source/select.md)(options: [Options](../-options/index.md)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Finds the first string in options that is a prefix of this buffer, consumes it from this buffer, and returns its index. If no byte string in options is a prefix of this buffer this returns -1 and no bytes are consumed. |
| [sha1](sha1.md) | [common, nonJvm]<br>[common, nonJvm]<br>fun [sha1](sha1.md)(): [ByteString](../-byte-string/index.md)<br>[jvm]<br>fun [sha1](sha1.md)(): [ByteString](../-byte-string/index.md)<br>Returns the 160-bit SHA-1 hash of this buffer. |
| [sha256](sha256.md) | [common, nonJvm]<br>[common, nonJvm]<br>fun [sha256](sha256.md)(): [ByteString](../-byte-string/index.md)<br>[jvm]<br>fun [sha256](sha256.md)(): [ByteString](../-byte-string/index.md)<br>Returns the 256-bit SHA-256 hash of this buffer. |
| [sha512](sha512.md) | [common, nonJvm]<br>[common, nonJvm]<br>fun [sha512](sha512.md)(): [ByteString](../-byte-string/index.md)<br>[jvm]<br>fun [sha512](sha512.md)(): [ByteString](../-byte-string/index.md)<br>Returns the 512-bit SHA-512 hash of this buffer. |
| [skip](skip.md) | [common]<br>open override fun [skip](skip.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))<br>Discards byteCount bytes from the head of this buffer.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>open override fun [skip](skip.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)) |
| [snapshot](snapshot.md) | [common]<br>fun [snapshot](snapshot.md)(): [ByteString](../-byte-string/index.md)<br>Returns an immutable copy of this buffer as a byte string.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>fun [snapshot](snapshot.md)(): [ByteString](../-byte-string/index.md)<br>[jvm, nonJvm]<br>fun [snapshot](snapshot.md)(byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [ByteString](../-byte-string/index.md)<br>[common]<br>fun [snapshot](snapshot.md)(byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [ByteString](../-byte-string/index.md)<br>Returns an immutable copy of the first byteCount bytes of this buffer as a byte string. |
| timeout | [jvm, nonJvm, common]<br>[jvm]<br>open override fun [timeout]([jvm]timeout.md)(): [Timeout](../-timeout/index.md)<br>[nonJvm]<br>open override fun [timeout]([non-jvm]timeout.md)(): [Timeout](../-timeout/index.md)<br>[common]<br>abstract fun [timeout](../-source/timeout.md)(): [Timeout](../-timeout/index.md)<br>Returns the timeout for this source. |
| toString | [jvm, nonJvm]<br>[jvm]<br>open override fun [toString]([jvm]to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>[nonJvm]<br>open override fun [toString]([non-jvm]to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns a human-readable string that describes the contents of this buffer. Typically this is a string like [text=Hello] or [hex=0000ffff]. |
| [write](write.md) | [jvm, nonJvm, common]<br>[jvm]<br>open override fun [write](write.md)(source: [ByteBuffer](https://docs.oracle.com/javase/8/docs/api/java/nio/ByteBuffer.html)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[jvm, nonJvm]<br>open override fun [write](write.md)(source: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [Buffer](index.md)<br>[common, jvm, nonJvm]<br>open override fun [write](write.md)(byteString: [ByteString](../-byte-string/index.md)): [Buffer](index.md)<br>[jvm]<br>open override fun [write]([jvm]write.md)(source: [Buffer](index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))<br>[nonJvm]<br>open override fun [write]([non-jvm]write.md)(source: [Buffer](index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))<br>[jvm]<br>open override fun [write](write.md)(source: [Source](../-source/index.md#1331753033%2FExtensions%2F1033915053), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)<br>[nonJvm]<br>open override fun [write](write.md)(source: Source, byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)<br>[jvm, nonJvm]<br>open override fun [write](write.md)(source: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)<br>[common, jvm, nonJvm]<br>open override fun [write](write.md)(byteString: [ByteString](../-byte-string/index.md), offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)<br>[common]<br>open override fun [write](write.md)(source: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [Buffer](index.md)<br>Like OutputStream.write, this writes a complete byte array to this sink.<br>[common]<br>open override fun [write](write.md)(source: [Source](../-source/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)<br>Removes byteCount bytes from source and appends them to this sink.<br>[common]<br>abstract fun [write](../-sink/write.md)(source: [Buffer](index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))<br>Removes byteCount bytes from source and appends them to this.<br>[common]<br>open override fun [write](write.md)(source: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)<br>Like OutputStream.write, this writes byteCount bytes of source, starting at offset. |
| writeAll | [jvm, nonJvm]<br>[jvm]<br>open override fun [writeAll]([jvm]write-all.md)(source: [Source](../-source/index.md#1331753033%2FExtensions%2F1033915053)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[nonJvm]<br>open override fun [writeAll]([non-jvm]write-all.md)(source: Source): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[common]<br>abstract fun [writeAll](../-buffered-sink/write-all.md)(source: [Source](../-source/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Removes all bytes from source and appends them to this sink. Returns the number of bytes read which will be 0 if source is exhausted. |
| [writeByte](write-byte.md) | [common]<br>open override fun [writeByte](write-byte.md)(b: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)<br>Writes a byte to this sink.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>open override fun [writeByte](write-byte.md)(b: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md) |
| [writeDecimalLong](write-decimal-long.md) | [common]<br>open override fun [writeDecimalLong](write-decimal-long.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)<br>Writes a long to this sink in signed decimal form (i.e., as a string in base 10).<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>open override fun [writeDecimalLong](write-decimal-long.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md) |
| [writeHexadecimalUnsignedLong](write-hexadecimal-unsigned-long.md) | [common]<br>open override fun [writeHexadecimalUnsignedLong](write-hexadecimal-unsigned-long.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)<br>Writes a long to this sink in hexadecimal form (i.e., as a string in base 16).<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>open override fun [writeHexadecimalUnsignedLong](write-hexadecimal-unsigned-long.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md) |
| [writeInt](write-int.md) | [common]<br>open override fun [writeInt](write-int.md)(i: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)<br>Writes a big-endian int to this sink using four bytes.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>open override fun [writeInt](write-int.md)(i: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md) |
| [writeIntLe](write-int-le.md) | [common]<br>open override fun [writeIntLe](write-int-le.md)(i: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)<br>Writes a little-endian int to this sink using four bytes.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>open override fun [writeIntLe](write-int-le.md)(i: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md) |
| [writeLong](write-long.md) | [common]<br>open override fun [writeLong](write-long.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)<br>Writes a big-endian long to this sink using eight bytes.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>open override fun [writeLong](write-long.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md) |
| [writeLongLe](write-long-le.md) | [common]<br>open override fun [writeLongLe](write-long-le.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)<br>Writes a little-endian long to this sink using eight bytes.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>open override fun [writeLongLe](write-long-le.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md) |
| [writeShort](write-short.md) | [common]<br>open override fun [writeShort](write-short.md)(s: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)<br>Writes a big-endian short to this sink using two bytes.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>open override fun [writeShort](write-short.md)(s: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md) |
| [writeShortLe](write-short-le.md) | [common]<br>open override fun [writeShortLe](write-short-le.md)(s: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)<br>Writes a little-endian short to this sink using two bytes.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>open override fun [writeShortLe](write-short-le.md)(s: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md) |
| [writeString](write-string.md) | [jvm]<br>open override fun [writeString](write-string.md)(string: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), charset: [Charset](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)): [Buffer](index.md)<br>open override fun [writeString](write-string.md)(string: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), beginIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), endIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), charset: [Charset](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)): [Buffer](index.md) |
| [writeTo](write-to.md) | [jvm]<br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)<br>fun [writeTo](write-to.md)(out: [OutputStream](https://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) = size): [Buffer](index.md)<br>Write byteCount bytes from this to out. |
| [writeUtf8](write-utf8.md) | [common]<br>open override fun [writeUtf8](write-utf8.md)(string: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Buffer](index.md)<br>Encodes string in UTF-8 and writes it to this sink.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>open override fun [writeUtf8](write-utf8.md)(string: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Buffer](index.md)<br>[jvm, nonJvm]<br>open override fun [writeUtf8](write-utf8.md)(string: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), beginIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), endIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)<br>[common]<br>open override fun [writeUtf8](write-utf8.md)(string: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), beginIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), endIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)<br>Encodes the characters at beginIndex up to endIndex from string in UTF-8 and writes it to this sink. |
| [writeUtf8CodePoint](write-utf8-code-point.md) | [common]<br>open override fun [writeUtf8CodePoint](write-utf8-code-point.md)(codePoint: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)<br>Encodes codePoint in UTF-8 and writes it to this sink.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>open override fun [writeUtf8CodePoint](write-utf8-code-point.md)(codePoint: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md) |

## Properties

| Name | Summary |
|---|---|
| [buffer](buffer.md) | [common]<br>open override val [buffer](buffer.md): [Buffer](index.md)<br>This source's internal buffer.<br>[jvm, nonJvm]<br>open override val [buffer](buffer.md): [Buffer](index.md) |
| [size](size.md) | [common, nonJvm]<br>var [size](size.md): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "size")<br>var [size](size.md): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
