//[okio](../../../index.md)/[okio](../index.md)/[BufferedSource](index.md)/[readLongLe](read-long-le.md)

# readLongLe

[common]\
expect abstract fun [readLongLe](read-long-le.md)(): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)

Removes eight bytes from this source and returns a little-endian long.

```java
Buffer buffer = new Buffer()
    .writeByte(0xff)
    .writeByte(0xff)
    .writeByte(0xff)
    .writeByte(0xff)
    .writeByte(0xff)
    .writeByte(0xff)
    .writeByte(0xff)
    .writeByte(0x7f)
    .writeByte(0x0f)
    .writeByte(0x00)
    .writeByte(0x00)
    .writeByte(0x00)
    .writeByte(0x00)
    .writeByte(0x00)
    .writeByte(0x00)
    .writeByte(0x00);
assertEquals(16, buffer.size());

assertEquals(9223372036854775807L, buffer.readLongLe());
assertEquals(8, buffer.size());

assertEquals(15, buffer.readLongLe());
assertEquals(0, buffer.size());
```

[jvm, nonJvm]\
[jvm, nonJvm]\
actual abstract fun [readLongLe](read-long-le.md)(): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)