//[okio](../../../index.md)/[okio](../index.md)/[Buffer](index.md)/[peek](peek.md)

# peek

[common]\
expect open override fun [peek](peek.md)(): [BufferedSource](../-buffered-source/index.md)

Returns a new `BufferedSource` that can read data from this `BufferedSource` without consuming it. The returned source becomes invalid once this source is next read or closed.

For example, we can use `peek()` to lookahead and read the same data multiple times.

```kotlin
val buffer = Buffer()
buffer.writeUtf8("abcdefghi")

buffer.readUtf8(3) // returns "abc", buffer contains "defghi"

val peek = buffer.peek()
peek.readUtf8(3) // returns "def", buffer contains "defghi"
peek.readUtf8(3) // returns "ghi", buffer contains "defghi"

buffer.readUtf8(3) // returns "def", buffer contains "ghi"
```

[jvm, nonJvm]\
[jvm, nonJvm]\
actual open override fun [peek](peek.md)(): [BufferedSource](../-buffered-source/index.md)