//[okio](../../../index.md)/[okio](../index.md)/[FileMetadata](index.md)

# FileMetadata

[common]\
class [FileMetadata](index.md)(val isRegularFile: [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html) = false, val isDirectory: [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html) = false, val symlinkTarget: [Path](../-path/index.md)? = null, val size: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)? = null, val createdAtMillis: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)? = null, val lastModifiedAtMillis: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)? = null, val lastAccessedAtMillis: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)? = null, extras: [Map](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin.collections/-map/index.html)&lt;[KClass](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;, [Any](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-any/index.html)&gt; = mapOf())

Description of a file or another object referenced by a path.

In simple use a file system is a mechanism for organizing files and directories on a local storage device. In practice file systems are more capable and their contents more varied. For example, a path may refer to:

- 
   An operating system process that consumes data, produces data, or both. For example, reading     from the `/dev/urandom` file on Linux returns a unique sequence of pseudorandom bytes to each     reader.
- 
   A stream that connects a pair of programs together. A pipe is a special file that a producing     program writes to and a consuming program reads from. Both programs operate concurrently. The     size of a pipe is not well defined: the writer can write as much data as the reader is able to     read.
- 
   A file on a remote file system. The performance and availability of remote files may be quite     different from that of local files!
- 
   A symbolic link (symlink) to another path. When attempting to access this path the file system     will follow the link and return data from the target path.
- 
   The same content as another path without a symlink. On UNIX file systems an inode is an     anonymous handle to a file's content, and multiple paths may target the same inode without any     other relationship to one another. A consequence of this design is that a directory with three     1 GiB files may only need 1 GiB on the storage device.

This class does not attempt to model these rich file system features! It exposes a limited view useful for programs with only basic file system needs. Be cautious of the potential consequences of special files when writing programs that operate on a file system.

File metadata is subject to change, and code that operates on file systems should defend against changes to the file that occur between reading metadata and subsequent operations.

## Constructors

| | |
|---|---|
| [FileMetadata](-file-metadata.md) | [common]<br>constructor(isRegularFile: [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html) = false, isDirectory: [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html) = false, symlinkTarget: [Path](../-path/index.md)? = null, size: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)? = null, createdAtMillis: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)? = null, lastModifiedAtMillis: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)? = null, lastAccessedAtMillis: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)? = null, extras: [Map](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin.collections/-map/index.html)&lt;[KClass](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;, [Any](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-any/index.html)&gt; = mapOf()) |

## Properties

| Name | Summary |
|---|---|
| [createdAtMillis](created-at-millis.md) | [common]<br>val [createdAtMillis](created-at-millis.md): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)? = null<br>The system time of the host computer when this file was created, if the host file system supports this feature. This is typically available on Windows NTFS file systems and not available on UNIX or Windows FAT file systems. |
| [extras](extras.md) | [common]<br>val [extras](extras.md): [Map](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin.collections/-map/index.html)&lt;[KClass](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;, [Any](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-any/index.html)&gt;<br>Additional file system-specific metadata organized by the class of that metadata. File systems may use this to include information like permissions, content-type, or linked applications. |
| [isDirectory](is-directory.md) | [common]<br>val [isDirectory](is-directory.md): [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html) = false<br>True if the path refers to a directory that contains 0 or more child paths. |
| [isRegularFile](is-regular-file.md) | [common]<br>val [isRegularFile](is-regular-file.md): [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html) = false<br>True if this file is a container of bytes. If this is true, then [size](size.md) is non-null. |
| [lastAccessedAtMillis](last-accessed-at-millis.md) | [common]<br>val [lastAccessedAtMillis](last-accessed-at-millis.md): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)? = null<br>The system time of the host computer when this file was most recently read or written. |
| [lastModifiedAtMillis](last-modified-at-millis.md) | [common]<br>val [lastModifiedAtMillis](last-modified-at-millis.md): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)? = null<br>The system time of the host computer when this file was most recently written. |
| [size](size.md) | [common]<br>val [size](size.md): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)? = null<br>The number of bytes readable from this file. The amount of storage resources consumed by this file may be larger (due to block size overhead, redundant copies for RAID, etc.), or smaller (due to file system compression, shared inodes, etc). |
| [symlinkTarget](symlink-target.md) | [common]<br>val [symlinkTarget](symlink-target.md): [Path](../-path/index.md)? = null<br>The absolute or relative path that this file is a symlink to, or null if this is not a symlink. If this is a relative path, it is relative to the source file's parent directory. |

## Functions

| Name | Summary |
|---|---|
| [copy](copy.md) | [common]<br>fun [copy](copy.md)(isRegularFile: [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html) = this.isRegularFile, isDirectory: [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html) = this.isDirectory, symlinkTarget: [Path](../-path/index.md)? = this.symlinkTarget, size: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)? = this.size, createdAtMillis: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)? = this.createdAtMillis, lastModifiedAtMillis: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)? = this.lastModifiedAtMillis, lastAccessedAtMillis: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)? = this.lastAccessedAtMillis, extras: [Map](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin.collections/-map/index.html)&lt;[KClass](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;, [Any](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-any/index.html)&gt; = this.extras): [FileMetadata](index.md) |
| [extra](extra.md) | [common]<br>fun &lt;[T](extra.md) : [Any](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-any/index.html)&gt; [extra](extra.md)(type: [KClass](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin.reflect/-k-class/index.html)&lt;out [T](extra.md)&gt;): [T](extra.md)?<br>Returns extra metadata of type [type](extra.md), or null if no such metadata is held. |
| [toString](to-string.md) | [common]<br>open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html) |