/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform.android;

import android.util.Log;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.OkHttpClient;
import okhttp3.internal.SuppressSignatureCheck;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.http2.Http2;
import okhttp3.internal.platform.android.AndroidLogHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0000\u00a2\u0006\u0002\b\u0012J\u0006\u0010\u0013\u001a\u00020\fJ\u0018\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nH\u0002J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lokhttp3/internal/platform/android/AndroidLog;", "", "()V", "MAX_LOG_LENGTH", "", "configuredLoggers", "Ljava/util/concurrent/CopyOnWriteArraySet;", "Ljava/util/logging/Logger;", "knownLoggers", "", "", "androidLog", "", "loggerName", "logLevel", "message", "t", "", "androidLog$okhttp", "enable", "enableLogging", "logger", "tag", "loggerTag", "okhttp"})
@SuppressSignatureCheck
public final class AndroidLog {
    @NotNull
    public static final AndroidLog INSTANCE;
    private static final int MAX_LOG_LENGTH = 4000;
    @NotNull
    private static final CopyOnWriteArraySet<Logger> configuredLoggers;
    @NotNull
    private static final Map<String, String> knownLoggers;

    private AndroidLog() {
    }

    public final void androidLog$okhttp(@NotNull String loggerName, int logLevel, @NotNull String message, @Nullable Throwable t) {
        Intrinsics.checkNotNullParameter((Object)loggerName, (String)"loggerName");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String tag = this.loggerTag(loggerName);
        if (Log.isLoggable((String)tag, (int)logLevel)) {
            String logMessage = message;
            if (t != null) {
                logMessage = logMessage + '\n' + Log.getStackTraceString((Throwable)t);
            }
            int i = 0;
            int length = logMessage.length();
            while (i < length) {
                int end;
                int newline = StringsKt.indexOf$default((CharSequence)logMessage, (char)'\n', (int)i, (boolean)false, (int)4, null);
                newline = newline != -1 ? newline : length;
                do {
                    int n = i + 4000;
                    boolean bl = false;
                    end = Math.min(newline, n);
                    String string = logMessage;
                    bl = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.substring(i, end);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    Log.println((int)logLevel, (String)tag, (String)string3);
                } while ((i = end) < newline);
                int n = i;
                i = n + 1;
            }
        }
    }

    private final String loggerTag(String loggerName) {
        String string = knownLoggers.get(loggerName);
        return string == null ? StringsKt.take((String)loggerName, (int)23) : string;
    }

    public final void enable() {
        Object object = knownLoggers;
        boolean bl = false;
        Iterator<Map.Entry<String, String>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = object = iterator.next();
            boolean bl2 = false;
            String logger = (String)object2.getKey();
            Object object3 = object;
            boolean bl3 = false;
            String tag = (String)object3.getValue();
            this.enableLogging(logger, tag);
        }
    }

    private final void enableLogging(String logger, String tag) {
        Logger logger2 = Logger.getLogger(logger);
        if (configuredLoggers.add(logger2)) {
            logger2.setUseParentHandlers(false);
            logger2.setLevel(Log.isLoggable((String)tag, (int)3) ? Level.FINE : (Log.isLoggable((String)tag, (int)4) ? Level.INFO : Level.WARNING));
            logger2.addHandler(AndroidLogHandler.INSTANCE);
        }
    }

    static {
        String string;
        String packageName;
        INSTANCE = new AndroidLog();
        configuredLoggers = new CopyOnWriteArraySet();
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        boolean bl = false;
        boolean bl2 = false;
        LinkedHashMap $this$knownLoggers_u24lambda_u2d0 = linkedHashMap;
        boolean bl3 = false;
        Object object = OkHttpClient.class.getPackage();
        String string2 = packageName = object == null ? null : ((Package)object).getName();
        if (packageName != null) {
            object = $this$knownLoggers_u24lambda_u2d0;
            string = "OkHttp";
            boolean bl4 = false;
            object.put(packageName, string);
        }
        object = $this$knownLoggers_u24lambda_u2d0;
        string = OkHttpClient.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"OkHttpClient::class.java.name");
        String string3 = "okhttp.OkHttpClient";
        boolean bl5 = false;
        object.put(string, string3);
        object = $this$knownLoggers_u24lambda_u2d0;
        string = Http2.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Http2::class.java.name");
        string3 = "okhttp.Http2";
        bl5 = false;
        object.put(string, string3);
        object = $this$knownLoggers_u24lambda_u2d0;
        string = TaskRunner.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TaskRunner::class.java.name");
        string3 = "okhttp.TaskRunner";
        bl5 = false;
        object.put(string, string3);
        object = $this$knownLoggers_u24lambda_u2d0;
        string = "okhttp3.mockwebserver.MockWebServer";
        string3 = "okhttp.MockWebServer";
        bl5 = false;
        object.put(string, string3);
        knownLoggers = MapsKt.toMap((Map)linkedHashMap);
    }
}

