/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import okhttp3.internal.HostnamesKt;
import okhttp3.internal.tls.CertificateChainCleaner;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 !2\u00020\u0001:\u0003 !\"B\u001f\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J)\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000fH\u0000\u00a2\u0006\u0002\b\u0012J)\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0014\"\u00020\u0015H\u0007\u00a2\u0006\u0002\u0010\u0016J\u001c\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0010J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u001b\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0017\u0010\u001e\u001a\u00020\u00002\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0000\u00a2\u0006\u0002\b\u001fR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lokhttp3/CertificatePinner;", "", "pins", "", "Lokhttp3/CertificatePinner$Pin;", "certificateChainCleaner", "Lokhttp3/internal/tls/CertificateChainCleaner;", "(Ljava/util/Set;Lokhttp3/internal/tls/CertificateChainCleaner;)V", "getCertificateChainCleaner$okhttp", "()Lokhttp3/internal/tls/CertificateChainCleaner;", "check", "", "hostname", "", "cleanedPeerCertificatesFn", "Lkotlin/Function0;", "", "Ljava/security/cert/X509Certificate;", "check$okhttp", "peerCertificates", "", "Ljava/security/cert/Certificate;", "(Ljava/lang/String;[Ljava/security/cert/Certificate;)V", "equals", "", "other", "findMatchingPins", "findMatchingPins$okhttp", "hashCode", "", "withCertificateChainCleaner", "withCertificateChainCleaner$okhttp", "Builder", "Companion", "Pin", "okhttp"})
public final class CertificatePinner {
    private final Set<Pin> pins;
    @Nullable
    private final CertificateChainCleaner certificateChainCleaner;
    @JvmField
    @NotNull
    public static final CertificatePinner DEFAULT;
    public static final Companion Companion;

    public final void check(@NotNull String hostname, @NotNull List<? extends Certificate> peerCertificates) throws SSLPeerUnverifiedException {
        Intrinsics.checkParameterIsNotNull((Object)hostname, (String)"hostname");
        Intrinsics.checkParameterIsNotNull(peerCertificates, (String)"peerCertificates");
        this.check$okhttp(hostname, (Function0<? extends List<? extends X509Certificate>>)((Function0)new Function0<List<? extends X509Certificate>>(this, peerCertificates, hostname){
            final /* synthetic */ CertificatePinner this$0;
            final /* synthetic */ List $peerCertificates;
            final /* synthetic */ String $hostname;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<X509Certificate> invoke() {
                void $this$mapTo$iv$iv;
                Object object = this.this$0.getCertificateChainCleaner$okhttp();
                if (object == null || (object = ((CertificateChainCleaner)object).clean(this.$peerCertificates, this.$hostname)) == null) {
                    object = this.$peerCertificates;
                }
                Iterable $this$map$iv = (Iterable)object;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Certificate certificate = (Certificate)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    void v1 = it;
                    if (v1 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.security.cert.X509Certificate");
                    }
                    X509Certificate x509Certificate = (X509Certificate)v1;
                    collection.add(x509Certificate);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = certificatePinner;
                this.$peerCertificates = list;
                this.$hostname = string;
                super(0);
            }
        }));
    }

    public final void check$okhttp(@NotNull String hostname, @NotNull Function0<? extends List<? extends X509Certificate>> cleanedPeerCertificatesFn) {
        Intrinsics.checkParameterIsNotNull((Object)hostname, (String)"hostname");
        Intrinsics.checkParameterIsNotNull(cleanedPeerCertificatesFn, (String)"cleanedPeerCertificatesFn");
        List<Pin> pins = this.findMatchingPins$okhttp(hostname);
        if (pins.isEmpty()) {
            return;
        }
        List peerCertificates = (List)cleanedPeerCertificatesFn.invoke();
        for (X509Certificate peerCertificate : peerCertificates) {
            ByteString sha1 = null;
            ByteString sha256 = null;
            block9: for (Pin pin : pins) {
                switch (pin.getHashAlgorithm()) {
                    case "sha256/": {
                        if (sha256 == null) {
                            sha256 = Companion.toSha256ByteString$okhttp(peerCertificate);
                        }
                        if (!Intrinsics.areEqual((Object)pin.getHash(), (Object)sha256)) continue block9;
                        return;
                    }
                    case "sha1/": {
                        if (sha1 == null) {
                            sha1 = Companion.toSha1ByteString$okhttp(peerCertificate);
                        }
                        if (!Intrinsics.areEqual((Object)pin.getHash(), (Object)sha1)) continue block9;
                        return;
                    }
                }
                throw (Throwable)((Object)new AssertionError((Object)("unsupported hashAlgorithm: " + pin.getHashAlgorithm())));
            }
        }
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl4 = false;
        $this$buildString.append("Certificate pinning failure!");
        $this$buildString.append("\n  Peer certificate chain:");
        for (X509Certificate element : peerCertificates) {
            $this$buildString.append("\n    ");
            $this$buildString.append(Companion.pin(element));
            $this$buildString.append(": ");
            Principal principal = element.getSubjectDN();
            Intrinsics.checkExpressionValueIsNotNull((Object)principal, (String)"element.subjectDN");
            $this$buildString.append(principal.getName());
        }
        $this$buildString.append("\n  Pinned certificates for ");
        $this$buildString.append(hostname);
        $this$buildString.append(":");
        for (Pin pin : pins) {
            $this$buildString.append("\n    ");
            $this$buildString.append(pin);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String message = string;
        throw (Throwable)new SSLPeerUnverifiedException(message);
    }

    @Deprecated(message="replaced with {@link #check(String, List)}.", replaceWith=@ReplaceWith(imports={}, expression="check(hostname, peerCertificates.toList())"))
    public final void check(@NotNull String hostname, Certificate ... peerCertificates) throws SSLPeerUnverifiedException {
        Intrinsics.checkParameterIsNotNull((Object)hostname, (String)"hostname");
        Intrinsics.checkParameterIsNotNull((Object)peerCertificates, (String)"peerCertificates");
        this.check(hostname, ArraysKt.toList((Object[])peerCertificates));
    }

    @NotNull
    public final List<Pin> findMatchingPins$okhttp(@NotNull String hostname) {
        Intrinsics.checkParameterIsNotNull((Object)hostname, (String)"hostname");
        List result = CollectionsKt.emptyList();
        for (Pin pin : this.pins) {
            if (!pin.matches(hostname)) continue;
            if (result.isEmpty()) {
                boolean bl = false;
                result = new ArrayList();
            }
            List list = result;
            if (list == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableList<okhttp3.CertificatePinner.Pin>");
            }
            TypeIntrinsics.asMutableList((Object)list).add(pin);
        }
        return result;
    }

    @NotNull
    public final CertificatePinner withCertificateChainCleaner$okhttp(@Nullable CertificateChainCleaner certificateChainCleaner) {
        return Intrinsics.areEqual((Object)this.certificateChainCleaner, (Object)certificateChainCleaner) ? this : new CertificatePinner(this.pins, certificateChainCleaner);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof CertificatePinner && Intrinsics.areEqual(((CertificatePinner)other).pins, this.pins) && Intrinsics.areEqual((Object)((CertificatePinner)other).certificateChainCleaner, (Object)this.certificateChainCleaner);
    }

    public int hashCode() {
        int result = 37;
        result = 41 * result + ((Object)this.pins).hashCode();
        CertificateChainCleaner certificateChainCleaner = this.certificateChainCleaner;
        int n = 41 * result;
        boolean bl = false;
        CertificateChainCleaner certificateChainCleaner2 = certificateChainCleaner;
        int n2 = certificateChainCleaner2 != null ? certificateChainCleaner2.hashCode() : 0;
        result = n + n2;
        return result;
    }

    @Nullable
    public final CertificateChainCleaner getCertificateChainCleaner$okhttp() {
        return this.certificateChainCleaner;
    }

    public CertificatePinner(@NotNull Set<Pin> pins, @Nullable CertificateChainCleaner certificateChainCleaner) {
        Intrinsics.checkParameterIsNotNull(pins, (String)"pins");
        this.pins = pins;
        this.certificateChainCleaner = certificateChainCleaner;
    }

    static {
        Companion = new Companion(null);
        DEFAULT = new Builder().build();
    }

    @JvmStatic
    @NotNull
    public static final String pin(@NotNull Certificate certificate) {
        return Companion.pin(certificate);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0080\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0003J\b\u0010\u0017\u001a\u00020\u0003H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lokhttp3/CertificatePinner$Pin;", "", "pattern", "", "hashAlgorithm", "hash", "Lokio/ByteString;", "(Ljava/lang/String;Ljava/lang/String;Lokio/ByteString;)V", "getHash", "()Lokio/ByteString;", "getHashAlgorithm", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "matches", "hostname", "toString", "okhttp"})
    public static final class Pin {
        private final String pattern;
        @NotNull
        private final String hashAlgorithm;
        @NotNull
        private final ByteString hash;

        public final boolean matches(@NotNull String hostname) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)hostname, (String)"hostname");
            if (StringsKt.startsWith$default((String)this.pattern, (String)"**.", (boolean)false, (int)2, null)) {
                int suffixLength = this.pattern.length() - 3;
                int prefixLength = hostname.length() - suffixLength;
                bl = StringsKt.regionMatches$default((String)hostname, (int)(hostname.length() - suffixLength), (String)this.pattern, (int)3, (int)suffixLength, (boolean)false, (int)16, null) && (prefixLength == 0 || hostname.charAt(prefixLength - 1) == '.');
            } else if (StringsKt.startsWith$default((String)this.pattern, (String)"*.", (boolean)false, (int)2, null)) {
                int suffixLength = this.pattern.length() - 1;
                int prefixLength = hostname.length() - suffixLength;
                bl = StringsKt.regionMatches$default((String)hostname, (int)(hostname.length() - suffixLength), (String)this.pattern, (int)1, (int)suffixLength, (boolean)false, (int)16, null) && StringsKt.lastIndexOf$default((CharSequence)hostname, (char)'.', (int)(prefixLength - 1), (boolean)false, (int)4, null) == -1;
            } else {
                bl = Intrinsics.areEqual((Object)hostname, (Object)this.pattern);
            }
            return bl;
        }

        @NotNull
        public String toString() {
            return this.hashAlgorithm + this.hash.base64();
        }

        @NotNull
        public final String getHashAlgorithm() {
            return this.hashAlgorithm;
        }

        @NotNull
        public final ByteString getHash() {
            return this.hash;
        }

        public Pin(@NotNull String pattern, @NotNull String hashAlgorithm, @NotNull ByteString hash) {
            Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
            Intrinsics.checkParameterIsNotNull((Object)hashAlgorithm, (String)"hashAlgorithm");
            Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
            this.pattern = pattern;
            this.hashAlgorithm = hashAlgorithm;
            this.hash = hash;
        }

        private final String component1() {
            return this.pattern;
        }

        @NotNull
        public final String component2() {
            return this.hashAlgorithm;
        }

        @NotNull
        public final ByteString component3() {
            return this.hash;
        }

        @NotNull
        public final Pin copy(@NotNull String pattern, @NotNull String hashAlgorithm, @NotNull ByteString hash) {
            Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
            Intrinsics.checkParameterIsNotNull((Object)hashAlgorithm, (String)"hashAlgorithm");
            Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
            return new Pin(pattern, hashAlgorithm, hash);
        }

        public static /* synthetic */ Pin copy$default(Pin pin, String string, String string2, ByteString byteString, int n, Object object) {
            if ((n & 1) != 0) {
                string = pin.pattern;
            }
            if ((n & 2) != 0) {
                string2 = pin.hashAlgorithm;
            }
            if ((n & 4) != 0) {
                byteString = pin.hash;
            }
            return pin.copy(string, string2, byteString);
        }

        public int hashCode() {
            String string = this.pattern;
            String string2 = this.hashAlgorithm;
            ByteString byteString = this.hash;
            return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (byteString != null ? byteString.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Pin)) break block3;
                    Pin pin = (Pin)object;
                    if (!Intrinsics.areEqual((Object)this.pattern, (Object)pin.pattern) || !Intrinsics.areEqual((Object)this.hashAlgorithm, (Object)pin.hashAlgorithm) || !Intrinsics.areEqual((Object)this.hash, (Object)pin.hash)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\t\"\u00020\b\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000b\u001a\u00020\fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lokhttp3/CertificatePinner$Builder;", "", "()V", "pins", "", "Lokhttp3/CertificatePinner$Pin;", "add", "pattern", "", "", "(Ljava/lang/String;[Ljava/lang/String;)Lokhttp3/CertificatePinner$Builder;", "build", "Lokhttp3/CertificatePinner;", "okhttp"})
    public static final class Builder {
        private final List<Pin> pins;

        @NotNull
        public final Builder add(@NotNull String pattern, String ... pins) {
            Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
            Intrinsics.checkParameterIsNotNull((Object)pins, (String)"pins");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            for (String pin : pins) {
                $this$apply.pins.add(Companion.newPin$okhttp(pattern, pin));
            }
            return builder;
        }

        @NotNull
        public final CertificatePinner build() {
            return new CertificatePinner(CollectionsKt.toSet((Iterable)this.pins), null);
        }

        public Builder() {
            List list;
            Builder builder = this;
            boolean bl = false;
            builder.pins = list = (List)new ArrayList();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\nJ\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0011\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u0011\u0010\u0011\u001a\u00020\u000e*\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0012R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lokhttp3/CertificatePinner$Companion;", "", "()V", "DEFAULT", "Lokhttp3/CertificatePinner;", "newPin", "Lokhttp3/CertificatePinner$Pin;", "pattern", "", "pin", "newPin$okhttp", "certificate", "Ljava/security/cert/Certificate;", "toSha1ByteString", "Lokio/ByteString;", "Ljava/security/cert/X509Certificate;", "toSha1ByteString$okhttp", "toSha256ByteString", "toSha256ByteString$okhttp", "okhttp"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final String pin(@NotNull Certificate certificate) {
            Intrinsics.checkParameterIsNotNull((Object)certificate, (String)"certificate");
            boolean bl = certificate instanceof X509Certificate;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Certificate pinning requires X509 certificates";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            return "sha256/" + this.toSha256ByteString$okhttp((X509Certificate)certificate).base64();
        }

        @NotNull
        public final ByteString toSha1ByteString$okhttp(@NotNull X509Certificate $this$toSha1ByteString) {
            Intrinsics.checkParameterIsNotNull((Object)$this$toSha1ByteString, (String)"$this$toSha1ByteString");
            PublicKey publicKey = $this$toSha1ByteString.getPublicKey();
            Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"publicKey");
            byte[] byArray = publicKey.getEncoded();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"publicKey.encoded");
            return ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])byArray, (int)0, (int)0, (int)3, null).sha1();
        }

        @NotNull
        public final ByteString toSha256ByteString$okhttp(@NotNull X509Certificate $this$toSha256ByteString) {
            Intrinsics.checkParameterIsNotNull((Object)$this$toSha256ByteString, (String)"$this$toSha256ByteString");
            PublicKey publicKey = $this$toSha256ByteString.getPublicKey();
            Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"publicKey");
            byte[] byArray = publicKey.getEncoded();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"publicKey.encoded");
            return ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])byArray, (int)0, (int)0, (int)3, null).sha256();
        }

        @NotNull
        public final Pin newPin$okhttp(@NotNull String pattern, @NotNull String pin) {
            Pin pin2;
            Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
            Intrinsics.checkParameterIsNotNull((Object)pin, (String)"pin");
            boolean bl = StringsKt.startsWith$default((String)pattern, (String)"*.", (boolean)false, (int)2, null) && StringsKt.indexOf$default((CharSequence)pattern, (String)"*", (int)1, (boolean)false, (int)4, null) == -1 || StringsKt.startsWith$default((String)pattern, (String)"**.", (boolean)false, (int)2, null) && StringsKt.indexOf$default((CharSequence)pattern, (String)"*", (int)2, (boolean)false, (int)4, null) == -1 || StringsKt.indexOf$default((CharSequence)pattern, (String)"*", (int)0, (boolean)false, (int)6, null) == -1;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Unexpected pattern: " + pattern;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            String string = HostnamesKt.toCanonicalHost(pattern);
            if (string == null) {
                throw (Throwable)new IllegalArgumentException("Invalid pattern: " + pattern);
            }
            String canonicalPattern = string;
            if (StringsKt.startsWith$default((String)pin, (String)"sha1/", (boolean)false, (int)2, null)) {
                String string2 = pin;
                int n = "sha1/".length();
                ByteString.Companion companion = ByteString.Companion;
                boolean bl5 = false;
                String string3 = string2.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                String string4 = string3;
                ByteString byteString = companion.decodeBase64(string4);
                if (byteString == null) {
                    Intrinsics.throwNpe();
                }
                ByteString hash = byteString;
                pin2 = new Pin(canonicalPattern, "sha1/", hash);
            } else if (StringsKt.startsWith$default((String)pin, (String)"sha256/", (boolean)false, (int)2, null)) {
                String string5 = pin;
                int n = "sha256/".length();
                ByteString.Companion companion = ByteString.Companion;
                boolean bl6 = false;
                String string6 = string5.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
                String string7 = string6;
                ByteString byteString = companion.decodeBase64(string7);
                if (byteString == null) {
                    Intrinsics.throwNpe();
                }
                ByteString hash = byteString;
                pin2 = new Pin(canonicalPattern, "sha256/", hash);
            } else {
                throw (Throwable)new IllegalArgumentException("pins must start with 'sha256/' or 'sha1/': " + pin);
            }
            return pin2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

