/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import okhttp3.internal.io.FileSystem;
import okio.Buffer;
import okio.ForwardingSink;
import okio.ForwardingSource;
import okio.Sink;
import okio.Source;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class InMemoryFileSystem
implements FileSystem,
TestRule {
    private final Map<File, Buffer> files = new LinkedHashMap<File, Buffer>();
    private final Map<Source, File> openSources = new IdentityHashMap<Source, File>();
    private final Map<Sink, File> openSinks = new IdentityHashMap<Sink, File>();

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                base.evaluate();
                InMemoryFileSystem.this.ensureResourcesClosed();
            }
        };
    }

    public void ensureResourcesClosed() {
        ArrayList<String> openResources = new ArrayList<String>();
        for (File file : this.openSources.values()) {
            openResources.add("Source for " + file);
        }
        for (File file : this.openSinks.values()) {
            openResources.add("Sink for " + file);
        }
        if (!openResources.isEmpty()) {
            StringBuilder builder = new StringBuilder("Resources acquired but not closed:");
            for (String resource : openResources) {
                builder.append("\n * ").append(resource);
            }
            throw new IllegalStateException(builder.toString());
        }
    }

    public Source source(File file) throws FileNotFoundException {
        Buffer result = this.files.get(file);
        if (result == null) {
            throw new FileNotFoundException();
        }
        Buffer source = result.clone();
        this.openSources.put((Source)source, file);
        return new ForwardingSource((Source)source, (Source)source){
            final /* synthetic */ Source val$source;
            {
                this.val$source = source;
                super(x0);
            }

            public void close() throws IOException {
                InMemoryFileSystem.this.openSources.remove(this.val$source);
                super.close();
            }
        };
    }

    public Sink sink(File file) throws FileNotFoundException {
        return this.sink(file, false);
    }

    public Sink appendingSink(File file) throws FileNotFoundException {
        return this.sink(file, true);
    }

    private Sink sink(File file, boolean appending) {
        Buffer result = null;
        if (appending) {
            result = this.files.get(file);
        }
        if (result == null) {
            result = new Buffer();
        }
        this.files.put(file, result);
        Buffer sink = result;
        this.openSinks.put((Sink)sink, file);
        return new ForwardingSink((Sink)sink, (Sink)sink){
            final /* synthetic */ Sink val$sink;
            {
                this.val$sink = sink;
                super(x0);
            }

            public void close() throws IOException {
                InMemoryFileSystem.this.openSinks.remove(this.val$sink);
                super.close();
            }
        };
    }

    public void delete(File file) throws IOException {
        this.files.remove(file);
    }

    public boolean exists(File file) {
        return this.files.containsKey(file);
    }

    public long size(File file) {
        Buffer buffer = this.files.get(file);
        return buffer != null ? buffer.size() : 0L;
    }

    public void rename(File from, File to) throws IOException {
        Buffer buffer = this.files.remove(from);
        if (buffer == null) {
            throw new FileNotFoundException();
        }
        this.files.put(to, buffer);
    }

    public void deleteContents(File directory) throws IOException {
        String prefix = directory.toString() + "/";
        Iterator<File> i = this.files.keySet().iterator();
        while (i.hasNext()) {
            File file = i.next();
            if (!file.toString().startsWith(prefix)) continue;
            i.remove();
        }
    }
}

