/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.spotify.docker.client.messages.swarm.AutoValue_Service;
import com.spotify.docker.client.messages.swarm.AutoValue_Service_Criteria;
import com.spotify.docker.client.messages.swarm.Endpoint;
import com.spotify.docker.client.messages.swarm.ServiceSpec;
import com.spotify.docker.client.messages.swarm.UpdateStatus;
import com.spotify.docker.client.messages.swarm.Version;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nullable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public abstract class Service {
    @JsonProperty(value="ID")
    public abstract String id();

    @JsonProperty(value="Version")
    public abstract Version version();

    @JsonProperty(value="CreatedAt")
    public abstract Date createdAt();

    @JsonProperty(value="UpdatedAt")
    public abstract Date updatedAt();

    @JsonProperty(value="Spec")
    public abstract ServiceSpec spec();

    @JsonProperty(value="Endpoint")
    public abstract Endpoint endpoint();

    @JsonProperty(value="UpdateStatus")
    @Nullable
    public abstract UpdateStatus updateStatus();

    public static Criteria.Builder find() {
        return Criteria.builder();
    }

    @JsonCreator
    static Service create(@JsonProperty(value="ID") String id, @JsonProperty(value="Version") Version version, @JsonProperty(value="CreatedAt") Date createdAt, @JsonProperty(value="UpdatedAt") Date updatedAt, @JsonProperty(value="Spec") ServiceSpec spec, @JsonProperty(value="Endpoint") Endpoint endpoint, @JsonProperty(value="UpdateStatus") UpdateStatus updateStatus) {
        return new AutoValue_Service(id, version, createdAt, updatedAt, spec, endpoint, updateStatus);
    }

    public static abstract class Criteria {
        @Nullable
        public abstract String serviceId();

        @Nullable
        public abstract String serviceName();

        @Nullable
        public abstract ImmutableMap<String, String> labels();

        public static Builder builder() {
            return new AutoValue_Service_Criteria.Builder();
        }

        public static abstract class Builder {
            public abstract Builder serviceId(String var1);

            @Deprecated
            public Builder withServiceId(String serviceId) {
                this.serviceId(serviceId);
                return this;
            }

            public abstract Builder serviceName(String var1);

            @Deprecated
            public Builder withServiceName(String serviceName) {
                this.serviceName(serviceName);
                return this;
            }

            public abstract Builder labels(Map<String, String> var1);

            abstract ImmutableMap.Builder<String, String> labelsBuilder();

            public Builder addLabel(String label, String value) {
                this.labelsBuilder().put((Object)label, (Object)value);
                return this;
            }

            public abstract Criteria build();
        }
    }
}

