/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.exceptions;

import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.shaded.javax.annotation.Nullable;
import java.net.URI;

public class DockerRequestException
extends DockerException {
    private final String method;
    private final URI uri;
    private final int status;
    private final String responseBody;

    public DockerRequestException(String method, URI uri, int status, String responseBody, Throwable cause) {
        super("Request error: " + method + " " + uri + ": " + status + (responseBody != null ? ", body: " + responseBody : ""), cause);
        this.method = method;
        this.uri = uri;
        this.status = status;
        this.responseBody = responseBody;
    }

    public String method() {
        return this.method;
    }

    public URI uri() {
        return this.uri;
    }

    public int status() {
        return this.status;
    }

    @Deprecated
    @Nullable
    public String message() {
        return this.responseBody;
    }

    @Nullable
    public String getResponseBody() {
        return this.responseBody;
    }
}

