/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.spotify.docker.client.messages.swarm.EndpointSpec;
import com.spotify.docker.client.messages.swarm.NetworkAttachmentConfig;
import com.spotify.docker.client.messages.swarm.ServiceMode;
import com.spotify.docker.client.messages.swarm.ServiceSpec;
import com.spotify.docker.client.messages.swarm.TaskSpec;
import com.spotify.docker.client.messages.swarm.UpdateConfig;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

final class AutoValue_ServiceSpec
extends ServiceSpec {
    private final String name;
    private final ImmutableMap<String, String> labels;
    private final TaskSpec taskTemplate;
    private final ServiceMode mode;
    private final UpdateConfig updateConfig;
    private final ImmutableList<NetworkAttachmentConfig> networks;
    private final EndpointSpec endpointSpec;

    private AutoValue_ServiceSpec(@Nullable String name, @Nullable ImmutableMap<String, String> labels, TaskSpec taskTemplate, @Nullable ServiceMode mode, @Nullable UpdateConfig updateConfig, @Nullable ImmutableList<NetworkAttachmentConfig> networks, @Nullable EndpointSpec endpointSpec) {
        this.name = name;
        this.labels = labels;
        this.taskTemplate = taskTemplate;
        this.mode = mode;
        this.updateConfig = updateConfig;
        this.networks = networks;
        this.endpointSpec = endpointSpec;
    }

    @Override
    @Nullable
    @JsonProperty(value="Name")
    public String name() {
        return this.name;
    }

    @Override
    @Nullable
    @JsonProperty(value="Labels")
    public ImmutableMap<String, String> labels() {
        return this.labels;
    }

    @Override
    @JsonProperty(value="TaskTemplate")
    public TaskSpec taskTemplate() {
        return this.taskTemplate;
    }

    @Override
    @Nullable
    @JsonProperty(value="Mode")
    public ServiceMode mode() {
        return this.mode;
    }

    @Override
    @Nullable
    @JsonProperty(value="UpdateConfig")
    public UpdateConfig updateConfig() {
        return this.updateConfig;
    }

    @Override
    @Nullable
    @JsonProperty(value="Networks")
    public ImmutableList<NetworkAttachmentConfig> networks() {
        return this.networks;
    }

    @Override
    @Nullable
    @JsonProperty(value="EndpointSpec")
    public EndpointSpec endpointSpec() {
        return this.endpointSpec;
    }

    public String toString() {
        return "ServiceSpec{name=" + this.name + ", labels=" + this.labels + ", taskTemplate=" + this.taskTemplate + ", mode=" + this.mode + ", updateConfig=" + this.updateConfig + ", networks=" + this.networks + ", endpointSpec=" + this.endpointSpec + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ServiceSpec) {
            ServiceSpec that = (ServiceSpec)o;
            return (this.name == null ? that.name() == null : this.name.equals(that.name())) && (this.labels == null ? that.labels() == null : this.labels.equals(that.labels())) && this.taskTemplate.equals(that.taskTemplate()) && (this.mode == null ? that.mode() == null : this.mode.equals(that.mode())) && (this.updateConfig == null ? that.updateConfig() == null : this.updateConfig.equals(that.updateConfig())) && (this.networks == null ? that.networks() == null : this.networks.equals(that.networks())) && (this.endpointSpec == null ? that.endpointSpec() == null : this.endpointSpec.equals(that.endpointSpec()));
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.name == null ? 0 : this.name.hashCode();
        h *= 1000003;
        h ^= this.labels == null ? 0 : this.labels.hashCode();
        h *= 1000003;
        h ^= this.taskTemplate.hashCode();
        h *= 1000003;
        h ^= this.mode == null ? 0 : this.mode.hashCode();
        h *= 1000003;
        h ^= this.updateConfig == null ? 0 : this.updateConfig.hashCode();
        h *= 1000003;
        h ^= this.networks == null ? 0 : this.networks.hashCode();
        h *= 1000003;
        return h ^= this.endpointSpec == null ? 0 : this.endpointSpec.hashCode();
    }

    static final class Builder
    extends ServiceSpec.Builder {
        private String name;
        private ImmutableMap.Builder<String, String> labelsBuilder$;
        private ImmutableMap<String, String> labels;
        private TaskSpec taskTemplate;
        private ServiceMode mode;
        private UpdateConfig updateConfig;
        private ImmutableList<NetworkAttachmentConfig> networks;
        private EndpointSpec endpointSpec;

        Builder() {
            this.labels = ImmutableMap.of();
        }

        Builder(ServiceSpec source) {
            this.name = source.name();
            this.labels = source.labels();
            this.taskTemplate = source.taskTemplate();
            this.mode = source.mode();
            this.updateConfig = source.updateConfig();
            this.networks = source.networks();
            this.endpointSpec = source.endpointSpec();
        }

        @Override
        public ServiceSpec.Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @Override
        public ServiceSpec.Builder labels(@Nullable Map<String, String> labels) {
            if (this.labelsBuilder$ != null) {
                throw new IllegalStateException("Cannot set labels after calling labelsBuilder()");
            }
            this.labels = labels == null ? null : ImmutableMap.copyOf(labels);
            return this;
        }

        @Override
        public ImmutableMap.Builder<String, String> labelsBuilder() {
            if (this.labelsBuilder$ == null) {
                this.labelsBuilder$ = ImmutableMap.builder();
                this.labelsBuilder$.putAll(this.labels);
                this.labels = null;
            }
            return this.labelsBuilder$;
        }

        @Override
        public ServiceSpec.Builder taskTemplate(TaskSpec taskTemplate) {
            this.taskTemplate = taskTemplate;
            return this;
        }

        @Override
        public ServiceSpec.Builder mode(@Nullable ServiceMode mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public ServiceSpec.Builder updateConfig(@Nullable UpdateConfig updateConfig) {
            this.updateConfig = updateConfig;
            return this;
        }

        @Override
        public ServiceSpec.Builder networks(NetworkAttachmentConfig ... networks) {
            this.networks = networks == null ? null : ImmutableList.copyOf((Object[])networks);
            return this;
        }

        @Override
        public ServiceSpec.Builder networks(@Nullable List<NetworkAttachmentConfig> networks) {
            this.networks = networks == null ? null : ImmutableList.copyOf(networks);
            return this;
        }

        @Override
        public ServiceSpec.Builder endpointSpec(@Nullable EndpointSpec endpointSpec) {
            this.endpointSpec = endpointSpec;
            return this;
        }

        @Override
        public ServiceSpec build() {
            if (this.labelsBuilder$ != null) {
                this.labels = this.labelsBuilder$.build();
            }
            String missing = "";
            if (this.taskTemplate == null) {
                missing = missing + " taskTemplate";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ServiceSpec(this.name, this.labels, this.taskTemplate, this.mode, this.updateConfig, this.networks, this.endpointSpec);
        }
    }
}

