/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.spotify.docker.client.DockerException;
import com.spotify.docker.client.EventStream;
import com.spotify.docker.client.LogStream;
import com.spotify.docker.client.ProgressHandler;
import com.spotify.docker.client.messages.AuthConfig;
import com.spotify.docker.client.messages.Container;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerCreation;
import com.spotify.docker.client.messages.ContainerExit;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.ContainerStats;
import com.spotify.docker.client.messages.ExecState;
import com.spotify.docker.client.messages.Image;
import com.spotify.docker.client.messages.ImageInfo;
import com.spotify.docker.client.messages.ImageSearchResult;
import com.spotify.docker.client.messages.Info;
import com.spotify.docker.client.messages.Network;
import com.spotify.docker.client.messages.NetworkConfig;
import com.spotify.docker.client.messages.NetworkCreation;
import com.spotify.docker.client.messages.RemovedImage;
import com.spotify.docker.client.messages.Version;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;

public interface DockerClient
extends Closeable {
    public String ping() throws DockerException, InterruptedException;

    public Version version() throws DockerException, InterruptedException;

    public int auth(AuthConfig var1) throws DockerException, InterruptedException;

    public Info info() throws DockerException, InterruptedException;

    public List<Container> listContainers(ListContainersParam ... var1) throws DockerException, InterruptedException;

    public List<Image> listImages(ListImagesParam ... var1) throws DockerException, InterruptedException;

    public ContainerInfo inspectContainer(String var1) throws DockerException, InterruptedException;

    public ContainerCreation commitContainer(String var1, String var2, String var3, ContainerConfig var4, String var5, String var6) throws DockerException, InterruptedException;

    public ImageInfo inspectImage(String var1) throws DockerException, InterruptedException;

    public List<RemovedImage> removeImage(String var1) throws DockerException, InterruptedException;

    public List<RemovedImage> removeImage(String var1, boolean var2, boolean var3) throws DockerException, InterruptedException;

    public List<ImageSearchResult> searchImages(String var1) throws DockerException, InterruptedException;

    public void load(String var1, InputStream var2) throws DockerException, InterruptedException;

    public void load(String var1, InputStream var2, ProgressHandler var3) throws DockerException, InterruptedException;

    public void load(String var1, InputStream var2, AuthConfig var3) throws DockerException, InterruptedException;

    public void load(String var1, InputStream var2, AuthConfig var3, ProgressHandler var4) throws DockerException, InterruptedException;

    public InputStream save(String var1) throws DockerException, IOException, InterruptedException;

    public InputStream save(String var1, AuthConfig var2) throws DockerException, IOException, InterruptedException;

    public void pull(String var1) throws DockerException, InterruptedException;

    public void pull(String var1, ProgressHandler var2) throws DockerException, InterruptedException;

    public void pull(String var1, AuthConfig var2) throws DockerException, InterruptedException;

    public void pull(String var1, AuthConfig var2, ProgressHandler var3) throws DockerException, InterruptedException;

    public void push(String var1) throws DockerException, InterruptedException;

    public void push(String var1, ProgressHandler var2) throws DockerException, InterruptedException;

    public void tag(String var1, String var2) throws DockerException, InterruptedException;

    public void tag(String var1, String var2, boolean var3) throws DockerException, InterruptedException;

    public String build(Path var1, BuildParam ... var2) throws DockerException, InterruptedException, IOException;

    public String build(Path var1, String var2, BuildParam ... var3) throws DockerException, InterruptedException, IOException;

    public String build(Path var1, ProgressHandler var2, BuildParam ... var3) throws DockerException, InterruptedException, IOException;

    public String build(Path var1, String var2, ProgressHandler var3, BuildParam ... var4) throws DockerException, InterruptedException, IOException;

    public String build(Path var1, String var2, String var3, ProgressHandler var4, BuildParam ... var5) throws DockerException, InterruptedException, IOException;

    public ContainerCreation createContainer(ContainerConfig var1) throws DockerException, InterruptedException;

    public ContainerCreation createContainer(ContainerConfig var1, String var2) throws DockerException, InterruptedException;

    public void startContainer(String var1) throws DockerException, InterruptedException;

    public void stopContainer(String var1, int var2) throws DockerException, InterruptedException;

    public void pauseContainer(String var1) throws DockerException, InterruptedException;

    public void unpauseContainer(String var1) throws DockerException, InterruptedException;

    public void restartContainer(String var1) throws DockerException, InterruptedException;

    public void restartContainer(String var1, int var2) throws DockerException, InterruptedException;

    public ContainerExit waitContainer(String var1) throws DockerException, InterruptedException;

    public void killContainer(String var1) throws DockerException, InterruptedException;

    public void removeContainer(String var1) throws DockerException, InterruptedException;

    public void removeContainer(String var1, boolean var2) throws DockerException, InterruptedException;

    public InputStream exportContainer(String var1) throws DockerException, InterruptedException;

    public InputStream copyContainer(String var1, String var2) throws DockerException, InterruptedException;

    public void copyToContainer(Path var1, String var2, String var3) throws DockerException, InterruptedException, IOException;

    public LogStream logs(String var1, LogsParam ... var2) throws DockerException, InterruptedException;

    public EventStream events(EventsParam ... var1) throws DockerException, InterruptedException;

    public String execCreate(String var1, String[] var2, ExecCreateParam ... var3) throws DockerException, InterruptedException;

    public LogStream execStart(String var1, ExecStartParameter ... var2) throws DockerException, InterruptedException;

    public ExecState execInspect(String var1) throws DockerException, InterruptedException;

    public ContainerStats stats(String var1) throws DockerException, InterruptedException;

    public List<Network> listNetworks() throws DockerException, InterruptedException;

    public Network inspectNetwork(String var1) throws DockerException, InterruptedException;

    public NetworkCreation createNetwork(NetworkConfig var1) throws DockerException, InterruptedException;

    public void removeNetwork(String var1) throws DockerException, InterruptedException;

    public void connectToNetwork(String var1, String var2) throws DockerException, InterruptedException;

    public void disconnectFromNetwork(String var1, String var2) throws DockerException, InterruptedException;

    @Override
    public void close();

    public LogStream attachContainer(String var1, AttachParameter ... var2) throws DockerException, InterruptedException;

    public String getHost();

    public static class EventsFilterParam
    extends EventsParam {
        public EventsFilterParam(String name, String value) {
            super(name, value);
        }
    }

    public static class EventsParam {
        private final String name;
        private final String value;

        protected EventsParam(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public static EventsParam until(Long until) {
            return new EventsParam("until", String.valueOf(until));
        }

        public static EventsParam since(Long since) {
            return new EventsParam("since", String.valueOf(since));
        }

        public static EventsParam filter(String name, String value) {
            return new EventsFilterParam(name, value);
        }
    }

    public static class ListImagesFilterParam
    extends ListImagesParam {
        public ListImagesFilterParam(String name, String value) {
            super(name, value);
        }
    }

    public static class ListImagesParam {
        private final String name;
        private final String value;

        public ListImagesParam(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public static ListImagesParam allImages() {
            return ListImagesParam.allImages(true);
        }

        public static ListImagesParam allImages(boolean all) {
            return ListImagesParam.create("all", String.valueOf(all));
        }

        public static ListImagesParam danglingImages() {
            return ListImagesParam.danglingImages(true);
        }

        public static ListImagesParam danglingImages(boolean dangling) {
            return ListImagesParam.filter("dangling", String.valueOf(dangling));
        }

        public static ListImagesParam filter(String name, String value) {
            return new ListImagesFilterParam(name, value);
        }

        public static ListImagesParam withLabel(String key, String value) {
            if (Strings.isNullOrEmpty((String)value)) {
                return ListImagesParam.withLabel((Map<String, String>)ImmutableMap.of((Object)key, (Object)""));
            }
            return ListImagesParam.withLabel((Map<String, String>)ImmutableMap.of((Object)key, (Object)value));
        }

        public static ListImagesParam withLabel(String key) {
            return ListImagesParam.withLabel(key, null);
        }

        public static ListImagesParam withLabel(Map<String, String> labels) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, String> kvPair : labels.entrySet()) {
                if (Strings.isNullOrEmpty((String)kvPair.getKey())) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append("\"").append(kvPair.getKey());
                if (!Strings.isNullOrEmpty((String)kvPair.getValue())) {
                    stringBuilder.append("=").append(kvPair.getValue());
                }
                stringBuilder.append("\"");
            }
            String filter = "{\"label\":[" + stringBuilder.toString() + "]}";
            try {
                return ListImagesParam.create("filters", URLEncoder.encode(filter, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public static ListImagesParam create(String name, String value) {
            return new ListImagesParam(name, value);
        }
    }

    public static class ListContainersParam {
        private final String name;
        private final String value;

        public ListContainersParam(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public static ListContainersParam allContainers() {
            return ListContainersParam.allContainers(true);
        }

        public static ListContainersParam allContainers(boolean all) {
            return ListContainersParam.create("all", all ? "1" : "0");
        }

        public static ListContainersParam exitedContainers() {
            try {
                return ListContainersParam.create("filters", URLEncoder.encode("{\"status\":[\"exited\"]}", "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public static ListContainersParam limitContainers(Integer limit) {
            return ListContainersParam.create("limit", String.valueOf(limit));
        }

        public static ListContainersParam containersCreatedSince(String id) {
            return ListContainersParam.create("since", String.valueOf(id));
        }

        public static ListContainersParam containersCreatedBefore(String id) {
            return ListContainersParam.create("before", String.valueOf(id));
        }

        public static ListContainersParam withContainerSizes(Boolean size) {
            return ListContainersParam.create("size", String.valueOf(size));
        }

        public static ListContainersParam withLabel(String key, String value) {
            try {
                if (Strings.isNullOrEmpty((String)value)) {
                    return ListContainersParam.create("filters", URLEncoder.encode("{\"label\":[\"" + key + "\"]}", "UTF-8"));
                }
                return ListContainersParam.create("filters", URLEncoder.encode("{\"label\":[\"" + key + '=' + value + "\"]}", "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public static ListContainersParam withLabel(String key) {
            return ListContainersParam.withLabel(key, null);
        }

        public static ListContainersParam create(String name, String value) {
            return new ListContainersParam(name, value);
        }
    }

    public static enum AttachParameter {
        LOGS,
        STREAM,
        STDIN,
        STDOUT,
        STDERR;

    }

    public static class LogsParam {
        private final String name;
        private final String value;

        public LogsParam(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public static LogsParam follow() {
            return LogsParam.follow(true);
        }

        public static LogsParam follow(boolean follow) {
            return LogsParam.create("follow", String.valueOf(follow));
        }

        public static LogsParam stdout() {
            return LogsParam.stdout(true);
        }

        public static LogsParam stdout(boolean stdout) {
            return LogsParam.create("stdout", String.valueOf(stdout));
        }

        public static LogsParam stderr() {
            return LogsParam.stderr(true);
        }

        public static LogsParam stderr(boolean stderr) {
            return LogsParam.create("stderr", String.valueOf(stderr));
        }

        public static LogsParam since(Integer timestamp) {
            return LogsParam.create("since", String.valueOf(timestamp));
        }

        public static LogsParam timestamps() {
            return LogsParam.timestamps(true);
        }

        public static LogsParam timestamps(boolean timestamps) {
            return LogsParam.create("timestamps", String.valueOf(timestamps));
        }

        public static LogsParam tail(Integer lines) {
            return LogsParam.create("tail", String.valueOf(lines));
        }

        public static LogsParam create(String name, String value) {
            return new LogsParam(name, value);
        }
    }

    public static class ExecCreateParam {
        private final String name;
        private final String value;

        private ExecCreateParam(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        private static ExecCreateParam create(String name, String value) {
            return new ExecCreateParam(name, value);
        }

        public static ExecCreateParam detach(boolean detach) {
            return ExecCreateParam.create("Detach", String.valueOf(detach));
        }

        public static ExecCreateParam detach() {
            return ExecCreateParam.detach(true);
        }

        public static ExecCreateParam attachStdin(boolean attachStdin) {
            return ExecCreateParam.create("AttachStdin", String.valueOf(attachStdin));
        }

        public static ExecCreateParam attachStdin() {
            return ExecCreateParam.attachStdin(true);
        }

        public static ExecCreateParam attachStderr(boolean attachStderr) {
            return ExecCreateParam.create("AttachStderr", String.valueOf(attachStderr));
        }

        public static ExecCreateParam attachStderr() {
            return ExecCreateParam.attachStderr(true);
        }

        public static ExecCreateParam attachStdout(boolean attachStdout) {
            return ExecCreateParam.create("AttachStdout", String.valueOf(attachStdout));
        }

        public static ExecCreateParam attachStdout() {
            return ExecCreateParam.attachStdout(true);
        }

        public static ExecCreateParam privileged(boolean privileged) {
            return ExecCreateParam.create("Privileged", String.valueOf(privileged));
        }

        public static ExecCreateParam privileged() {
            return ExecCreateParam.privileged(true);
        }

        public static ExecCreateParam tty(boolean tty) {
            return ExecCreateParam.create("Tty", String.valueOf(tty));
        }

        public static ExecCreateParam tty() {
            return ExecCreateParam.tty(true);
        }

        public static ExecCreateParam user(String user) {
            return ExecCreateParam.create("User", user);
        }
    }

    public static enum ExecStartParameter {
        DETACH("Detach"),
        TTY("Tty");

        private final String name;

        private ExecStartParameter(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class BuildParam {
        private final String name;
        private final String value;

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public BuildParam(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public static BuildParam create(String name, String value) {
            return new BuildParam(name, value);
        }

        public static BuildParam quiet() {
            return BuildParam.create("q", "true");
        }

        public static BuildParam rm() {
            return BuildParam.rm(true);
        }

        public static BuildParam rm(boolean rm) {
            return BuildParam.create("rm", String.valueOf(rm));
        }

        public static BuildParam noCache() {
            return BuildParam.create("nocache", "true");
        }

        public static BuildParam forceRm() {
            return BuildParam.create("forcerm", "true");
        }

        public static BuildParam pullNewerImage() {
            return BuildParam.create("pull", "true");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BuildParam that = (BuildParam)o;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            return !(this.value == null ? that.value != null : !this.value.equals(that.value));
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }
    }
}

