/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms.impl;

import com.solacesystems.jcsmp.Consumer;
import com.solacesystems.jcsmp.ConsumerFlowProperties;
import com.solacesystems.jcsmp.EndpointProperties;
import com.solacesystems.jcsmp.FlowEventHandler;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.XMLMessageListener;
import com.solacesystems.jms.impl.JCSMPTransactedSession;
import com.solacesystems.jms.impl.JCSMPXASession;
import com.solacesystems.jms.impl.SessionProperties;
import com.solacesystems.jms.impl.SessionTransactionType;

public abstract class JCSMPConsumerFactory {
    public static final JCSMPConsumerFactory standard = new Standard();
    public static final JCSMPConsumerFactory connectionConsumer = new ConnectionConsumer();

    public abstract Consumer createDurableJCSMPConsumer(SessionProperties var1, XMLMessageListener var2, ConsumerFlowProperties var3) throws JCSMPException;

    public abstract Consumer createNonDurableJCSMPConsumer(SessionProperties var1, XMLMessageListener var2, ConsumerFlowProperties var3, EndpointProperties var4) throws JCSMPException;

    public abstract Consumer createDurableJCSMPConsumer(SessionProperties var1, XMLMessageListener var2, FlowEventHandler var3, ConsumerFlowProperties var4) throws JCSMPException;

    public abstract Consumer createNonDurableJCSMPConsumer(SessionProperties var1, XMLMessageListener var2, FlowEventHandler var3, ConsumerFlowProperties var4, EndpointProperties var5) throws JCSMPException;

    private static class ConnectionConsumer
    extends JCSMPConsumerFactory {
        private ConnectionConsumer() {
        }

        @Override
        public Consumer createDurableJCSMPConsumer(SessionProperties props, XMLMessageListener listener, ConsumerFlowProperties flowProps) throws JCSMPException {
            return this.createDurableJCSMPConsumer(props, listener, null, flowProps);
        }

        @Override
        public Consumer createDurableJCSMPConsumer(SessionProperties props, XMLMessageListener listener, FlowEventHandler flowEventHandler, ConsumerFlowProperties flowProps) throws JCSMPException {
            return props.getConnectionProperties().getJCSMPSession().createFlow(listener, flowProps, null, flowEventHandler);
        }

        @Override
        public Consumer createNonDurableJCSMPConsumer(SessionProperties props, XMLMessageListener listener, ConsumerFlowProperties flowProps, EndpointProperties endpointProps) throws JCSMPException {
            return this.createNonDurableJCSMPConsumer(props, listener, null, flowProps, endpointProps);
        }

        @Override
        public Consumer createNonDurableJCSMPConsumer(SessionProperties props, XMLMessageListener listener, FlowEventHandler flowEventHandler, ConsumerFlowProperties flowProps, EndpointProperties endpointProps) throws JCSMPException {
            return props.getConnectionProperties().getJCSMPSession().createFlow(listener, flowProps, endpointProps, flowEventHandler);
        }
    }

    private static class Standard
    extends JCSMPConsumerFactory {
        private Standard() {
        }

        @Override
        public Consumer createDurableJCSMPConsumer(SessionProperties props, XMLMessageListener listener, ConsumerFlowProperties flowProps) throws JCSMPException {
            return this.createDurableJCSMPConsumer(props, listener, null, flowProps);
        }

        @Override
        public Consumer createDurableJCSMPConsumer(SessionProperties props, XMLMessageListener listener, FlowEventHandler flowEventHandler, ConsumerFlowProperties flowProps) throws JCSMPException {
            if (props.getTransactionType() == SessionTransactionType.XATransaction) {
                JCSMPXASession xaSession = (JCSMPXASession)props.getUserProperties().get("XASession");
                if (flowEventHandler != null) {
                    return xaSession.getJCSMPXASession().createFlow(listener, flowProps, null, flowEventHandler);
                }
                return xaSession.getJCSMPXASession().createFlow(listener, flowProps, null);
            }
            if (props.getTransactionType() == SessionTransactionType.LocalTransaction) {
                JCSMPTransactedSession txSession = (JCSMPTransactedSession)props.getUserProperties().get("TransactedSession");
                if (flowEventHandler != null) {
                    return txSession.getJCSMPTransactedSession().createFlow(listener, flowProps, null, flowEventHandler);
                }
                return txSession.getJCSMPTransactedSession().createFlow(listener, flowProps, null);
            }
            if (flowEventHandler != null) {
                return props.getConnectionProperties().getJCSMPSession().createFlow(listener, flowProps, null, flowEventHandler);
            }
            return props.getConnectionProperties().getJCSMPSession().createFlow(listener, flowProps, null);
        }

        @Override
        public Consumer createNonDurableJCSMPConsumer(SessionProperties props, XMLMessageListener listener, ConsumerFlowProperties flowProps, EndpointProperties endpointProps) throws JCSMPException {
            return this.createNonDurableJCSMPConsumer(props, listener, null, flowProps, endpointProps);
        }

        @Override
        public Consumer createNonDurableJCSMPConsumer(SessionProperties props, XMLMessageListener listener, FlowEventHandler flowEventHandler, ConsumerFlowProperties flowProps, EndpointProperties endpointProps) throws JCSMPException {
            if (props.getTransactionType() == SessionTransactionType.XATransaction) {
                JCSMPXASession xaSession = (JCSMPXASession)props.getUserProperties().get("XASession");
                if (flowEventHandler != null) {
                    return xaSession.getJCSMPXASession().createFlow(listener, flowProps, endpointProps, flowEventHandler);
                }
                return xaSession.getJCSMPXASession().createFlow(listener, flowProps, endpointProps);
            }
            if (props.getTransactionType() == SessionTransactionType.LocalTransaction) {
                JCSMPTransactedSession txSession = (JCSMPTransactedSession)props.getUserProperties().get("TransactedSession");
                if (flowEventHandler != null) {
                    return txSession.getJCSMPTransactedSession().createFlow(listener, flowProps, endpointProps, flowEventHandler);
                }
                return txSession.getJCSMPTransactedSession().createFlow(listener, flowProps, endpointProps);
            }
            if (flowEventHandler != null) {
                return props.getConnectionProperties().getJCSMPSession().createFlow(listener, flowProps, endpointProps, flowEventHandler);
            }
            return props.getConnectionProperties().getJCSMPSession().createFlow(listener, flowProps, endpointProps);
        }
    }
}

