/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms.encoding;

import com.solace.messaging.trace.propagation.Baggage;
import com.solace.messaging.trace.propagation.TraceContext;
import com.solace.messaging.trace.propagation.impl.TraceContextImpl;
import com.solacesystems.common.util.UTF8Util;
import com.solacesystems.jcsmp.BytesMessage;
import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.DeliveryMode;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.MapMessage;
import com.solacesystems.jcsmp.SDTException;
import com.solacesystems.jcsmp.SDTMap;
import com.solacesystems.jcsmp.StreamMessage;
import com.solacesystems.jcsmp.TextMessage;
import com.solacesystems.jcsmp.XMLContentMessage;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessage;
import com.solacesystems.jcsmp.impl.MessageImpl;
import com.solacesystems.jcsmp.impl.MessageTracingUtil;
import com.solacesystems.jcsmp.impl.sdt.MapImpl;
import com.solacesystems.jms.SolDestination;
import com.solacesystems.jms.encoding.JMSEncoder;
import com.solacesystems.jms.impl.MessageProducerAdapter;
import com.solacesystems.jms.impl.Validator;
import com.solacesystems.jms.message.BytesMessageIF;
import com.solacesystems.jms.message.MapMessageIF;
import com.solacesystems.jms.message.ObjectMessageIF;
import com.solacesystems.jms.message.SolMessage;
import com.solacesystems.jms.message.StreamMessageIF;
import com.solacesystems.jms.message.TextMessageIF;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;

public class DefaultJMSEncoder
implements JMSEncoder {
    private static final JMSEncoder onlyInstance = new DefaultJMSEncoder();

    public static DefaultJMSEncoder getInstance() {
        return (DefaultJMSEncoder)onlyInstance;
    }

    private DefaultJMSEncoder() {
    }

    @Override
    public BytesXMLMessage encode(MessageProducerAdapter producer, Message jmsMessage, boolean isXML, boolean isDTO, boolean useDirectMessaging, boolean isDMQEligible, long timeToLive, boolean isElidingEligible, boolean isReplyMsg) throws JCSMPException, JMSException {
        BytesXMLMessage jcsmpMessage;
        DeliveryMode deliveryMode = DeliveryMode.NON_PERSISTENT;
        if (jmsMessage.getJMSDeliveryMode() == 2) {
            deliveryMode = DeliveryMode.PERSISTENT;
        }
        if (jmsMessage instanceof BytesMessageIF) {
            if (DefaultJMSEncoder.propertiesSpecified(jmsMessage, timeToLive)) {
                jcsmpMessage = producer.createBytesMessage(deliveryMode);
                DefaultJMSEncoder.encode((BytesMessageIF)jmsMessage, (BytesMessage)jcsmpMessage, isDTO, useDirectMessaging, isDMQEligible, timeToLive, isElidingEligible, isReplyMsg);
            } else {
                jcsmpMessage = producer.createBytesXMLMessage(deliveryMode);
                DefaultJMSEncoder.encode((BytesMessageIF)jmsMessage, jcsmpMessage, isDTO, useDirectMessaging, isDMQEligible, timeToLive, isElidingEligible, isReplyMsg);
            }
        } else if (jmsMessage instanceof MapMessageIF) {
            jcsmpMessage = producer.createMapMessage(deliveryMode);
            DefaultJMSEncoder.encode((MapMessageIF)jmsMessage, jcsmpMessage, isDTO, useDirectMessaging, isDMQEligible, timeToLive, isElidingEligible, isReplyMsg);
        } else if (jmsMessage instanceof ObjectMessageIF) {
            jcsmpMessage = producer.createBytesMessage(deliveryMode);
            DefaultJMSEncoder.encode((ObjectMessageIF)jmsMessage, (BytesMessage)jcsmpMessage, isDTO, useDirectMessaging, isDMQEligible, timeToLive, isElidingEligible, isReplyMsg);
        } else if (jmsMessage instanceof StreamMessageIF) {
            jcsmpMessage = producer.createStreamMessage(deliveryMode);
            DefaultJMSEncoder.encode((StreamMessageIF)jmsMessage, (StreamMessage)jcsmpMessage, isDTO, useDirectMessaging, isDMQEligible, timeToLive, isElidingEligible, isReplyMsg);
        } else if (jmsMessage instanceof TextMessageIF) {
            if (isXML) {
                if (DefaultJMSEncoder.propertiesSpecified(jmsMessage, timeToLive)) {
                    jcsmpMessage = producer.createXMLContentMessage(deliveryMode);
                    DefaultJMSEncoder.encode((TextMessageIF)jmsMessage, (XMLContentMessage)jcsmpMessage, isDTO, useDirectMessaging, isDMQEligible, timeToLive, isElidingEligible, isReplyMsg);
                } else {
                    jcsmpMessage = producer.createBytesXMLMessage(deliveryMode);
                    DefaultJMSEncoder.encode((TextMessageIF)jmsMessage, jcsmpMessage, isDTO, useDirectMessaging, isDMQEligible, timeToLive, isElidingEligible, isReplyMsg);
                }
            } else {
                jcsmpMessage = producer.createTextMessage(deliveryMode);
                DefaultJMSEncoder.encode((TextMessageIF)jmsMessage, (TextMessage)jcsmpMessage, isDTO, useDirectMessaging, isDMQEligible, timeToLive, isElidingEligible, isReplyMsg);
            }
        } else {
            jcsmpMessage = producer.createBytesMessage(deliveryMode);
            DefaultJMSEncoder.encode(jmsMessage, (BytesMessage)jcsmpMessage, isDTO, useDirectMessaging, isDMQEligible, timeToLive, isElidingEligible, isReplyMsg);
        }
        DefaultJMSEncoder.encodeTracing(jmsMessage, jcsmpMessage);
        return jcsmpMessage;
    }

    private static void encodeTracing(Message jmsMessage, BytesXMLMessage jcsmpMessage) {
        SolMessage solMsg = (SolMessage)jmsMessage;
        TraceContext transportContext = solMsg.transportContext();
        TraceContext creationContext = solMsg.creationContext();
        Baggage baggage = solMsg.baggage();
        if (jcsmpMessage instanceof MessageImpl) {
            MessageImpl targetJcsmpMsg = (MessageImpl)jcsmpMessage;
            if (creationContext != null) {
                MessageTracingUtil.injectCreationContext(targetJcsmpMsg, (TraceContextImpl)creationContext);
            }
            if (transportContext != null) {
                MessageTracingUtil.injectTransportContext(targetJcsmpMsg, (TraceContextImpl)transportContext);
            }
            if (solMsg.baggage() != null) {
                MessageTracingUtil.injectBaggage(targetJcsmpMsg, baggage);
            }
        } else if (jcsmpMessage instanceof JCSMPXMLMessage) {
            JCSMPXMLMessage targetJcsmpMsg = (JCSMPXMLMessage)((Object)jcsmpMessage);
            if (creationContext != null) {
                MessageTracingUtil.injectCreationContext(targetJcsmpMsg, (TraceContextImpl)creationContext);
            }
            if (transportContext != null) {
                MessageTracingUtil.injectTransportContext(targetJcsmpMsg, (TraceContextImpl)transportContext);
            }
            if (solMsg.baggage() != null) {
                MessageTracingUtil.injectBaggage(targetJcsmpMsg, baggage);
            }
        }
    }

    public BytesXMLMessage encodeExistingJCSMPMessage(SolMessage solMsg) throws JMSException, JCSMPException {
        BytesXMLMessage jcsmpMessage = solMsg.getMessage();
        boolean useDirectMessaging = jcsmpMessage.getDeliveryMode() == DeliveryMode.DIRECT;
        boolean isDTO = solMsg.isDTO() == null ? false : solMsg.isDTO();
        boolean isDMQEligible = solMsg.isDMQEligible() == null ? false : solMsg.isDMQEligible();
        long timeToLive = jcsmpMessage.getTimeToLive();
        boolean isElidingEligible = solMsg.isElidingEligible() == null ? false : solMsg.isElidingEligible();
        boolean isReplyMsg = solMsg.isReplyMsg() == null ? false : solMsg.isReplyMsg();
        jcsmpMessage.resetPayload();
        if (solMsg instanceof BytesMessageIF) {
            if (DefaultJMSEncoder.propertiesSpecified(solMsg, timeToLive)) {
                DefaultJMSEncoder.encode((BytesMessageIF)((Object)solMsg), (BytesMessage)jcsmpMessage, isDTO, useDirectMessaging, isDMQEligible, timeToLive, isElidingEligible, isReplyMsg);
            } else {
                DefaultJMSEncoder.encode((BytesMessageIF)((Object)solMsg), jcsmpMessage, isDTO, useDirectMessaging, isDMQEligible, timeToLive, isElidingEligible, isReplyMsg);
            }
        } else if (solMsg instanceof MapMessageIF) {
            DefaultJMSEncoder.encode((MapMessageIF)((Object)solMsg), (MapMessage)jcsmpMessage, isDTO, useDirectMessaging, isDMQEligible, timeToLive, isElidingEligible, isReplyMsg);
        } else if (solMsg instanceof ObjectMessageIF) {
            DefaultJMSEncoder.encode((ObjectMessageIF)((Object)solMsg), (BytesMessage)jcsmpMessage, isDTO, useDirectMessaging, isDMQEligible, timeToLive, isElidingEligible, isReplyMsg);
        } else if (solMsg instanceof StreamMessageIF) {
            DefaultJMSEncoder.encode((StreamMessageIF)((Object)solMsg), (StreamMessage)jcsmpMessage, isDTO, useDirectMessaging, isDMQEligible, timeToLive, isElidingEligible, isReplyMsg);
        } else if (solMsg instanceof TextMessageIF) {
            if (solMsg.isXML().booleanValue() || jcsmpMessage instanceof XMLContentMessage) {
                if (jcsmpMessage instanceof XMLContentMessage) {
                    DefaultJMSEncoder.encode((TextMessageIF)((Object)solMsg), (XMLContentMessage)jcsmpMessage, isDTO, useDirectMessaging, isDMQEligible, timeToLive, isElidingEligible, isReplyMsg);
                } else {
                    DefaultJMSEncoder.encode((TextMessageIF)((Object)solMsg), jcsmpMessage, isDTO, useDirectMessaging, isDMQEligible, timeToLive, isElidingEligible, isReplyMsg);
                }
            } else {
                DefaultJMSEncoder.encode((TextMessageIF)((Object)solMsg), (TextMessage)jcsmpMessage, isDTO, useDirectMessaging, isDMQEligible, timeToLive, isElidingEligible, isReplyMsg);
            }
        } else {
            DefaultJMSEncoder.encode((Message)solMsg, (BytesMessage)jcsmpMessage, isDTO, useDirectMessaging, isDMQEligible, timeToLive, isElidingEligible, isReplyMsg);
        }
        return jcsmpMessage;
    }

    private static void encode(BytesMessageIF jmsMessage, BytesXMLMessage jcsmpMessage, boolean isDTO, boolean useDirectMessaging, boolean isDMQEligible, long timeToLive, boolean isElidingEligible, boolean isReplyMsg) throws JMSException {
        DefaultJMSEncoder.encodeSMF((Message)jmsMessage, jcsmpMessage, isDTO, useDirectMessaging, isDMQEligible, timeToLive, isElidingEligible, isReplyMsg);
        byte[] data = jmsMessage.getBackingArray();
        if (data != null) {
            jcsmpMessage.writeAttachment(data, 0, jmsMessage.getBackingArrayLength());
        }
    }

    private static void encode(BytesMessageIF jmsMessage, BytesMessage jcsmpMessage, boolean isDTO, boolean useDirectMessaging, boolean isDMQEligible, long timeToLive, boolean isElidingEligible, boolean isReplyMsg) throws JMSException {
        DefaultJMSEncoder.encode((Message)jmsMessage, (BytesXMLMessage)jcsmpMessage, isDTO, useDirectMessaging, isDMQEligible, timeToLive, isElidingEligible, isReplyMsg);
        byte[] data = jmsMessage.getBackingArray();
        if (data != null) {
            jcsmpMessage.writeAttachment(data, 0, jmsMessage.getBackingArrayLength());
        }
        jcsmpMessage.setStructuredMsg(false);
        jcsmpMessage.setStructuredMsgType((byte)2);
    }

    private static void encode(MapMessageIF jmsMessage, MapMessage jcsmpMessage, boolean isDTO, boolean useDirectMessaging, boolean isDMQEligible, long timeToLive, boolean isElidingEligible, boolean isReplyMsg) throws JMSException {
        DefaultJMSEncoder.encode((Message)jmsMessage, (BytesXMLMessage)jcsmpMessage, isDTO, useDirectMessaging, isDMQEligible, timeToLive, isElidingEligible, isReplyMsg);
        jcsmpMessage.setMap(jmsMessage.getMap());
    }

    private static void encode(ObjectMessageIF jmsMessage, BytesMessage jcsmpMessage, boolean isDTO, boolean useDirectMessaging, boolean isDMQEligible, long timeToLive, boolean isElidingEligible, boolean isReplyMsg) throws JMSException {
        DefaultJMSEncoder.encode((Message)jmsMessage, (BytesXMLMessage)jcsmpMessage, isDTO, useDirectMessaging, isDMQEligible, timeToLive, isElidingEligible, isReplyMsg);
        byte[] data = jmsMessage.getSerializedObject();
        if (data != null) {
            jcsmpMessage.writeAttachment(data);
        }
        jcsmpMessage.setStructuredMsg(false);
        jcsmpMessage.setStructuredMsgType((byte)3);
    }

    private static void encode(StreamMessageIF jmsMessage, StreamMessage jcsmpMessage, boolean isDTO, boolean useDirectMessaging, boolean isDMQEligible, long timeToLive, boolean isElidingEligible, boolean isReplyMsg) throws JMSException {
        DefaultJMSEncoder.encode((Message)jmsMessage, (BytesXMLMessage)jcsmpMessage, isDTO, useDirectMessaging, isDMQEligible, timeToLive, isElidingEligible, isReplyMsg);
        jcsmpMessage.setStream(jmsMessage.getStream());
    }

    private static void encode(TextMessageIF jmsMessage, TextMessage jcsmpMessage, boolean isDTO, boolean useDirectMessaging, boolean isDMQEligible, long timeToLive, boolean isElidingEligible, boolean isReplyMsg) throws JMSException {
        DefaultJMSEncoder.encode((Message)jmsMessage, (BytesXMLMessage)jcsmpMessage, isDTO, useDirectMessaging, isDMQEligible, timeToLive, isElidingEligible, isReplyMsg);
        jcsmpMessage.setText(jmsMessage.getText());
    }

    private static void encode(TextMessageIF jmsMessage, XMLContentMessage jcsmpMessage, boolean isDTO, boolean useDirectMessaging, boolean isDMQEligible, long timeToLive, boolean isElidingEligible, boolean isReplyMsg) throws JMSException {
        DefaultJMSEncoder.encode((Message)jmsMessage, (BytesXMLMessage)jcsmpMessage, isDTO, useDirectMessaging, isDMQEligible, timeToLive, isElidingEligible, isReplyMsg);
        String text = jmsMessage.getText();
        if (text != null) {
            jcsmpMessage.setXMLContent(text);
        }
    }

    private static void encode(TextMessageIF jmsMessage, BytesXMLMessage jcsmpMessage, boolean isDTO, boolean useDirectMessaging, boolean isDMQEligible, long timeToLive, boolean isElidingEligible, boolean isReplyMsg) throws JMSException {
        DefaultJMSEncoder.encodeSMF((Message)jmsMessage, jcsmpMessage, isDTO, useDirectMessaging, isDMQEligible, timeToLive, isElidingEligible, isReplyMsg);
        String text = jmsMessage.getText();
        if (text != null) {
            jcsmpMessage.writeBytes(UTF8Util.toUTF8(text));
        }
    }

    private static void encode(Message jmsMessage, BytesMessage jcsmpMessage, boolean isDTO, boolean useDirectMessaging, boolean isDMQEligible, long timeToLive, boolean isElidingEligible, boolean isReplyMsg) throws JMSException {
        DefaultJMSEncoder.encode(jmsMessage, (BytesXMLMessage)jcsmpMessage, isDTO, useDirectMessaging, isDMQEligible, timeToLive, isElidingEligible, isReplyMsg);
        jcsmpMessage.setStructuredMsg(false);
        jcsmpMessage.setStructuredMsgType((byte)4);
    }

    private static void encode(Message jmsMessage, BytesXMLMessage jcsmpMessage, boolean isDTO, boolean useDirectMessaging, boolean isDMQEligible, long timeToLive, boolean isElidingEligible, boolean isReplyMsg) throws JMSException {
        DefaultJMSEncoder.encodeSMF(jmsMessage, jcsmpMessage, isDTO, useDirectMessaging, isDMQEligible, timeToLive, isElidingEligible, isReplyMsg);
        DefaultJMSEncoder.encodeBinaryMeta(jmsMessage, jcsmpMessage, timeToLive);
    }

    private static void encodeSMF(Message jmsMessage, BytesXMLMessage jcsmpMessage, boolean isDTO, boolean useDirectMessaging, boolean isDMQEligible, long timeToLive, boolean isElidingEligible, boolean isReplyMsg) throws JMSException {
        if (jmsMessage.getJMSDeliveryMode() == 1) {
            if (useDirectMessaging) {
                jcsmpMessage.setDeliveryMode(DeliveryMode.DIRECT);
            } else {
                jcsmpMessage.setDeliveryMode(DeliveryMode.NON_PERSISTENT);
            }
        } else {
            jcsmpMessage.setDeliveryMode(DeliveryMode.PERSISTENT);
        }
        jcsmpMessage.setDeliverToOne(isDTO);
        jcsmpMessage.setDMQEligible(isDMQEligible);
        jcsmpMessage.setElidingEligible(isElidingEligible);
        jcsmpMessage.setPriority(jmsMessage.getJMSPriority());
        jcsmpMessage.setAsReplyMessage(isReplyMsg);
        if (timeToLive > 0L) {
            jcsmpMessage.setTimeToLive(timeToLive);
        }
    }

    private static void encodeBinaryMeta(Message jmsMessage, BytesXMLMessage jcsmpMessage, long timeToLive) throws JMSException {
        Map<String, Object> jmsProps;
        SolMessage solMsg;
        if (jmsMessage.getJMSCorrelationID() != null) {
            jcsmpMessage.setCorrelationId(jmsMessage.getJMSCorrelationID());
        }
        if (jmsMessage.getJMSMessageID() != null) {
            jcsmpMessage.setAppMessageID(jmsMessage.getJMSMessageID());
        }
        if (jmsMessage.getJMSReplyTo() != null) {
            jcsmpMessage.setReplyTo(((SolDestination)jmsMessage.getJMSReplyTo()).getJCSMPDestination());
        }
        if (jmsMessage.getJMSTimestamp() > 0L) {
            jcsmpMessage.setSendTimestamp(jmsMessage.getJMSTimestamp());
        }
        if (jmsMessage.getJMSType() != null) {
            jcsmpMessage.setAppMessageType(jmsMessage.getJMSType());
        }
        if (timeToLive == 0L && jmsMessage.getJMSExpiration() > 0L) {
            jcsmpMessage.setExpiration(jmsMessage.getJMSExpiration());
        }
        if ((solMsg = (SolMessage)jmsMessage).getHTTPContentType() != null) {
            jcsmpMessage.setHTTPContentType(solMsg.getHTTPContentType());
        }
        if (solMsg.getHTTPContentEncoding() != null) {
            jcsmpMessage.setHTTPContentEncoding(solMsg.getHTTPContentEncoding());
        }
        if (solMsg.getSenderID() != null) {
            jcsmpMessage.setSenderId(solMsg.getSenderID());
        }
        if ((jmsProps = solMsg.getProperties()) != null && jmsProps.size() > 0) {
            SDTMap propMap = jcsmpMessage.getProperties();
            if (propMap == null) {
                propMap = new MapImpl();
                jcsmpMessage.setProperties(propMap);
            }
            for (Map.Entry<String, Object> entry : jmsProps.entrySet()) {
                try {
                    propMap.putObject(entry.getKey(), entry.getValue());
                }
                catch (SDTException e) {
                    throw Validator.createJMSException("soljms.operation.send", e);
                }
            }
        }
    }

    private static boolean propertiesSpecified(Message jmsMessage, long timeToLive) throws JMSException {
        SolMessage solMsg = (SolMessage)jmsMessage;
        return solMsg.getProperties() != null && solMsg.getProperties().size() > 0 || jmsMessage.getJMSCorrelationID() != null || jmsMessage.getJMSMessageID() != null || jmsMessage.getJMSReplyTo() != null || jmsMessage.getJMSTimestamp() > 0L || jmsMessage.getJMSType() != null || timeToLive == 0L && jmsMessage.getJMSExpiration() > 0L || solMsg.getHTTPContentEncoding() != null || solMsg.getHTTPContentType() != null;
    }
}

