/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms;

import com.solacesystems.common.util.LogWrapper;
import com.solacesystems.jcsmp.Queue;
import com.solacesystems.jms.SolConnectionIF;
import com.solacesystems.jms.SolMessageConsumerIF;
import com.solacesystems.jms.SolTemporaryQueueIF;
import com.solacesystems.jms.impl.SolJMSErrorMessages;
import com.solacesystems.jms.impl.SolQueueImpl;
import com.solacesystems.jms.impl.Validator;
import java.util.LinkedList;
import java.util.List;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;

public class SolTemporaryQueue
extends SolQueueImpl
implements SolTemporaryQueueIF {
    private static final long serialVersionUID = -7067623658417046471L;
    private static final LogWrapper log = new LogWrapper(SolTemporaryQueue.class);
    private transient SolConnectionIF mConnection;
    private boolean mDeleted;
    private final List<SolMessageConsumerIF> mConsumers;

    public SolTemporaryQueue(Queue queue) {
        super(queue);
        this.mConnection = null;
        this.mDeleted = false;
        this.mConsumers = new LinkedList<SolMessageConsumerIF>();
    }

    public SolTemporaryQueue(SolConnectionIF connection, Queue queue) {
        super(queue);
        this.mConnection = connection;
        this.mDeleted = false;
        this.mConsumers = new LinkedList<SolMessageConsumerIF>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug("Entering delete.  Queue: " + this.getQueueName());
        }
        if (!this.mDeleted) {
            Validator.checkDeleteTempDestination(this, this.mConnection);
            List<SolMessageConsumerIF> list = this.mConsumers;
            synchronized (list) {
                for (int i = 0; i < this.mConsumers.size(); ++i) {
                    if (!this.mConsumers.get(i).isTemporaryQueueUsed(this)) continue;
                    throw new IllegalStateException(SolJMSErrorMessages.getMessage("soljms.operation.temp.destination.delete", "soljms.error.tempdestination.inuse", null), "soljms.error.tempdestination.inuse");
                }
            }
            this.mDeleted = true;
        }
        if (log.isDebugEnabled()) {
            log.debug("Leaving delete");
        }
    }

    @Override
    public SolConnectionIF getConnection() {
        return this.mConnection;
    }

    @Override
    public boolean isDeleted() {
        return this.mDeleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConsumer(SolMessageConsumerIF consumer) throws JMSException {
        List<SolMessageConsumerIF> list = this.mConsumers;
        synchronized (list) {
            if (this.mDeleted) {
                throw new IllegalStateException(SolJMSErrorMessages.getMessage("soljms.operation.consumer.create", "soljms.error.tempdestination.deleted", null), "soljms.error.tempdestination.deleted");
            }
            this.mConsumers.add(consumer);
        }
    }
}

