/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms;

import com.solacesystems.jcsmp.DestinationUtils;
import com.solacesystems.jms.SolConnectionFactory;
import com.solacesystems.jms.SolConnectionFactoryImpl;
import com.solacesystems.jms.SolDestination;
import com.solacesystems.jms.SolQueue;
import com.solacesystems.jms.SolReferenceableDelegate;
import com.solacesystems.jms.SolTopic;
import com.solacesystems.jms.SolXAConnectionFactory;
import com.solacesystems.jms.SolXAConnectionFactoryImpl;
import com.solacesystems.jms.message.SolMessage;
import com.solacesystems.jms.property.JMSProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.Message;

public class SolJmsUtility {
    private static SolReferenceableDelegate ReferenceableDelegate = null;

    private SolJmsUtility() {
    }

    public static String dumpMessage(Message msg) {
        return ((SolMessage)msg).dump();
    }

    public static long getMessageSize(Message msg) throws JMSException {
        return ((SolMessage)msg).getMessageSize();
    }

    public static byte[] toByteArray(Message msg) throws JMSException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(msg);
            return baos.toByteArray();
        }
        catch (Exception e) {
            JMSException jmsEx = new JMSException(e.getMessage(), "serialization error");
            jmsEx.setLinkedException(e);
            throw jmsEx;
        }
    }

    public static Message fromByteArray(byte[] data) throws JMSException {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            ObjectInputStream ois = new ObjectInputStream(bais);
            return (Message)ois.readObject();
        }
        catch (Exception e) {
            JMSException jmsEx = new JMSException(e.getMessage(), "deserialization error");
            jmsEx.setLinkedException(e);
            throw jmsEx;
        }
    }

    public static SolConnectionFactory createConnectionFactory() throws Exception {
        SolConnectionFactoryImpl cf = new SolConnectionFactoryImpl();
        return cf;
    }

    public static SolConnectionFactory createConnectionFactory(Hashtable<?, ?> environment) throws Exception {
        JMSProperties props = new JMSProperties(environment);
        props.initialize();
        SolConnectionFactoryImpl cf = new SolConnectionFactoryImpl(props);
        return cf;
    }

    public static SolConnectionFactory createConnectionFactory(String host, String username, String password, String vpn, Hashtable<?, ?> environment) throws Exception {
        JMSProperties props = new JMSProperties(environment);
        props.initialize();
        SolConnectionFactoryImpl cf = new SolConnectionFactoryImpl(props);
        cf.setHost(host);
        cf.setUsername(username);
        cf.setPassword(password);
        cf.setVPN(vpn);
        return cf;
    }

    public static SolXAConnectionFactory createXAConnectionFactory() throws Exception {
        SolXAConnectionFactoryImpl cf = new SolXAConnectionFactoryImpl();
        return cf;
    }

    public static SolXAConnectionFactory createXAConnectionFactory(Hashtable<?, ?> environment) throws Exception {
        JMSProperties props = new JMSProperties(environment);
        props.initialize();
        SolXAConnectionFactoryImpl cf = new SolXAConnectionFactoryImpl(props);
        return cf;
    }

    public static SolXAConnectionFactory createXAConnectionFactory(String host, String username, String password, String vpn, Hashtable<?, ?> environment) throws Exception {
        JMSProperties props = new JMSProperties(environment);
        props.initialize();
        SolXAConnectionFactoryImpl cf = new SolXAConnectionFactoryImpl(props);
        cf.setHost(host);
        cf.setUsername(username);
        cf.setPassword(password);
        cf.setVPN(vpn);
        return cf;
    }

    public static SolTopic createTopic(String topicName) {
        return (SolTopic)((Object)SolDestination.createDestination(DestinationUtils.onlyInstance().topicFromNetworkName(topicName)));
    }

    public static SolQueue createQueue(String queueName) {
        return (SolQueue)((Object)SolDestination.createDestination(DestinationUtils.onlyInstance().queueFromNetworkName(queueName)));
    }

    public static void setReferenceableDelegate(SolReferenceableDelegate referenceableDelegate) {
        ReferenceableDelegate = referenceableDelegate;
    }

    public static SolReferenceableDelegate getReferenceableDelegate() {
        return ReferenceableDelegate;
    }
}

