/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.smf.impl;

import com.solacesystems.common.util.BitTwiddleUtil;
import com.solacesystems.common.util.NetworkByteOrderNumberUtil;

public class MessageElementDescription {
    private int type;
    private long sizeInBytes;
    private byte[] value;
    private int val_len;
    private int val_off;
    private boolean encoded;

    public static MessageElementDescription getEncodedMessageElementDescription(int type, long sizeInBytes) {
        return new MessageElementDescription(type, sizeInBytes);
    }

    public static MessageElementDescription getDecodedMessageElementDescription(int type, byte[] value, int val_length, int val_offset) {
        return new MessageElementDescription(type, value, val_length, val_offset);
    }

    private MessageElementDescription(int type, long sizeInBytes) {
        this.type = type;
        this.sizeInBytes = sizeInBytes;
        this.encoded = true;
        this.encode();
    }

    private MessageElementDescription(int type, byte[] value, int val_length, int val_offset) {
        this.type = type;
        this.value = value;
        this.encoded = false;
        this.val_len = val_length;
        this.val_off = val_offset;
        this.decode();
    }

    private void encode() {
        byte[] encodedSize = this.encodeSizeInBytes();
        int encodedLen = encodedSize.length + 1;
        long word1 = 0L;
        word1 = BitTwiddleUtil.setBits(word1, this.type, 4, 4);
        word1 = BitTwiddleUtil.setBits(word1, encodedLen, 4, 0);
        this.value = new byte[encodedLen];
        this.value[0] = NetworkByteOrderNumberUtil.intToOneByte((int)word1);
        System.arraycopy(encodedSize, 0, this.value, 1, encodedSize.length);
    }

    private void decode() {
        this.sizeInBytes = NetworkByteOrderNumberUtil.oneTwoThreeFourByteToUInt(this.value, this.val_len, this.val_off);
    }

    private byte[] encodeSizeInBytes() {
        byte[] value = null;
        if (this.sizeInBytes < 0L) {
            throw new IllegalArgumentException("element length cannot be negative.");
        }
        if (this.sizeInBytes <= 255L) {
            value = new byte[]{NetworkByteOrderNumberUtil.intToOneByte((int)this.sizeInBytes)};
        } else if (this.sizeInBytes <= 65535L) {
            value = NetworkByteOrderNumberUtil.intToTwoByte((int)this.sizeInBytes);
        } else if (this.sizeInBytes <= 0xFFFFFFL) {
            value = NetworkByteOrderNumberUtil.intToThreeByte(this.sizeInBytes);
        } else if (this.sizeInBytes <= 0xFFFFFFFFL) {
            value = NetworkByteOrderNumberUtil.intToFourByte(this.sizeInBytes);
        } else {
            throw new IllegalArgumentException("element length too long.");
        }
        return value;
    }

    public byte[] getValue() {
        if (!this.encoded) {
            throw new IllegalArgumentException("Cannot get value for decoded message element description");
        }
        return this.value;
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public int getType() {
        return this.type;
    }
}

