/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.flow;

import com.solacesystems.common.util.LogWrapper;
import com.solacesystems.jcsmp.Endpoint;
import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPInterruptedException;
import com.solacesystems.jcsmp.impl.JCSMPErrorResponseSubcodeMapper;
import com.solacesystems.jcsmp.impl.flow.FlowTask;
import com.solacesystems.jcsmp.impl.flow.TaskSessionRefs;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.impl.TcpChannel;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SMFHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SmfTLVParameter;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvParameterParser;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeoutException;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class UnbindRequestTask
extends FlowTask {
    private final LogWrapper Trace = new LogWrapper(UnbindRequestTask.class);
    private volatile long flowId;
    private boolean isUnsolicited;
    private boolean linger;
    private final Long lastMsgIdAcked;
    private TimeoutException timeoutException;
    private Long endpointErrorId;
    private static int counter = 0;
    private int _counter = counter++;

    public UnbindRequestTask(TaskSessionRefs t_refs, Endpoint bindToResource, long flowId, boolean isUnsolicited, boolean isLinger, Long lastMsgIdAcked, Long endpointErrorId) {
        super(bindToResource, t_refs);
        this.flowId = flowId;
        this.isUnsolicited = isUnsolicited;
        this.linger = isLinger;
        this.lastMsgIdAcked = lastMsgIdAcked;
        this.timeoutException = null;
        this.endpointErrorId = endpointErrorId;
        this.Trace.setContextInfo(this.taskRefs.getChannel().getLogContextInfo());
    }

    public UnbindRequestTask(TaskSessionRefs t_refs, Endpoint bindToResource, long flowId, boolean isUnsolicited, boolean isLinger, Long lastMsgIdAcked) {
        this(t_refs, bindToResource, flowId, isUnsolicited, isLinger, lastMsgIdAcked, null);
    }

    public UnbindRequestTask(TaskSessionRefs t_refs, Endpoint bindToResource, long flowId, boolean isUnsolicited, boolean isLinger) {
        this(t_refs, bindToResource, flowId, isUnsolicited, isLinger, null, null);
    }

    public String toString() {
        return String.format("[UBRT resource=%s flowId=%s counter=%s]", this.bindToResource, this.flowId, this._counter);
    }

    @Override
    public Object execute(Object obj) {
        long respFlowId;
        this.Trace.debug("Executing response handler.");
        this.cancelTimer();
        assert (obj instanceof WireMessage);
        WireMessage respMsg = (WireMessage)obj;
        SMFHeaderBean smfHeader = respMsg.getSmfHeader();
        assert (smfHeader.getProtocol() == 9);
        AssuredCtrlHeaderBean assBean = (AssuredCtrlHeaderBean)respMsg.getHeaderBean();
        SmfTLVParameter tlv = (SmfTLVParameter)assBean.findFirstParameter(6);
        this.flowId = respFlowId = TlvParameterParser.getAssuredFlowId(tlv);
        if (smfHeader.getPm_respcode() != 200) {
            String networkInfoString = "";
            if (this.subFlowMgr != null && this.subFlowMgr.subChannel != null) {
                networkInfoString = this.subFlowMgr.subChannel.getNetworkInfoString();
            }
            this.opEx = new JCSMPErrorResponseException(smfHeader.getPm_respcode(), smfHeader.getPm_respstr(), "", networkInfoString, JCSMPErrorResponseSubcodeMapper.ErrorContext.CONTROL);
            if (this.Trace.isInfoEnabled()) {
                this.Trace.info("Error Response (" + smfHeader.getPm_respcode() + ") - " + smfHeader.getPm_respstr() + "; subCode: " + ((JCSMPErrorResponseException)this.opEx).getSubcodeEx() + "; flowId=" + respFlowId);
            }
            this.Trace.debug("Got unbind exception. ", this.opEx);
        }
        if (this.isUnsolicited || this.opEx == null) {
            if (this.isUnsolicited) {
                tlv = (SmfTLVParameter)assBean.findFirstParameter(52);
                this.endpointErrorId = tlv == null ? null : Long.valueOf(TlvParameterParser.getEndpoinErrortId(tlv));
                this.Trace.debug(String.format("Got unsolicited unbind, flowId=%s, endpointErrorId=%s", this.flowId, this.endpointErrorId));
            } else {
                this.Trace.debug(String.format("Got OK unbindresponse, flowId=%s", this.flowId));
            }
        }
        this.responseLatch.countDown();
        return null;
    }

    @Override
    public boolean submit(int corrTag, boolean allowOnStateSub, TcpChannel.WriteBlockPolicy wpolicy) throws JCSMPException {
        this.initTimerFlag();
        boolean success = this.taskRefs.getChannel().sendUnbindRequest(this.flowId, corrTag, allowOnStateSub, this.linger, wpolicy, this.lastMsgIdAcked, this.endpointErrorId);
        this.startTimer();
        return success;
    }

    public boolean submit(Integer corrTag, boolean allowOnStateSub, TcpChannel.WriteBlockPolicy wpolicy) throws JCSMPException {
        this.initTimerFlag();
        boolean success = this.taskRefs.getChannel().sendUnbindRequest(this.flowId, corrTag, allowOnStateSub, this.linger, wpolicy, this.lastMsgIdAcked, this.endpointErrorId);
        this.startTimer();
        return success;
    }

    public long waitResponseGetFlowId() throws JCSMPException {
        block3: {
            try {
                this.responseLatch.await();
            }
            catch (InterruptedException e) {
                if (this.opEx != null) break block3;
                this.opEx = new JCSMPInterruptedException("Interrupted.", e);
            }
        }
        if (this.opEx != null && !this.isUnsolicited) {
            throw this.opEx;
        }
        return this.flowId;
    }

    public Long getEndpointErrorId() {
        return this.endpointErrorId;
    }

    public void waitResponse() throws JCSMPException, TimeoutException {
        try {
            this.responseLatch.await();
            if (this.timeoutException != null) {
                throw this.timeoutException;
            }
        }
        catch (InterruptedException e) {
            if (this.opEx == null) {
                this.opEx = new JCSMPInterruptedException("waitResponse interrupted.", e);
            }
        }
        finally {
            this.responseLatch = new CountDownLatch(1);
            this.timeoutException = null;
        }
        if (this.opEx != null && !this.isUnsolicited) {
            throw this.opEx;
        }
    }

    @Override
    public void handleTimeout() {
        this.timeoutException = new TimeoutException("Timeout performing unbind");
        this.responseLatch.countDown();
    }
}

