/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.compression;

import com.jcraft.jzlib.Deflater;
import com.jcraft.jzlib.GZIPException;
import com.solacesystems.jcsmp.impl.compression.BufferUtil;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SolZlibDeflater {
    private Deflater deflater = null;
    private int compressionLevel;
    private byte[] compressedOutput = null;
    private static final Log Trace = LogFactory.getLog(SolZlibDeflater.class);

    public SolZlibDeflater(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    public void setCompressionLevel(int newCompressionLevel) {
        this.compressionLevel = newCompressionLevel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long deflate(byte[] uncompressedOutput, int compressedOutputLen) throws IOException, IllegalArgumentException {
        if (compressedOutputLen <= 0) {
            throw new IllegalArgumentException("the size of the compressed byte array must be greater than zero");
        }
        try {
            if (this.deflater == null) {
                this.deflater = new Deflater(this.compressionLevel);
            } else {
                this.deflater.init(this.compressionLevel, 15, false);
            }
        }
        catch (GZIPException e) {
            throw new RuntimeException(e);
        }
        this.deflater.setInput(uncompressedOutput);
        this.compressedOutput = new byte[compressedOutputLen];
        this.deflater.setOutput(this.compressedOutput);
        int result = this.deflater.deflate(4);
        if (result == 1) {
            result = this.deflater.end();
            if (result == 0) return this.deflater.total_out;
            throw new IOException("JZlib deflater.end() error, result: " + this.deflater.getMessage());
        }
        if (result != 0 && result != -5) throw new IOException("JZlib deflater.deflate() error, result: " + result);
        int numBufferGrows = 1;
        while (result == 0 || result == -5) {
            if (Trace.isDebugEnabled()) {
                Trace.debug((Object)("SolZlibDeflater - Growing output buffer since more space is required for compression. Growth " + numBufferGrows));
            }
            this.compressedOutput = BufferUtil.growBuffer(this.compressedOutput, this.compressedOutput.length, this.compressedOutput.length * 2);
            this.deflater.setNextOut(this.compressedOutput);
            this.deflater.setAvailOut(this.compressedOutput.length - this.deflater.getNextOutIndex());
            result = this.deflater.deflate(4);
            ++numBufferGrows;
        }
        if (result != 1) throw new IOException("JZlib deflater.deflate() error, result: " + result);
        result = this.deflater.end();
        if (result == 0) return this.deflater.total_out;
        throw new IOException("JZlib deflater.end() error, message: " + this.deflater.getMessage());
    }

    public byte[] getCompressedOutput() {
        return this.compressedOutput != null ? this.compressedOutput : null;
    }
}

