/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.config;

import com.solacesystems.common.SolReserved;
import com.solacesystems.common.config.DataService;

@SolReserved
public class JMSService
extends DataService {
    private String mURL;
    private String mCompressedURL;
    private String mSecuredURL;
    private String mIpAddr;
    private Boolean mIsSecured;

    public JMSService(String ip, int port, int compressedPort, int securedPort, String vpn, String username, String password) {
        super(ip, port, compressedPort, securedPort, vpn, username, password);
        if (this.mIP.contains("wss://") || this.mIP.contains("ws://")) {
            this.mIpAddr = this.mIP.substring(this.mIP.indexOf("://") + 3);
            this.mURL = "ws://" + this.mIP.substring(this.mIP.indexOf("://") + 3) + ":" + this.mPort;
            this.mCompressedURL = "ws://" + this.mIP.substring(this.mIP.indexOf("://") + 3) + ":" + this.mCompressedPort;
            this.mSecuredURL = "wss://" + this.mIP.substring(this.mIP.indexOf("://") + 3) + ":" + this.mSecuredPort;
        } else if (this.mIP.indexOf("://") > 0) {
            this.mIpAddr = this.mIP.substring(this.mIP.indexOf("://") + 3);
            this.mURL = "smf://" + this.mIP.substring(this.mIP.indexOf("://") + 3) + ":" + this.mPort;
            this.mCompressedURL = "smf://" + this.mIP.substring(this.mIP.indexOf("://") + 3) + ":" + this.mCompressedPort;
            this.mSecuredURL = "smfs://" + this.mIP.substring(this.mIP.indexOf("://") + 3) + ":" + this.mSecuredPort;
        } else {
            this.mIpAddr = this.mIP;
            this.mURL = "smf://" + this.mIP + ":" + this.mPort;
            this.mCompressedURL = "smf://" + this.mIP + ":" + this.mCompressedPort;
            this.mSecuredURL = "smfs://" + this.mIP + ":" + this.mSecuredPort;
        }
        this.mIsSecured = this.mIP.contains("smfs") || this.mIP.contains("tcps") || this.mIP.contains("wss");
    }

    public JMSService(DataService dataService) {
        super(dataService.getIP(), dataService.getPort(), dataService.getCompressedPort(), dataService.getSecuredPort(), dataService.getVPN(), dataService.getUsername(), dataService.getPassword());
        if (this.mIP.contains("wss://") || this.mIP.contains("ws://")) {
            this.mIpAddr = this.mIP.substring(this.mIP.indexOf("://") + 3);
            this.mURL = "ws://" + this.mIP.substring(this.mIP.indexOf("://") + 3) + ":" + this.mPort;
            this.mCompressedURL = "ws://" + this.mIP.substring(this.mIP.indexOf("://") + 3) + ":" + this.mCompressedPort;
            this.mSecuredURL = "wss://" + this.mIP.substring(this.mIP.indexOf("://") + 3) + ":" + this.mSecuredPort;
        } else if (this.mIP.indexOf("://") > 0) {
            this.mIpAddr = this.mIP.substring(this.mIP.indexOf("://") + 3);
            this.mURL = "smf://" + this.mIP.substring(this.mIP.indexOf("://") + 3) + ":" + this.mPort;
            this.mCompressedURL = "smf://" + this.mIP.substring(this.mIP.indexOf("://") + 3) + ":" + this.mCompressedPort;
            this.mSecuredURL = "smfs://" + this.mIP.substring(this.mIP.indexOf("://") + 3) + ":" + this.mSecuredPort;
        } else {
            this.mIpAddr = this.mIP;
            this.mURL = "smf://" + this.mIP + ":" + this.mPort;
            this.mCompressedURL = "smf://" + this.mIP + ":" + this.mCompressedPort;
            this.mSecuredURL = "smfs://" + this.mIP + ":" + this.mSecuredPort;
        }
        this.mIsSecured = this.mIP.contains("smfs") || this.mIP.contains("tcps") || this.mIP.contains("wss");
    }

    public String getSecuredURL() {
        return this.mSecuredURL;
    }

    public boolean isWebSocket() {
        return this.mURL.contains("ws");
    }

    public String getCompressedURL() {
        return this.mIsSecured != false ? this.mSecuredURL : this.mCompressedURL;
    }

    public String getURL() {
        return this.mIsSecured != false ? this.mSecuredURL : this.mURL;
    }

    public String getIpAddr() {
        return this.mIpAddr;
    }

    public Boolean isSecured() {
        return this.mIsSecured;
    }

    @Override
    public int getPort() {
        return this.mIsSecured != false ? this.mSecuredPort : this.mPort;
    }

    @Override
    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("url=" + this.mURL);
        bldr.append(", compurl=" + this.mCompressedURL);
        bldr.append(", vpn=" + this.getVPN());
        return bldr.toString();
    }
}

