/*
 * Decompiled with CFR 0.152.
 */
package com.solace.transport;

public class TransportHttpProxyConfiguration {
    private final String proxyHost;
    private int proxyPort;
    private String username;
    private String passwd;

    public TransportHttpProxyConfiguration(String address) {
        this.proxyHost = address;
        this.proxyPort = 3128;
        this.username = null;
        this.passwd = null;
    }

    public TransportHttpProxyConfiguration withUsernamePassword(String user, String password) {
        this.username = user;
        this.passwd = password;
        return this;
    }

    public TransportHttpProxyConfiguration withPort(int port) {
        this.proxyPort = port;
        return this;
    }

    public String getHost() {
        return this.proxyHost;
    }

    public int getPort() {
        return this.proxyPort;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.passwd;
    }

    public String toString() {
        if (this.username != null) {
            return "via HTTP proxy(" + this.username + "@" + this.proxyPort + "/" + this.proxyHost + ")";
        }
        return "via HTTP proxy(" + this.proxyHost + "/" + this.proxyPort + ")";
    }
}

